/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.mbus.learn;

import com.tridium.mbus.BAbstractMbusNetwork;
import com.tridium.mbus.BMbusDevice;
import com.tridium.mbus.db.BMbusDeviceData;
import com.tridium.mbus.db.BMbusPointData;
import com.tridium.mbus.learn.BMbusPointEntry;
import com.tridium.mbus.utils.MbusToolkit;
import javax.baja.job.BJob;
import javax.baja.job.BSimpleJob;
import javax.baja.job.JobLog;
import javax.baja.job.JobLogItem;
import javax.baja.naming.BOrd;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public final class BMbusPointDiscoveryJob
extends BSimpleJob {
    public static final Property networkOrd = BMbusPointDiscoveryJob.newProperty((int)0, (BValue)BOrd.NULL, null);
    public static final Property deviceOrd = BMbusPointDiscoveryJob.newProperty((int)0, (BValue)BOrd.NULL, null);
    public static final Property previousJobOrd = BMbusPointDiscoveryJob.newProperty((int)0, (BValue)BOrd.NULL, null);
    public static final Type TYPE = Sys.loadType(BMbusPointDiscoveryJob.class);

    public BOrd getNetworkOrd() {
        return (BOrd)this.get(networkOrd);
    }

    public void setNetworkOrd(BOrd v) {
        this.set(networkOrd, (BValue)v, null);
    }

    public BOrd getDeviceOrd() {
        return (BOrd)this.get(deviceOrd);
    }

    public void setDeviceOrd(BOrd v) {
        this.set(deviceOrd, (BValue)v, null);
    }

    public BOrd getPreviousJobOrd() {
        return (BOrd)this.get(previousJobOrd);
    }

    public void setPreviousJobOrd(BOrd v) {
        this.set(previousJobOrd, (BValue)v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BMbusPointDiscoveryJob() {
    }

    public BMbusPointDiscoveryJob(BOrd networkOrd, BOrd deviceOrd, BOrd prevJobOrd) {
        this.setNetworkOrd(networkOrd);
        this.setDeviceOrd(deviceOrd);
        this.setPreviousJobOrd(prevJobOrd);
    }

    public void run(Context cx) throws Exception {
        if (this.getPreviousJobOrd() != BOrd.NULL) {
            try {
                BObject prevJobInstance = this.getPreviousJobOrd().get((BObject)this);
                if (prevJobInstance != null && prevJobInstance instanceof BJob) {
                    JobLog jLog = ((BJob)prevJobInstance).log();
                    JobLogItem[] jbLogItems = jLog.getItems();
                    this.log().message(MbusToolkit.lex.getText("MbusNetworkPointDiscovery.dataSourceOutputStart", new Object[]{String.valueOf(((BJob)prevJobInstance).getDisplayName(null))}));
                    for (int i = 0; i < jbLogItems.length; ++i) {
                        String data;
                        if (jbLogItems[i] == null || (data = jbLogItems[i].getMessage()).trim().length() <= 0) continue;
                        this.log().message("--> " + data);
                    }
                    this.log().message(MbusToolkit.getText("MbusNetworkPointDiscovery.dataSourceOutputEnd"));
                }
            }
            catch (Throwable prevJobInstance) {
                // empty catch block
            }
        }
        BAbstractMbusNetwork network = (BAbstractMbusNetwork)this.getNetworkOrd().get((BObject)this);
        BMbusDevice device = (BMbusDevice)this.getDeviceOrd().get((BObject)this);
        BMbusDeviceData deviceData = network.getNetworkDatabase().getSpecificDeviceInformation(device);
        if (deviceData != null) {
            this.log().message(MbusToolkit.getText("MbusNetworkPointDsicovery.transferStart"));
            BMbusPointData[] pointData = deviceData.getDynamicPointData();
            int numberOfDataBlocks = pointData.length;
            for (int j = 0; j < numberOfDataBlocks; ++j) {
                BMbusPointEntry entry = new BMbusPointEntry();
                entry.setMbusUnit(pointData[j].getUnit());
                entry.setDescription(pointData[j].getDescription());
                entry.setOrthogonalDescription(pointData[j].getOrthogonalDescription());
                entry.setNumberType(pointData[j].getNumberType());
                entry.setMessageSlotNumber(pointData[j].getMessageSlotNumber());
                entry.setRecordNumber(pointData[j].getRecordNumber());
                entry.setCycleNumber(pointData[j].getCycleNumber());
                entry.setStorageNumber(pointData[j].getStorageNumber());
                entry.setExponent(pointData[j].getExponent());
                entry.setFunction(pointData[j].getFunction());
                entry.setDeviceMode(pointData[j].getDeviceMode());
                if (entry.getCycleNumber() >= device.getCycleQuantity()) continue;
                this.add(null, (BValue)entry);
            }
            this.log().message(MbusToolkit.getText("MbusNetworkPointDsicovery.transferEnd"));
        }
    }
}

