/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.mbus.learn;

import com.tridium.mbus.BAbstractMbusNetwork;
import com.tridium.mbus.BMbusDevice;
import com.tridium.mbus.db.BMbusDeviceData;
import com.tridium.mbus.db.BMbusPointData;
import com.tridium.mbus.enums.BMbusNumberType;
import com.tridium.mbus.enums.BMbusOrthogonalDescription;
import com.tridium.mbus.learn.BMbusHistoryImportEntry;
import javax.baja.history.BHistoryId;
import javax.baja.job.BSimpleJob;
import javax.baja.naming.BOrd;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public final class BMbusHistoryImportDiscoveryJob
extends BSimpleJob {
    public static final Property networkOrd = BMbusHistoryImportDiscoveryJob.newProperty((int)0, (BValue)BOrd.NULL, null);
    public static final Property deviceOrd = BMbusHistoryImportDiscoveryJob.newProperty((int)0, (BValue)BOrd.NULL, null);
    public static final Property numberType = BMbusHistoryImportDiscoveryJob.newProperty((int)4, (BValue)BMbusNumberType.notKnown, null);
    public static final Type TYPE = Sys.loadType(BMbusHistoryImportDiscoveryJob.class);

    public BOrd getNetworkOrd() {
        return (BOrd)this.get(networkOrd);
    }

    public void setNetworkOrd(BOrd v) {
        this.set(networkOrd, (BValue)v, null);
    }

    public BOrd getDeviceOrd() {
        return (BOrd)this.get(deviceOrd);
    }

    public void setDeviceOrd(BOrd v) {
        this.set(deviceOrd, (BValue)v, null);
    }

    public BMbusNumberType getNumberType() {
        return (BMbusNumberType)this.get(numberType);
    }

    public void setNumberType(BMbusNumberType v) {
        this.set(numberType, (BValue)v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BMbusHistoryImportDiscoveryJob() {
    }

    public BMbusHistoryImportDiscoveryJob(BOrd networkOrd, BOrd deviceOrd) {
        this.setNetworkOrd(networkOrd);
        this.setDeviceOrd(deviceOrd);
    }

    public void run(Context cx) throws Exception {
        BAbstractMbusNetwork network = (BAbstractMbusNetwork)this.getNetworkOrd().get((BObject)this);
        BMbusDevice device = (BMbusDevice)this.getDeviceOrd().get((BObject)this);
        BMbusDeviceData deviceData = network.getNetworkDatabase().getSpecificDeviceInformation(device);
        if (deviceData != null) {
            BMbusPointData[] pointData = deviceData.getDynamicPointData();
            BMbusPointData[] pointDataHold = new BMbusPointData[pointData.length];
            int dataFreeIndex = 0;
            for (int i = 0; i < pointData.length; ++i) {
                BMbusPointData parameterSet = pointData[i];
                if (parameterSet.getCycleNumber() >= device.getCycleQuantity()) continue;
                boolean match = false;
                for (int k = 0; k < dataFreeIndex; ++k) {
                    if (!pointDataHold[k].getUnit().equals((Object)parameterSet.getUnit()) || !pointDataHold[k].getDescription().equals(parameterSet.getDescription()) || !pointDataHold[k].getFunction().equals((Object)parameterSet.getFunction()) || pointDataHold[k].getRecordNumber() != parameterSet.getRecordNumber() || pointDataHold[k].getDeviceMode() != parameterSet.getDeviceMode() || pointDataHold[k].getMessageSlotNumber() != parameterSet.getMessageSlotNumber() || !pointDataHold[k].getOrthogonalDescription().equals((Object)parameterSet.getOrthogonalDescription())) continue;
                    pointDataHold[k].setStorageNumber(-1);
                    match = true;
                    break;
                }
                if (match) continue;
                pointDataHold[dataFreeIndex] = new BMbusPointData();
                pointDataHold[dataFreeIndex].setUnit(parameterSet.getUnit());
                pointDataHold[dataFreeIndex].setDescription(parameterSet.getDescription());
                pointDataHold[dataFreeIndex].setOrthogonalDescription(parameterSet.getOrthogonalDescription());
                pointDataHold[dataFreeIndex].setNumberType(parameterSet.getNumberType());
                pointDataHold[dataFreeIndex].setMessageSlotNumber(parameterSet.getMessageSlotNumber());
                pointDataHold[dataFreeIndex].setRecordNumber(parameterSet.getRecordNumber());
                pointDataHold[dataFreeIndex].setCycleNumber(parameterSet.getCycleNumber());
                pointDataHold[dataFreeIndex].setStorageNumber(parameterSet.getStorageNumber());
                pointDataHold[dataFreeIndex].setExponent(parameterSet.getExponent());
                pointDataHold[dataFreeIndex].setFunction(parameterSet.getFunction());
                pointDataHold[dataFreeIndex].setDeviceMode(parameterSet.getDeviceMode());
                ++dataFreeIndex;
            }
            for (int j = 0; j < dataFreeIndex; ++j) {
                BMbusHistoryImportEntry entry = new BMbusHistoryImportEntry();
                entry.setMbusUnit(pointDataHold[j].getUnit());
                entry.setDescription(pointDataHold[j].getDescription());
                entry.setOrthogonalDescription(pointDataHold[j].getOrthogonalDescription());
                entry.setNumberType(pointDataHold[j].getNumberType());
                entry.setFunction(pointDataHold[j].getFunction());
                entry.setExponent(pointDataHold[j].getExponent());
                entry.setRecordNumber(pointDataHold[j].getRecordNumber());
                entry.setCycleNumber(pointDataHold[j].getCycleNumber());
                entry.setMessageSlotNumber(pointDataHold[j].getMessageSlotNumber());
                entry.setStorageNumber(pointDataHold[j].getStorageNumber());
                entry.setDeviceMode(pointDataHold[j].getDeviceMode());
                String wholeName = "";
                wholeName = !entry.getOrthogonalDescription().equals((Object)BMbusOrthogonalDescription.none) ? entry.getDescription().toString() + " " + entry.getOrthogonalDescription().toString() : entry.getDescription().toString();
                if (entry.getMessageSlotNumber() != 0) {
                    wholeName = wholeName + new Integer(entry.getMessageSlotNumber()).toString();
                }
                entry.setHistoryId(BHistoryId.make((String)device.getName(), (String)wholeName));
                if (entry.getCycleNumber() >= device.getCycleQuantity()) continue;
                this.add(null, (BValue)entry);
            }
        }
    }
}

