/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.mbus.learn;

import com.tridium.mbus.BMbusConfig;
import com.tridium.mbus.BMbusDevice;
import com.tridium.mbus.enums.BMbusAddressing;
import com.tridium.mbus.enums.BMbusBaudRate;
import com.tridium.mbus.enums.BMbusDeviceTypeId;
import javax.baja.sys.BComponent;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public final class BMbusDeviceEntry
extends BComponent {
    public static final Property modelName = BMbusDeviceEntry.newProperty((int)0, (String)"", null);
    public static final Property primaryAddress = BMbusDeviceEntry.newProperty((int)0, (int)0, null);
    public static final Property secondaryAddress = BMbusDeviceEntry.newProperty((int)0, (String)"", null);
    public static final Property addressMode = BMbusDeviceEntry.newProperty((int)0, (BValue)BMbusAddressing.primary, null);
    public static final Property cycleQuantity = BMbusDeviceEntry.newProperty((int)16, (int)1, null);
    public static final Property resetRequired = BMbusDeviceEntry.newProperty((int)0, (boolean)true, null);
    public static final Property fcBitInUse = BMbusDeviceEntry.newProperty((int)0, (boolean)false, null);
    public static final Property fcBitState = BMbusDeviceEntry.newProperty((int)0, (boolean)false, null);
    public static final Property identNumber = BMbusDeviceEntry.newProperty((int)4, (String)"", null);
    public static final Property manufacturer = BMbusDeviceEntry.newProperty((int)0, (String)"", null);
    public static final Property versionNumber = BMbusDeviceEntry.newProperty((int)4, (int)0, null);
    public static final Property deviceTypeId = BMbusDeviceEntry.newProperty((int)0, (BValue)BMbusDeviceTypeId.other, null);
    public static final Property baudRate = BMbusDeviceEntry.newProperty((int)1, (BValue)BMbusBaudRate.baud300, null);
    public static final Property txRxMbusConfig = BMbusDeviceEntry.newProperty((int)0, (BValue)new BMbusConfig(), null);
    public static final Type TYPE = Sys.loadType(BMbusDeviceEntry.class);

    public String getModelName() {
        return this.getString(modelName);
    }

    public void setModelName(String v) {
        this.setString(modelName, v, null);
    }

    public int getPrimaryAddress() {
        return this.getInt(primaryAddress);
    }

    public void setPrimaryAddress(int v) {
        this.setInt(primaryAddress, v, null);
    }

    public String getSecondaryAddress() {
        return this.getString(secondaryAddress);
    }

    public void setSecondaryAddress(String v) {
        this.setString(secondaryAddress, v, null);
    }

    public BMbusAddressing getAddressMode() {
        return (BMbusAddressing)this.get(addressMode);
    }

    public void setAddressMode(BMbusAddressing v) {
        this.set(addressMode, (BValue)v, null);
    }

    public int getCycleQuantity() {
        return this.getInt(cycleQuantity);
    }

    public void setCycleQuantity(int v) {
        this.setInt(cycleQuantity, v, null);
    }

    public boolean getResetRequired() {
        return this.getBoolean(resetRequired);
    }

    public void setResetRequired(boolean v) {
        this.setBoolean(resetRequired, v, null);
    }

    public boolean getFcBitInUse() {
        return this.getBoolean(fcBitInUse);
    }

    public void setFcBitInUse(boolean v) {
        this.setBoolean(fcBitInUse, v, null);
    }

    public boolean getFcBitState() {
        return this.getBoolean(fcBitState);
    }

    public void setFcBitState(boolean v) {
        this.setBoolean(fcBitState, v, null);
    }

    public String getIdentNumber() {
        return this.getString(identNumber);
    }

    public void setIdentNumber(String v) {
        this.setString(identNumber, v, null);
    }

    public String getManufacturer() {
        return this.getString(manufacturer);
    }

    public void setManufacturer(String v) {
        this.setString(manufacturer, v, null);
    }

    public int getVersionNumber() {
        return this.getInt(versionNumber);
    }

    public void setVersionNumber(int v) {
        this.setInt(versionNumber, v, null);
    }

    public BMbusDeviceTypeId getDeviceTypeId() {
        return (BMbusDeviceTypeId)this.get(deviceTypeId);
    }

    public void setDeviceTypeId(BMbusDeviceTypeId v) {
        this.set(deviceTypeId, (BValue)v, null);
    }

    public BMbusBaudRate getBaudRate() {
        return (BMbusBaudRate)this.get(baudRate);
    }

    public void setBaudRate(BMbusBaudRate v) {
        this.set(baudRate, (BValue)v, null);
    }

    public BMbusConfig getTxRxMbusConfig() {
        return (BMbusConfig)this.get(txRxMbusConfig);
    }

    public void setTxRxMbusConfig(BMbusConfig v) {
        this.set(txRxMbusConfig, (BValue)v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public boolean is(BComponent component) {
        if (component instanceof BMbusDevice) {
            BMbusDevice device = (BMbusDevice)component;
            if (!device.getModelName().equals("") && device.getModelName().equals(this.getModelName())) {
                return true;
            }
            if (this.getPrimaryAddress() == 253 ? device.getSecondaryAddress().equals(this.getSecondaryAddress()) : device.getPrimaryAddress() == this.getPrimaryAddress()) {
                return true;
            }
        }
        return false;
    }
}

