/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.mbus.learn;

import com.tridium.mbus.BAbstractMbusNetwork;
import com.tridium.mbus.BMbusConfig;
import com.tridium.mbus.db.BMbusDeviceData;
import com.tridium.mbus.learn.BMbusDeviceEntry;
import com.tridium.mbus.utils.MbusToolkit;
import javax.baja.job.BJob;
import javax.baja.job.BSimpleJob;
import javax.baja.job.JobLog;
import javax.baja.job.JobLogItem;
import javax.baja.naming.BOrd;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public final class BMbusDeviceDiscoveryJob
extends BSimpleJob {
    public static final Property prevJob = BMbusDeviceDiscoveryJob.newProperty((int)261, (BValue)BOrd.NULL, null);
    public static final Type TYPE = Sys.loadType(BMbusDeviceDiscoveryJob.class);
    private BAbstractMbusNetwork network = null;

    public BOrd getPrevJob() {
        return (BOrd)this.get(prevJob);
    }

    public void setPrevJob(BOrd v) {
        this.set(prevJob, (BValue)v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BMbusDeviceDiscoveryJob() {
    }

    public BMbusDeviceDiscoveryJob(BAbstractMbusNetwork network) {
        this.network = network;
    }

    public void run(Context cx) throws Exception {
        if (prevJob != null && this.getPrevJob() != BOrd.NULL) {
            try {
                BObject prevJobInstance = this.getPrevJob().get((BObject)this);
                if (prevJobInstance != null && prevJobInstance instanceof BJob) {
                    JobLog jLog = ((BJob)prevJobInstance).log();
                    JobLogItem[] jbLogItems = jLog.getItems();
                    this.log().message(MbusToolkit.lex.getText("MbusDeviceDiscoveryJob.dataSourceOutputStart", new Object[]{String.valueOf(((BJob)prevJobInstance).getDisplayName(null))}));
                    for (int i = 0; i < jbLogItems.length; ++i) {
                        String data;
                        if (jbLogItems[i] == null || (data = jbLogItems[i].getMessage()).trim().length() <= 0) continue;
                        this.log().message("--> " + data);
                    }
                    this.log().message(MbusToolkit.getText("MbusDeviceDiscoveryJob.dataSourceOutputEnd"));
                }
            }
            catch (Throwable prevJobInstance) {
                // empty catch block
            }
        }
        try {
            this.progress(0);
            BMbusDeviceData[] currentDevices = this.network.getNetworkDatabase().getDynamicDeviceData();
            this.progress(0);
            for (int i = 0; i < currentDevices.length; ++i) {
                BMbusDeviceData deviceInformation = currentDevices[i];
                BMbusDeviceEntry entry = new BMbusDeviceEntry();
                if (deviceInformation.getJustDetected()) {
                    entry.setPrimaryAddress(deviceInformation.getPrimaryAddress());
                    entry.setSecondaryAddress(deviceInformation.getSecondaryAddress());
                    entry.setTxRxMbusConfig((BMbusConfig)deviceInformation.getTxRxMbusConfig().newCopy(true));
                    entry.getTxRxMbusConfig().setOverrideNetwork(true);
                    entry.setIdentNumber(deviceInformation.getIdentNumber());
                    entry.setManufacturer(deviceInformation.getManufacturer());
                    entry.setVersionNumber(deviceInformation.getVersionNumber());
                    entry.setDeviceTypeId(deviceInformation.getDeviceTypeId());
                    entry.setBaudRate(deviceInformation.getBaudRate());
                    entry.setFcBitInUse(deviceInformation.getFcBitInUse());
                    entry.setFcBitState(deviceInformation.getFcBitState());
                    entry.setAddressMode(deviceInformation.getAddressMode());
                    this.add(null, (BValue)entry);
                    this.progress((int)((double)i / (double)currentDevices.length * 100.0));
                }
                double temp = (double)i / (double)currentDevices.length;
                int progressPerCent = (int)(temp * 100.0);
                this.progress(progressPerCent);
            }
            this.progress(100);
        }
        catch (Exception e) {
            MbusToolkit.error("Error discoverying devices", e);
            throw e;
        }
    }
}

