/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.mbus.history;

import com.tridium.mbus.BAbstractMbusNetwork;
import com.tridium.mbus.BMbusDevice;
import com.tridium.mbus.comm.MBusTxTimings;
import com.tridium.mbus.enums.BMbusAddressing;
import com.tridium.mbus.enums.BMbusFunction;
import com.tridium.mbus.enums.BMbusNumberType;
import com.tridium.mbus.enums.BMbusOrthogonalDescription;
import com.tridium.mbus.enums.BMbusUnit;
import com.tridium.mbus.messages.MbusReceivedLongFrame;
import com.tridium.mbus.messages.MbusReqUd2Message;
import com.tridium.mbus.messages.MbusResponseMessage;
import com.tridium.mbus.messages.MbusSndNkeMessage;
import com.tridium.mbus.messages.MbusSndUdMessage;
import com.tridium.mbus.mspec.BManuSpecDefElement;
import com.tridium.mbus.types.BMbusCommand;
import com.tridium.mbus.utils.MbusDataSort;
import com.tridium.mbus.utils.MbusLogInputOutput;
import com.tridium.mbus.utils.MbusSortedDataInformation;
import com.tridium.mbus.utils.MbusToolkit;
import javax.baja.data.BIDataValue;
import javax.baja.driver.BDevice;
import javax.baja.driver.history.BHistoryImport;
import javax.baja.driver.point.conv.BLinearConversion;
import javax.baja.history.BBooleanTrendRecord;
import javax.baja.history.BHistoryConfig;
import javax.baja.history.BHistoryService;
import javax.baja.history.BIHistory;
import javax.baja.history.BIHistoryRecordSet;
import javax.baja.history.BNumericTrendRecord;
import javax.baja.history.db.BHistoryDatabase;
import javax.baja.history.db.HistoryDatabaseConnection;
import javax.baja.naming.BOrd;
import javax.baja.serial.BBaudRate;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusBoolean;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusValue;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.timezone.BTimeZone;
import javax.baja.util.BTypeSpec;
import javax.baja.util.IFuture;
import javax.baja.util.Invocation;
import javax.baja.util.Lexicon;

public final class BMbusHistoryImport
extends BHistoryImport {
    public static final Property description = BMbusHistoryImport.newProperty((int)4, (String)"", null);
    public static final Property orthogonalDescription = BMbusHistoryImport.newProperty((int)4, (BValue)BMbusOrthogonalDescription.none, null);
    public static final Property function = BMbusHistoryImport.newProperty((int)0, (BValue)BMbusFunction.instantaneous, null);
    public static final Property exponent = BMbusHistoryImport.newProperty((int)0, (int)1, null);
    public static final Property numberType = BMbusHistoryImport.newProperty((int)4, (BValue)BMbusNumberType.notKnown, null);
    public static final Property mbusUnit = BMbusHistoryImport.newProperty((int)4, (BValue)BMbusUnit.none, null);
    public static final Property recordNumber = BMbusHistoryImport.newProperty((int)0, (int)0, null);
    public static final Property messageSlotNumber = BMbusHistoryImport.newProperty((int)0, (int)0, null);
    public static final Property storageNumber = BMbusHistoryImport.newProperty((int)0, (int)0, null);
    public static final Property deviceMode = BMbusHistoryImport.newProperty((int)16, (int)0, (BFacets)BFacets.make((String)"fieldWidth", (BIDataValue)BInteger.make((int)2)));
    public static final Property facets = BMbusHistoryImport.newProperty((int)0, (BValue)BFacets.DEFAULT, null);
    public static final Property conversion = BMbusHistoryImport.newProperty((int)0, (BValue)BLinearConversion.DEFAULT, (BFacets)BFacets.make((String)"fieldEditor", (String)"driver:LinearConversionFE"));
    public static final Property manuSpecDefElementOrd = BMbusHistoryImport.newProperty((int)0, (BValue)BOrd.NULL, null);
    public static final Type TYPE = Sys.loadType(BMbusHistoryImport.class);
    private static final String VALUE_FACETS = "valueFacets";
    private static Lexicon lex = Lexicon.make(BMbusHistoryImport.class);
    private static int[] manufacturersData = null;

    public String getDescription() {
        return this.getString(description);
    }

    public void setDescription(String v) {
        this.setString(description, v, null);
    }

    public BMbusOrthogonalDescription getOrthogonalDescription() {
        return (BMbusOrthogonalDescription)this.get(orthogonalDescription);
    }

    public void setOrthogonalDescription(BMbusOrthogonalDescription v) {
        this.set(orthogonalDescription, (BValue)v, null);
    }

    public BMbusFunction getFunction() {
        return (BMbusFunction)this.get(function);
    }

    public void setFunction(BMbusFunction v) {
        this.set(function, (BValue)v, null);
    }

    public int getExponent() {
        return this.getInt(exponent);
    }

    public void setExponent(int v) {
        this.setInt(exponent, v, null);
    }

    public BMbusNumberType getNumberType() {
        return (BMbusNumberType)this.get(numberType);
    }

    public void setNumberType(BMbusNumberType v) {
        this.set(numberType, (BValue)v, null);
    }

    public BMbusUnit getMbusUnit() {
        return (BMbusUnit)this.get(mbusUnit);
    }

    public void setMbusUnit(BMbusUnit v) {
        this.set(mbusUnit, (BValue)v, null);
    }

    public int getRecordNumber() {
        return this.getInt(recordNumber);
    }

    public void setRecordNumber(int v) {
        this.setInt(recordNumber, v, null);
    }

    public int getMessageSlotNumber() {
        return this.getInt(messageSlotNumber);
    }

    public void setMessageSlotNumber(int v) {
        this.setInt(messageSlotNumber, v, null);
    }

    public int getStorageNumber() {
        return this.getInt(storageNumber);
    }

    public void setStorageNumber(int v) {
        this.setInt(storageNumber, v, null);
    }

    public int getDeviceMode() {
        return this.getInt(deviceMode);
    }

    public void setDeviceMode(int v) {
        this.setInt(deviceMode, v, null);
    }

    public BFacets getFacets() {
        return (BFacets)this.get(facets);
    }

    public void setFacets(BFacets v) {
        this.set(facets, (BValue)v, null);
    }

    public BLinearConversion getConversion() {
        return (BLinearConversion)this.get(conversion);
    }

    public void setConversion(BLinearConversion v) {
        this.set(conversion, (BValue)v, null);
    }

    public BOrd getManuSpecDefElementOrd() {
        return (BOrd)this.get(manuSpecDefElementOrd);
    }

    public void setManuSpecDefElementOrd(BOrd v) {
        this.set(manuSpecDefElementOrd, (BValue)v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void doExecute() {
        String commsLock = "HistImp" + this.getHandle();
        BAbstractMbusNetwork network = (BAbstractMbusNetwork)this.getNetwork();
        try {
            this.doExecute(network, commsLock);
            network.unlockSends(commsLock);
        }
        catch (Throwable e) {
            network.unlockSends(commsLock);
        }
    }

    public void doExecute(BAbstractMbusNetwork network, Object commsLock) {
        try {
            long minRxTxTimes;
            if (!this.isRunning()) {
                return;
            }
            boolean localTrace = MbusToolkit.isTraceOn();
            if (!this.getHistoryId().isValid()) {
                if (localTrace) {
                    MbusToolkit.trace("History Id is invalid");
                }
                return;
            }
            BMbusDevice device = (BMbusDevice)this.getDevice();
            if (device == null || network == null) {
                MbusToolkit.error("Could not find valid device or network");
                return;
            }
            this.executeInProgress();
            BHistoryService service = (BHistoryService)Sys.getService((Type)BHistoryService.TYPE);
            BHistoryDatabase db = service.getDatabase();
            if (db == null) {
                this.executeFail(lex.getText("BMbusHistoryImport.databaseError"));
                MbusToolkit.error("Could not find database");
                return;
            }
            if (device.getAddressMode() != BMbusAddressing.primary) {
                MbusSndUdMessage message2 = new MbusSndUdMessage(device, network);
                message2.setMessageBaudRate(device.getBaudRate());
                minRxTxTimes = MBusTxTimings.calculateTxRxTime(2L, (BBaudRate)device.getBaudRate());
                MbusResponseMessage resp = (MbusResponseMessage)network.sendMBusSync(device.getTxTimingsReference(), commsLock, message2, minRxTxTimes += MBusTxTimings.calculateTxRxTime(message2, (BBaudRate)device.getBaudRate()));
                if (resp != null && resp.getCollisionDetected()) {
                    this.executeFail(lex.getText("BMbusGeneral.busSelectionFailure"));
                    network.unlockSends(commsLock);
                    throw new Exception("Secondary address selection collision");
                }
                device.setFcBitState(true);
            }
            if (device.getResetRequired()) {
                MbusSndNkeMessage resetMessage = new MbusSndNkeMessage(device, network, 0);
                resetMessage.setMessageBaudRate(device.getBaudRate());
                if (MbusLogInputOutput.log.isTraceOn()) {
                    MbusLogInputOutput.log.trace("History Reset to Meter:- " + device.getPrimaryAddress() + "Sec Add= " + device.getSecondaryAddress());
                }
                minRxTxTimes = MBusTxTimings.calculateTxRxTime(2L, (BBaudRate)device.getBaudRate());
                network.sendMBusSync(device.getTxTimingsReference(), commsLock, resetMessage, minRxTxTimes += MBusTxTimings.calculateTxRxTime(resetMessage, (BBaudRate)device.getBaudRate()));
                if (device.getAddressMode() != BMbusAddressing.primary) {
                    MbusSndUdMessage message2 = new MbusSndUdMessage(device, network);
                    message2.setMessageBaudRate(device.getBaudRate());
                    long minRxTxTimes2 = MBusTxTimings.calculateTxRxTime(2L, (BBaudRate)device.getBaudRate());
                    MbusResponseMessage resp = (MbusResponseMessage)network.sendMBusSync(device.getTxTimingsReference(), commsLock, message2, minRxTxTimes2 += MBusTxTimings.calculateTxRxTime(message2, (BBaudRate)device.getBaudRate()));
                    if (resp != null && resp.getCollisionDetected()) {
                        this.executeFail(lex.getText("BMbusGeneral.busSelectionFailure"));
                        network.unlockSends(commsLock);
                        throw new Exception("Secondary address selection collision");
                    }
                }
                device.setFcBitState(true);
            }
            boolean validMode = false;
            if (this.getDeviceMode() != device.getReadoutModeNumber()) {
                BMbusCommand[] kids = (BMbusCommand[])device.getChildren(BMbusCommand.class);
                if (kids.length > 0 && kids[0].changeMode(this.getDeviceMode())) {
                    validMode = true;
                }
            } else {
                validMode = true;
            }
            if (!validMode) {
                this.executeFail(lex.getText("BMbusHistoryImport.incorrectMeterMode"));
                return;
            }
            try (HistoryDatabaseConnection conn = db.getDbConnection(null);){
                for (int msgIndex = 0; msgIndex < device.getCycleQuantity(); ++msgIndex) {
                    MbusReqUd2Message commandMessage = new MbusReqUd2Message(device, network);
                    commandMessage.setMessageBaudRate(device.getBaudRate());
                    if (MbusLogInputOutput.log.isTraceOn()) {
                        MbusLogInputOutput.log.trace("History to Meter:- " + device.getPrimaryAddress() + "  Sec Add= " + device.getSecondaryAddress() + "  Cycle= " + msgIndex);
                    }
                    long minRxTxTimes3 = MBusTxTimings.calculateTxRxTime(2L, (BBaudRate)device.getBaudRate());
                    MbusResponseMessage rsp = (MbusResponseMessage)network.sendMBusSync(device.getTxTimingsReference(), commsLock, commandMessage, minRxTxTimes3 += MBusTxTimings.calculateTxRxTime(commandMessage, (BBaudRate)device.getBaudRate()));
                    if (rsp != null && rsp.getSuccessfulResponse()) {
                        byte[] byteHold = rsp.getBytes();
                        if (byteHold.length > 8) {
                            MbusReceivedLongFrame longFrameMessage = null;
                            longFrameMessage = new MbusReceivedLongFrame(rsp, network, device, device.getAllowMultipleRecords(), device.getMaxSpecialFunctionReads());
                            device.setMbusMeterStatusDescription(longFrameMessage.getStatus());
                            device.setManufacturerStatusBit5(longFrameMessage.getStatusBit5());
                            device.setManufacturerStatusBit6(longFrameMessage.getStatusBit6());
                            device.setManufacturerStatusBit7(longFrameMessage.getStatusBit7());
                            boolean addressErrorDetected = false;
                            if (device.getAddressMode().equals((Object)BMbusAddressing.primary)) {
                                if (device.getPrimaryAddress() != longFrameMessage.getPrimaryAddress()) {
                                    addressErrorDetected = true;
                                }
                            } else if (device.getAddressMode().equals((Object)BMbusAddressing.secondary)) {
                                if (!device.getSecondaryAddress().equals(longFrameMessage.getSecondaryAddress())) {
                                    addressErrorDetected = true;
                                }
                            } else if (device.getAddressMode().equals((Object)BMbusAddressing.secondaryExtended) && !device.getSecondaryAddress().equals(longFrameMessage.getSecondaryAddress())) {
                                addressErrorDetected = true;
                            }
                            if (addressErrorDetected) {
                                this.executeFail(lex.getText("BMbusHistoryImport.incorrectAddress"));
                                return;
                            }
                            if (!longFrameMessage.getFabricationNumber().equals("")) {
                                device.setFabricationNumber(longFrameMessage.getFabricationNumber());
                            }
                            if (longFrameMessage.getManufacturerIndex() != -1) {
                                int startOfManufacturersData = longFrameMessage.getManufacturerIndex();
                                int lengthOfManufSpecData = byteHold.length - startOfManufacturersData - 2;
                                manufacturersData = new int[lengthOfManufSpecData];
                                for (int i = 0; i < lengthOfManufSpecData; ++i) {
                                    BMbusHistoryImport.manufacturersData[i] = byteHold[startOfManufacturersData + i];
                                }
                            }
                            MbusSortedDataInformation[] sortedData = MbusDataSort.sort(longFrameMessage, this.getMbusUnit(), this.getDescription(), this.getOrthogonalDescription(), this.getMessageSlotNumber(), this.getRecordNumber(), this.getStorageNumber(), this.getFunction(), this.getExponent(), false);
                            BHistoryConfig config = null;
                            BHistoryConfig outputConfig = null;
                            BBooleanTrendRecord rec = null;
                            if (sortedData != null && sortedData.length != 0) {
                                for (int i = 0; i < sortedData.length; ++i) {
                                    if (sortedData[i].value instanceof BStatusNumeric) {
                                        double value = ((BStatusNumeric)sortedData[i].value).getValue() * this.getConversion().getScale() + this.getConversion().getOffset();
                                        config = new BHistoryConfig(this.getHistoryId(), BTypeSpec.make((Type)BNumericTrendRecord.TYPE));
                                        rec = new BNumericTrendRecord();
                                        ((BNumericTrendRecord)rec).set(sortedData[i].date, value, BStatus.ok);
                                    } else if (sortedData[i].value instanceof BStatusBoolean) {
                                        boolean value = ((BStatusBoolean)sortedData[i].value).getValue();
                                        config = new BHistoryConfig(this.getHistoryId(), BTypeSpec.make((Type)BBooleanTrendRecord.TYPE));
                                        rec = new BBooleanTrendRecord();
                                        rec.set(sortedData[i].date, value, BStatus.ok);
                                    }
                                    outputConfig = this.makeLocalConfig(config);
                                    outputConfig.setTimeZone(BTimeZone.getLocal());
                                    BFacets f = (BFacets)config.get(VALUE_FACETS);
                                    if (f != null) {
                                        outputConfig.set(VALUE_FACETS, (BValue)this.getFacets());
                                    } else {
                                        outputConfig.add(VALUE_FACETS, (BValue)this.getFacets());
                                    }
                                    if (!conn.exists(this.getHistoryId())) {
                                        conn.createHistory(outputConfig);
                                    } else {
                                        conn.reconfigureHistory(outputConfig);
                                    }
                                    BIHistory history = conn.getHistory(this.getHistoryId());
                                    BAbsTime lastTimestamp = conn.getLastTimestamp(history);
                                    if (sortedData[i].date.getMillis() <= lastTimestamp.getMillis()) continue;
                                    conn.append(history, (BIHistoryRecordSet)rec);
                                }
                                this.executeOk();
                                return;
                            }
                            if (this.getManuSpecDefElementOrd().isNull()) continue;
                            BStatusValue inputValue = ((BManuSpecDefElement)this.getManuSpecDefElementOrd().get((BObject)network)).getValue(manufacturersData);
                            if (inputValue instanceof BStatusNumeric) {
                                double value = ((BStatusNumeric)inputValue).getValue() * this.getConversion().getScale() + this.getConversion().getOffset();
                                config = new BHistoryConfig(this.getHistoryId(), BTypeSpec.make((Type)BNumericTrendRecord.TYPE));
                                rec = new BNumericTrendRecord();
                                ((BNumericTrendRecord)rec).set(BAbsTime.now(), value, BStatus.ok);
                            } else if (inputValue instanceof BStatusBoolean) {
                                boolean value = ((BStatusBoolean)inputValue).getValue();
                                config = new BHistoryConfig(this.getHistoryId(), BTypeSpec.make((Type)BBooleanTrendRecord.TYPE));
                                rec = new BBooleanTrendRecord();
                                rec.set(BAbsTime.now(), value, BStatus.ok);
                            }
                            outputConfig = this.makeLocalConfig(config);
                            outputConfig.setTimeZone(BTimeZone.getLocal());
                            BFacets f = (BFacets)config.get(VALUE_FACETS);
                            if (f != null) {
                                outputConfig.set(VALUE_FACETS, (BValue)this.getFacets());
                            } else {
                                outputConfig.add(VALUE_FACETS, (BValue)this.getFacets());
                            }
                            if (!conn.exists(this.getHistoryId())) {
                                conn.createHistory(outputConfig);
                            } else {
                                conn.reconfigureHistory(outputConfig);
                            }
                            BIHistory history = conn.getHistory(this.getHistoryId());
                            BAbsTime lastTimestamp = conn.getLastTimestamp(history);
                            if (BAbsTime.now().getMillis() > lastTimestamp.getMillis()) {
                                conn.append(history, (BIHistoryRecordSet)rec);
                            }
                            this.executeOk();
                            return;
                        }
                        this.executeFail(lex.getText("BMbusHistoryImport.shortMessage"));
                        continue;
                    }
                    this.executeFail(lex.getText("BMbusHistoryImport.responseFail"));
                }
                this.executeOk();
            }
        }
        catch (Exception e) {
            this.executeFail(e);
            MbusToolkit.error("Could not amend history", e);
        }
    }

    protected IFuture postExecute(Action archiveAction, BValue arg, Context cx) {
        if (this.isRunning()) {
            BAbstractMbusNetwork network = (BAbstractMbusNetwork)((BDevice)this.getParent().getParent()).getNetwork();
            return network.postAsync((Runnable)new Invocation((BComponent)this, archiveAction, arg, cx));
        }
        return null;
    }
}

