/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.mbus.comm;

import com.tridium.basicdriver.comm.CommTransmitter;
import com.tridium.basicdriver.message.Message;
import com.tridium.basicdriver.message.ReceivedMessage;
import com.tridium.mbus.BAbstractMbusNetwork;
import com.tridium.mbus.comm.IMbusComm;
import com.tridium.mbus.comm.MbusCommReceiver;
import com.tridium.mbus.enums.BMbusTestControl;
import com.tridium.mbus.messages.MbusMessage;
import com.tridium.mbus.messages.MbusReceivedMessage;
import com.tridium.mbus.utils.MbusStringConvertor;

public class MbusCommTransmitter
extends CommTransmitter {
    private BAbstractMbusNetwork networkCached = null;

    public void writeMessage(Message message) {
        if (this.getNetwork().getTestMode() != BMbusTestControl.inactive) {
            byte[] messageInput = MbusStringConvertor.calc(((BAbstractMbusNetwork)this.getComm().getNetwork()).getTestString());
            if (((BAbstractMbusNetwork)this.getComm().getNetwork()).getTestMode() == BMbusTestControl.oneShot) {
                ((BAbstractMbusNetwork)this.getComm().getNetwork()).setTestMode(BMbusTestControl.inactive);
            }
            final MbusReceivedMessage msg = new MbusReceivedMessage(messageInput);
            msg.setSuccessfulResponse(true);
            Thread simWriteThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    MbusCommTransmitter.this.getComm().receive((ReceivedMessage)msg);
                }
            });
            simWriteThread.start();
            return;
        }
        boolean mbusMessage = message instanceof MbusMessage;
        if (mbusMessage && ((MbusMessage)message).getHandleCorruptBuffers()) {
            ((MbusCommReceiver)this.getComm().getCommReceiver()).messagePendingTx();
        }
        super.writeMessage(message);
        if (mbusMessage) {
            ((MbusCommReceiver)this.getComm().getCommReceiver()).messageSent((MbusMessage)message);
            if (this.getComm().getNetwork() != null && this.getComm().getNetwork().getLog().isTraceOn()) {
                this.getComm().getNetwork().getLog().trace("Transmit request sent at baud speed where relevant " + (Object)((Object)((MbusMessage)message).getMessageBaudRate()));
            }
            ((IMbusComm)this.getComm()).messageSent();
        }
    }

    protected BAbstractMbusNetwork getNetwork() {
        if (this.networkCached == null) {
            this.networkCached = (BAbstractMbusNetwork)this.getComm().getNetwork();
        }
        return this.networkCached;
    }
}

