/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.mbus;

import com.tridium.mbus.BMbusDevice;
import com.tridium.mbus.comm.MBusTxTimings;
import javax.baja.data.BIDataValue;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BMbusConfig
extends BComponent {
    public static final Property overrideNetwork = BMbusConfig.newProperty((int)264, (boolean)false, null);
    public static final Property retryCount = BMbusConfig.newProperty((int)264, (int)0, null);
    public static final Property responseTimeout = BMbusConfig.newProperty((int)264, (BValue)BRelTime.make((long)(BRelTime.SECOND.getMillis() * 12L)), (BFacets)BFacets.make((String)"showMilliseconds", (BIDataValue)BBoolean.TRUE));
    public static final Property interMessageDelay = BMbusConfig.newProperty((int)264, (BValue)BRelTime.makeSeconds((int)2), (BFacets)BFacets.make((String)"showMilliseconds", (BIDataValue)BBoolean.TRUE, (String)"min", (BIDataValue)BRelTime.make((long)0L), (String)"max", (BIDataValue)BRelTime.makeSeconds((int)10)));
    public static final Property initialisationDelay = BMbusConfig.newProperty((int)264, (BValue)BRelTime.makeSeconds((int)5), (BFacets)BFacets.make((String)"showMilliseconds", (BIDataValue)BBoolean.TRUE, (String)"min", (BIDataValue)BRelTime.make((long)0L), (String)"max", (BIDataValue)BRelTime.make((long)100000L)));
    public static final Type TYPE = Sys.loadType(BMbusConfig.class);

    public boolean getOverrideNetwork() {
        return this.getBoolean(overrideNetwork);
    }

    public void setOverrideNetwork(boolean v) {
        this.setBoolean(overrideNetwork, v, null);
    }

    public int getRetryCount() {
        return this.getInt(retryCount);
    }

    public void setRetryCount(int v) {
        this.setInt(retryCount, v, null);
    }

    public BRelTime getResponseTimeout() {
        return (BRelTime)this.get(responseTimeout);
    }

    public void setResponseTimeout(BRelTime v) {
        this.set(responseTimeout, (BValue)v, null);
    }

    public BRelTime getInterMessageDelay() {
        return (BRelTime)this.get(interMessageDelay);
    }

    public void setInterMessageDelay(BRelTime v) {
        this.set(interMessageDelay, (BValue)v, null);
    }

    public BRelTime getInitialisationDelay() {
        return (BRelTime)this.get(initialisationDelay);
    }

    public void setInitialisationDelay(BRelTime v) {
        this.set(initialisationDelay, (BValue)v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void started() throws Exception {
        if (this.getOverrideNetwork()) {
            this.changed(overrideNetwork, null);
        }
    }

    public void changed(Property property, Context context) {
        if (!this.isRunning()) {
            return;
        }
        if (property.equals(overrideNetwork) || this.getOverrideNetwork() && property.isFrozen()) {
            if (!(this.getParent() instanceof BMbusDevice)) {
                return;
            }
            BMbusDevice device = (BMbusDevice)this.getParent();
            if (this.getOverrideNetwork()) {
                MBusTxTimings newTxTimings = new MBusTxTimings();
                newTxTimings.initalisationDelay = (BRelTime)this.getInitialisationDelay().newCopy();
                newTxTimings.retryTransmission = this.getRetryCount();
                newTxTimings.responseTimeout = (BRelTime)this.getResponseTimeout().newCopy();
                newTxTimings.intermessageDelay = this.getInterMessageDelay().getMillis();
                device.networkTxTimings = newTxTimings;
            } else {
                device.networkTxTimings = null;
            }
        }
    }

    public String toString(Context context) {
        return this.getOverrideNetwork() ? BBoolean.TRUE.toString(context) : BBoolean.FALSE.toString(context);
    }
}

