/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.mbus;

import com.tridium.basicdriver.comm.Comm;
import com.tridium.basicdriver.comm.CommReceiver;
import com.tridium.basicdriver.message.Message;
import com.tridium.basicdriver.serial.BSerialNetwork;
import com.tridium.basicdriver.util.BBasicPollScheduler;
import com.tridium.mbus.BMbusDevice;
import com.tridium.mbus.BMbusDeviceFolder;
import com.tridium.mbus.actionArgSets.BPrimaryDiscoverOptions;
import com.tridium.mbus.actionArgSets.BSecondaryDiscoverOptions;
import com.tridium.mbus.comm.MBusTxTimings;
import com.tridium.mbus.comm.MbusCommReceiver;
import com.tridium.mbus.comm.MbusCommTransmitter;
import com.tridium.mbus.comm.MbusSerialComm;
import com.tridium.mbus.db.BMbusNetworkDatabase;
import com.tridium.mbus.enums.BMbusBaudRate;
import com.tridium.mbus.enums.BMbusTestControl;
import com.tridium.mbus.jobs.BMbusAssignAddressJob;
import com.tridium.mbus.jobs.BMbusAssignBaudRateData;
import com.tridium.mbus.jobs.BMbusAssignBaudRateJob;
import com.tridium.mbus.jobs.BMbusPrimaryDeviceSearchJob;
import com.tridium.mbus.jobs.BMbusSecondaryAddressScanJob;
import com.tridium.mbus.jobs.BMbusSecondaryDeviceSearchJob;
import com.tridium.mbus.jobs.BMbusUpdateDevicesJob;
import com.tridium.mbus.learn.BMbusDeviceDiscoveryJob;
import com.tridium.mbus.learn.BMbusHistoryImportDiscoveryJob;
import com.tridium.mbus.learn.BMbusPointDiscoveryJob;
import com.tridium.mbus.types.BEncodableList;
import com.tridium.mbus.utils.MbusToolkit;
import com.tridium.sys.station.BStationSaveJob;
import java.util.logging.Logger;
import javax.baja.data.BIDataValue;
import javax.baja.driver.ping.BPingMonitor;
import javax.baja.driver.util.BPollScheduler;
import javax.baja.job.BJobService;
import javax.baja.job.BJobState;
import javax.baja.license.Feature;
import javax.baja.license.FeatureNotLicensedException;
import javax.baja.log.Log;
import javax.baja.naming.BOrd;
import javax.baja.naming.BOrdList;
import javax.baja.serial.BBaudRate;
import javax.baja.serial.BSerialHelper;
import javax.baja.serial.BSerialParity;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Subscriber;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public abstract class BAbstractMbusNetwork
extends BSerialNetwork {
    public static final Property initialisationDelay = BAbstractMbusNetwork.newProperty((int)0, (BValue)BRelTime.makeSeconds((int)3), (BFacets)BFacets.make((String)"showMilliseconds", (BIDataValue)BBoolean.TRUE, (String)"min", (BIDataValue)BRelTime.make((long)0L), (String)"max", (BIDataValue)BRelTime.make((long)100000L)));
    public static final Property networkDatabase = BAbstractMbusNetwork.newProperty((int)0, (BValue)new BMbusNetworkDatabase(), null);
    public static final Property searchBaudRate = BAbstractMbusNetwork.newProperty((int)261, (BValue)BMbusBaudRate.baud300, null);
    public static final Property searchFcBitState = BAbstractMbusNetwork.newProperty((int)0, (boolean)false, null);
    public static final Property searchFcBitInUse = BAbstractMbusNetwork.newProperty((int)0, (boolean)true, null);
    public static final Property primarySearchAddress = BAbstractMbusNetwork.newProperty((int)4, (int)0, (BFacets)BFacets.make((String)"min", (BIDataValue)BInteger.make((int)0), (String)"max", (BIDataValue)BInteger.make((int)250)));
    public static final Property testMode = BAbstractMbusNetwork.newProperty((int)4, (BValue)BMbusTestControl.inactive, null);
    public static final Property testString = BAbstractMbusNetwork.newProperty((int)4, (String)"", null);
    public static final Property inhibitDatabaseUpdate = BAbstractMbusNetwork.newProperty((int)8, (boolean)true, null);
    public static final Property retryCount = BAbstractMbusNetwork.newProperty((int)0, (int)2, null);
    public static final Property responseTimeout = BAbstractMbusNetwork.newProperty((int)0, (BValue)BRelTime.make((long)(BRelTime.SECOND.getMillis() * 3L)), (BFacets)BFacets.make((String)"showMilliseconds", (BIDataValue)BBoolean.TRUE));
    public static final Property interMessageDelay = BAbstractMbusNetwork.newProperty((int)0, (BValue)BRelTime.make((long)300L), (BFacets)BFacets.make((String)"showMilliseconds", (BIDataValue)BBoolean.TRUE, (String)"min", (BIDataValue)BRelTime.make((long)0L), (String)"max", (BIDataValue)BRelTime.SECOND));
    public static final Property pollScheduler = BAbstractMbusNetwork.newProperty((int)0, (BValue)BAbstractMbusNetwork.makeDefaultPollScheduler(), null);
    public static final Property serialPortConfig = BAbstractMbusNetwork.newProperty((int)0, (BValue)BAbstractMbusNetwork.makeDefaultSerialHelper(), null);
    public static final Property monitor = BAbstractMbusNetwork.newProperty((int)0, (BValue)BAbstractMbusNetwork.makeDefaultPingMonitor(), null);
    public static final Property collisionCsvBytes = BAbstractMbusNetwork.newProperty((int)260, (String)"A2", null);
    public static final Property receiverBufferResetTimeout = BAbstractMbusNetwork.newProperty((int)260, (BValue)BRelTime.SECOND, (BFacets)BFacets.make((String)"showMilliseconds", (BIDataValue)BBoolean.FALSE, (String)"min", (BIDataValue)BRelTime.make((long)0L), (String)"max", (BIDataValue)BRelTime.makeSeconds((int)10)));
    public static final Action submitDeviceDiscoveryJob = BAbstractMbusNetwork.newAction((int)4, (BValue)BOrd.NULL, null);
    public static final Action submitHistoryImportDiscoveryJob = BAbstractMbusNetwork.newAction((int)4, (BValue)BOrd.NULL, null);
    public static final Action submitPointDiscoveryJob = BAbstractMbusNetwork.newAction((int)4, (BValue)BOrdList.make((BOrd[])new BOrd[]{BOrd.NULL, BOrd.NULL}), null);
    public static final Action submitSingleDeviceDiscoveryJob = BAbstractMbusNetwork.newAction((int)4, (BValue)new BPrimaryDiscoverOptions(), null);
    public static final Action submitPrimaryDiscoverJob = BAbstractMbusNetwork.newAction((int)4, (BValue)BEncodableList.DEFAULT, null);
    public static final Action submitPrimaryDiscoverRangeJob = BAbstractMbusNetwork.newAction((int)4, (BValue)new BPrimaryDiscoverOptions(), null);
    public static final Action submitAssignBaudRateJob = BAbstractMbusNetwork.newAction((int)4, (BValue)new BMbusAssignBaudRateData(), null);
    public static final Action submitFullSecondaryDiscoverJob = BAbstractMbusNetwork.newAction((int)4, (BValue)new BSecondaryDiscoverOptions(), null);
    public static final Action submitSecondaryAddressScanJob = BAbstractMbusNetwork.newAction((int)4, (BValue)new BSecondaryDiscoverOptions(), null);
    public static final Action assignAddress = BAbstractMbusNetwork.newAction((int)128, (BValue)BInteger.DEFAULT, (BFacets)BFacets.make((String)"min", (BIDataValue)BInteger.make((int)0), (String)"max", (BIDataValue)BInteger.make((int)250)));
    public static final Action clearNetworkDatabase = BAbstractMbusNetwork.newAction((int)0, null);
    public static final Action updateReceiverResetTimeout = BAbstractMbusNetwork.newAction((int)276, null);
    public static final Type TYPE = Sys.loadType(BAbstractMbusNetwork.class);
    private volatile boolean savesActive = false;
    private Object savesActiveLock = new Object();
    protected final StationSaveSubscriber jobServiceMonitor = new StationSaveSubscriber();
    private volatile Object sendLock = new Object();
    private volatile Object sendActiveLock = null;
    private MBusTxTimings activeTxTimings = this.getTxTimingsReference();
    protected MBusTxTimings networkTxTimings = new MBusTxTimings();
    static int currentTestMeterNumber = 0;

    public BRelTime getInitialisationDelay() {
        return (BRelTime)this.get(initialisationDelay);
    }

    public void setInitialisationDelay(BRelTime v) {
        this.set(initialisationDelay, (BValue)v, null);
    }

    public BMbusNetworkDatabase getNetworkDatabase() {
        return (BMbusNetworkDatabase)this.get(networkDatabase);
    }

    public void setNetworkDatabase(BMbusNetworkDatabase v) {
        this.set(networkDatabase, (BValue)v, null);
    }

    public BMbusBaudRate getSearchBaudRate() {
        return (BMbusBaudRate)this.get(searchBaudRate);
    }

    public void setSearchBaudRate(BMbusBaudRate v) {
        this.set(searchBaudRate, (BValue)v, null);
    }

    public boolean getSearchFcBitState() {
        return this.getBoolean(searchFcBitState);
    }

    public void setSearchFcBitState(boolean v) {
        this.setBoolean(searchFcBitState, v, null);
    }

    public boolean getSearchFcBitInUse() {
        return this.getBoolean(searchFcBitInUse);
    }

    public void setSearchFcBitInUse(boolean v) {
        this.setBoolean(searchFcBitInUse, v, null);
    }

    public int getPrimarySearchAddress() {
        return this.getInt(primarySearchAddress);
    }

    public void setPrimarySearchAddress(int v) {
        this.setInt(primarySearchAddress, v, null);
    }

    public BMbusTestControl getTestMode() {
        return (BMbusTestControl)this.get(testMode);
    }

    public void setTestMode(BMbusTestControl v) {
        this.set(testMode, (BValue)v, null);
    }

    public String getTestString() {
        return this.getString(testString);
    }

    public void setTestString(String v) {
        this.setString(testString, v, null);
    }

    public boolean getInhibitDatabaseUpdate() {
        return this.getBoolean(inhibitDatabaseUpdate);
    }

    public void setInhibitDatabaseUpdate(boolean v) {
        this.setBoolean(inhibitDatabaseUpdate, v, null);
    }

    public int getRetryCount() {
        return this.getInt(retryCount);
    }

    public void setRetryCount(int v) {
        this.setInt(retryCount, v, null);
    }

    public BRelTime getResponseTimeout() {
        return (BRelTime)this.get(responseTimeout);
    }

    public void setResponseTimeout(BRelTime v) {
        this.set(responseTimeout, (BValue)v, null);
    }

    public BRelTime getInterMessageDelay() {
        return (BRelTime)this.get(interMessageDelay);
    }

    public void setInterMessageDelay(BRelTime v) {
        this.set(interMessageDelay, (BValue)v, null);
    }

    public BPollScheduler getPollScheduler() {
        return (BPollScheduler)this.get(pollScheduler);
    }

    public void setPollScheduler(BPollScheduler v) {
        this.set(pollScheduler, (BValue)v, null);
    }

    public BSerialHelper getSerialPortConfig() {
        return (BSerialHelper)this.get(serialPortConfig);
    }

    public void setSerialPortConfig(BSerialHelper v) {
        this.set(serialPortConfig, (BValue)v, null);
    }

    public BPingMonitor getMonitor() {
        return (BPingMonitor)this.get(monitor);
    }

    public void setMonitor(BPingMonitor v) {
        this.set(monitor, (BValue)v, null);
    }

    public String getCollisionCsvBytes() {
        return this.getString(collisionCsvBytes);
    }

    public void setCollisionCsvBytes(String v) {
        this.setString(collisionCsvBytes, v, null);
    }

    public BRelTime getReceiverBufferResetTimeout() {
        return (BRelTime)this.get(receiverBufferResetTimeout);
    }

    public void setReceiverBufferResetTimeout(BRelTime v) {
        this.set(receiverBufferResetTimeout, (BValue)v, null);
    }

    public BOrd submitDeviceDiscoveryJob(BOrd prevJob) {
        return (BOrd)this.invoke(submitDeviceDiscoveryJob, (BValue)prevJob, null);
    }

    public BOrd submitHistoryImportDiscoveryJob(BOrd deviceOrd) {
        return (BOrd)this.invoke(submitHistoryImportDiscoveryJob, (BValue)deviceOrd, null);
    }

    public BOrd submitPointDiscoveryJob(BOrdList deviceAndPrevJobOrds) {
        return (BOrd)this.invoke(submitPointDiscoveryJob, (BValue)deviceAndPrevJobOrds, null);
    }

    public BOrd submitSingleDeviceDiscoveryJob(BPrimaryDiscoverOptions discoveryOpts) {
        return (BOrd)this.invoke(submitSingleDeviceDiscoveryJob, (BValue)discoveryOpts, null);
    }

    public BOrd submitPrimaryDiscoverJob(BEncodableList inputAddresses) {
        return (BOrd)this.invoke(submitPrimaryDiscoverJob, (BValue)inputAddresses, null);
    }

    public BOrd submitPrimaryDiscoverRangeJob(BPrimaryDiscoverOptions primaryRange) {
        return (BOrd)this.invoke(submitPrimaryDiscoverRangeJob, (BValue)primaryRange, null);
    }

    public BOrd submitAssignBaudRateJob(BMbusAssignBaudRateData data) {
        return (BOrd)this.invoke(submitAssignBaudRateJob, (BValue)data, null);
    }

    public BOrd submitFullSecondaryDiscoverJob(BSecondaryDiscoverOptions discoveryOpts) {
        return (BOrd)this.invoke(submitFullSecondaryDiscoverJob, (BValue)discoveryOpts, null);
    }

    public BOrd submitSecondaryAddressScanJob(BSecondaryDiscoverOptions discoveryOpts) {
        return (BOrd)this.invoke(submitSecondaryAddressScanJob, (BValue)discoveryOpts, null);
    }

    public void assignAddress(BInteger address) {
        this.invoke(assignAddress, (BValue)address, null);
    }

    public void clearNetworkDatabase() {
        this.invoke(clearNetworkDatabase, null, null);
    }

    public void updateReceiverResetTimeout() {
        this.invoke(updateReceiverResetTimeout, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void doUpdateReceiverResetTimeout() {
        BAbstractMbusNetwork srcComp = this;
        this.getWriteWorker().post(new Runnable((BComponent)srcComp){
            final /* synthetic */ BComponent val$srcComp;
            {
                this.val$srcComp = bComponent;
            }

            @Override
            public void run() {
                try {
                    BRelTime timeout = BAbstractMbusNetwork.this.getReceiverBufferResetTimeout();
                    CommReceiver commReceiver = BAbstractMbusNetwork.this.getComm().getCommReceiver();
                    if (commReceiver instanceof MbusCommReceiver) {
                        ((MbusCommReceiver)commReceiver).setReceiveBufferTimeout(timeout);
                    }
                }
                catch (Throwable t) {
                    if (MbusToolkit.isTraceOn()) {
                        MbusToolkit.trace("Re-attempting receiver timeout setup in 5 seconds due to " + t.getMessage());
                    }
                    Clock.schedule((BComponent)this.val$srcComp, (BRelTime)BRelTime.makeSeconds((int)5), (Action)updateReceiverResetTimeout, null);
                }
            }
        });
    }

    public void descendantsStarted() throws Exception {
        super.descendantsStarted();
        this.doUpdateReceiverResetTimeout();
    }

    public static BBasicPollScheduler makeDefaultPollScheduler() {
        BBasicPollScheduler ps = new BBasicPollScheduler();
        ps.setFastRate(BRelTime.make((long)30000L));
        ps.setNormalRate(BRelTime.make((long)45000L));
        ps.setSlowRate(BRelTime.make((long)90000L));
        return ps;
    }

    public static BSerialHelper makeDefaultSerialHelper() {
        BSerialHelper sh = new BSerialHelper();
        sh.setParity(BSerialParity.even);
        sh.setBaudRate((BBaudRate)BMbusBaudRate.baud300);
        return sh;
    }

    public static BPingMonitor makeDefaultPingMonitor() {
        BPingMonitor pm = new BPingMonitor();
        pm.setPingFrequency(BRelTime.makeMinutes((int)30));
        return pm;
    }

    public BAbstractMbusNetwork() {
        MbusToolkit.setLogger(Logger.getLogger(this.getLog().getLogName()));
    }

    public BFacets getSlotFacets(Slot slot) {
        if (slot == interMessageDelay) {
            String[] keys = new String[]{"showSeconds", "showMilliseconds", "min", "max"};
            BIDataValue[] values = new BIDataValue[]{BBoolean.TRUE, BBoolean.TRUE, BRelTime.make((long)0L), BRelTime.MINUTE};
            return BFacets.make((String[])keys, (BIDataValue[])values);
        }
        return super.getSlotFacets(slot);
    }

    public Type getDeviceType() {
        return BMbusDevice.TYPE;
    }

    public Type getDeviceFolderType() {
        return BMbusDeviceFolder.TYPE;
    }

    public void started() throws Exception {
        super.started();
        MbusToolkit.setLogger(Logger.getLogger(this.getLog().getLogName()));
        this.startStationMonitorSaving();
        this.setFlags((Slot)ping, 4);
        this.setFlags((Slot)upload, 4);
        this.setFlags((Slot)download, 4);
        this.setSearchFcBitInUse(true);
        this.setSearchFcBitState(false);
        this.setTestMode(BMbusTestControl.inactive);
        if (this.getLog().isTraceOn()) {
            this.getLog().trace("*** Mbus Driver Started ***");
        }
    }

    public void stopped() throws Exception {
        super.stopped();
        this.stopStationMonitorSaving();
    }

    protected Comm makeComm() {
        MbusCommReceiver receiver = new MbusCommReceiver();
        receiver.setCollisionHexBytes(this.getCollisionCsvBytes());
        return new MbusSerialComm(this, receiver, new MbusCommTransmitter());
    }

    public BOrd doSubmitDeviceDiscoveryJob(BOrd prevJob) {
        BMbusDeviceDiscoveryJob newJob = new BMbusDeviceDiscoveryJob(this);
        newJob.setPrevJob(prevJob);
        return newJob.submit(null);
    }

    public BOrd doSubmitHistoryImportDiscoveryJob(BOrd deviceOrd) {
        return new BMbusHistoryImportDiscoveryJob(this.getSlotPathOrd(), deviceOrd).submit(null);
    }

    public BOrd doSubmitPointDiscoveryJob(BOrdList relatedOrdRefs) {
        if (relatedOrdRefs.size() == 0) {
            throw new RuntimeException("Expected 1 or 2 ords to submitPointDiscoveryJob - [0] = Device BOrd, [1] = Previous job BOrd");
        }
        BOrd deviceOrd = relatedOrdRefs.get(0);
        BOrd prevJobOrd = relatedOrdRefs.get(1);
        return new BMbusPointDiscoveryJob(this.getSlotPathOrd(), deviceOrd, prevJobOrd).submit(null);
    }

    public final Feature getLicenseFeature() {
        Feature f = Sys.getLicenseManager().checkFeature("tridium", "mbus");
        String[] keys = f.list();
        for (int i = 0; i < keys.length; ++i) {
            if (!keys[i].equals(this.getLicenseConnectTypeName()) || f.getb(keys[i], true)) continue;
            throw new FeatureNotLicensedException("Not licensed for " + this.getLicenseConnectTypeName());
        }
        return f;
    }

    protected abstract String getLicenseConnectTypeName();

    public BOrd doSubmitSingleDeviceDiscoveryJob(BPrimaryDiscoverOptions discoveryOpts) {
        discoveryOpts.getAddrRange().setStart(254);
        discoveryOpts.getAddrRange().setEnd(254);
        BMbusPrimaryDeviceSearchJob job = new BMbusPrimaryDeviceSearchJob(this);
        job.setDiscoveryOptions(discoveryOpts);
        job.setSingleDeviceScan(true);
        return job.submit(null);
    }

    public BOrd doSubmitPrimaryDiscoverRangeJob(BPrimaryDiscoverOptions primaryDiscoveryOpts) {
        BMbusPrimaryDeviceSearchJob job = new BMbusPrimaryDeviceSearchJob(this);
        job.setDiscoveryOptions(primaryDiscoveryOpts);
        return job.submit(null);
    }

    public BOrd doSubmitFullSecondaryDiscoverJob(BSecondaryDiscoverOptions secDiscoveryOpts) {
        BMbusSecondaryDeviceSearchJob secondarySearchJob = new BMbusSecondaryDeviceSearchJob(this);
        secondarySearchJob.setDiscoveryOptions(secDiscoveryOpts);
        return secondarySearchJob.submit(null);
    }

    public BOrd doSubmitSecondaryAddressScanJob(BSecondaryDiscoverOptions secDiscoveryOpts) {
        BMbusSecondaryAddressScanJob secondarySearchJob = new BMbusSecondaryAddressScanJob(this);
        secondarySearchJob.setDiscoveryOptions(secDiscoveryOpts);
        return secondarySearchJob.submit(null);
    }

    public BOrd doSubmitPrimaryDiscoverJob(BEncodableList inputAddresses) {
        BOrd ord = BOrd.NULL;
        try {
            String[] deviceOrds = inputAddresses.toStringArray();
            BMbusDevice[] devices = new BMbusDevice[deviceOrds.length];
            for (int i = 0; i < deviceOrds.length; ++i) {
                devices[i] = (BMbusDevice)BOrd.make((String)deviceOrds[i]).get((BObject)this);
            }
            BMbusUpdateDevicesJob updateJob = new BMbusUpdateDevicesJob(this);
            updateJob.setDevicesToUpdate(devices);
            ord = updateJob.submit(null);
        }
        catch (Exception e) {
            MbusToolkit.error("Error in Device discovery Job, String part ", e);
        }
        return ord;
    }

    public BOrd doSubmitAssignBaudRateJob(BMbusAssignBaudRateData data) {
        return new BMbusAssignBaudRateJob(this, data).submit(null);
    }

    public void doAssignAddress(BInteger address) {
        new BMbusAssignAddressJob(this, address.getInt(), null).submit(null);
    }

    public void doClearNetworkDatabase() {
        this.getNetworkDatabase().clearAllDetectedDevices();
    }

    public void changed(Property prop, Context cx) {
        if (prop.equals(retryCount) || prop.equals(interMessageDelay) || prop.equals(responseTimeout) || prop.equals(initialisationDelay)) {
            MBusTxTimings newTxTimings = new MBusTxTimings();
            newTxTimings.initalisationDelay = (BRelTime)this.getInitialisationDelay().newCopy();
            newTxTimings.retryTransmission = this.getRetryCount();
            newTxTimings.responseTimeout = (BRelTime)this.getResponseTimeout().newCopy();
            newTxTimings.intermessageDelay = this.getInterMessageDelay().getMillis();
            this.networkTxTimings = newTxTimings;
        } else if (prop.equals(receiverBufferResetTimeout) && Sys.isStationStarted()) {
            this.doUpdateReceiverResetTimeout();
        }
    }

    protected void startStationMonitorSaving() {
        BJobService jobService = (BJobService)Sys.getService((Type)BJobService.TYPE);
        if (jobService != null && !this.jobServiceMonitor.isSubscribed((BComponent)jobService)) {
            if (this.getLog().isTraceOn()) {
                this.getLog().trace("*** MBus Driver -> Station Save Monitoring Started against " + jobService.getHandleOrd() + " ***");
            }
            this.jobServiceMonitor.setLog(this.getLog());
            this.jobServiceMonitor.subscribe((BComponent)jobService);
        }
    }

    protected void stopStationMonitorSaving() {
        this.jobServiceMonitor.unsubscribeAll();
        this.noStationSaves();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void stationSavesActive() {
        Object object = this.savesActiveLock;
        synchronized (object) {
            this.savesActive = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void noStationSaves() {
        Object object = this.savesActiveLock;
        synchronized (object) {
            this.savesActive = false;
        }
        this.getNetworkDatabase().startRestoration();
    }

    public final boolean savesActive() {
        return this.savesActive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void lockSends(Object lockObject) {
        Object object = this.sendLock;
        synchronized (object) {
            if (this.sendActiveLock == lockObject) {
                return;
            }
            while (this.sendActiveLock != lockObject) {
                if (this.getLog().isTraceOn()) {
                    this.getLog().trace(BAbsTime.now().encodeToString() + ":Waiting for exclusive comms lock against " + lockObject);
                }
                if (this.sendActiveLock != null) {
                    try {
                        this.sendLock.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                if (this.sendActiveLock != null) continue;
                this.sendActiveLock = lockObject;
                if (this.getLog().isTraceOn()) {
                    this.getLog().trace(BAbsTime.now().encodeToString() + ":Exclusive comms locked against " + lockObject);
                }
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void unlockSends(Object lockObject) {
        Object object = this.sendLock;
        synchronized (object) {
            if (this.sendActiveLock == lockObject) {
                if (this.getLog().isTraceOn()) {
                    this.getLog().trace(BAbsTime.now().encodeToString() + ":Exclusive comms released against " + lockObject);
                }
                this.sendActiveLock = null;
                this.sendLock.notifyAll();
            }
        }
    }

    public final Message sendMBusSyncActiveParams(Message msg, long minTxRxTime) {
        return this.sendMBusSync(this.activeTxTimings, this.sendActiveLock, msg, minTxRxTime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Message sendMBusSync(MBusTxTimings txTimings, Object lockObject, Message msg, long minTxRxTime) {
        Message result;
        this.lockSends(lockObject);
        long responseTimeout = minTxRxTime;
        responseTimeout += txTimings.responseTimeout.getMillis();
        if (this.getLog().isTraceOn()) {
            this.getLog().trace(BAbsTime.now().encodeToString() + ":DynamicResponseTimeout " + responseTimeout + "ms");
        }
        Object object = this.sendLock;
        synchronized (object) {
            if (this.sendActiveLock == lockObject) {
                if (this.getLog().isTraceOn()) {
                    this.getLog().trace(BAbsTime.now().encodeToString() + ":Exclusive comms sending against " + lockObject);
                }
                this.activeTxTimings = txTimings;
                result = this.sendSync(msg, BRelTime.make((long)responseTimeout), this.activeTxTimings.retryTransmission);
            } else {
                if (this.getLog().isLoggable(2)) {
                    this.getLog().warning(BAbsTime.now().encodeToString() + ":Exclusive comms sending (locking failed against " + lockObject + ")");
                }
                this.activeTxTimings = txTimings;
                result = this.sendSync(msg, BRelTime.make((long)responseTimeout), this.activeTxTimings.retryTransmission);
            }
        }
        return result;
    }

    public MBusTxTimings getActiveTxTimings() {
        return this.activeTxTimings;
    }

    public Object getSendLockActive() {
        return this.sendActiveLock;
    }

    public MBusTxTimings getTxTimingsReference() {
        return this.networkTxTimings;
    }

    public static int getCurrentTestMeterNumber() {
        return currentTestMeterNumber;
    }

    public static void setCurrentTestMeterNumber(int input) {
        currentTestMeterNumber = input;
    }

    protected final class StationSaveSubscriber
    extends Subscriber {
        protected Log log = Log.getLog((String)"MBusStationSaveMonitor");

        protected StationSaveSubscriber() {
        }

        public void setLog(Log log) {
            this.log = log;
        }

        public void event(BComponentEvent compEvt) {
            if (compEvt.getValue().getType().is(BJobState.TYPE)) {
                switch (((BJobState)compEvt.getValue()).getOrdinal()) {
                    case 1: {
                        break;
                    }
                    case 3: 
                    case 4: 
                    case 5: {
                        this.checkOutstandingSaveJobs(compEvt.getSourceComponent());
                        break;
                    }
                    case 2: {
                        break;
                    }
                    default: {
                        if (!this.log.isLoggable(3)) break;
                        this.log.error("StationSaveSubscriber - unknown event id state : " + ((BJobState)compEvt.getValue()).getOrdinal());
                    }
                }
                return;
            }
            if (compEvt.getValue().getType().is(BStationSaveJob.TYPE)) {
                switch (compEvt.getId()) {
                    case 1: {
                        BAbstractMbusNetwork.this.jobServiceMonitor.subscribe((BComponent)compEvt.getValue(), 2);
                        BAbstractMbusNetwork.this.stationSavesActive();
                        if (this.log == null || !this.log.isTraceOn()) break;
                        this.log.trace("Awaiting station save state updates");
                        break;
                    }
                    case 0: 
                    case 2: {
                        this.checkOutstandingSaveJobs(compEvt.getSourceComponent());
                    }
                }
            }
        }

        public void checkOutstandingSaveJobs(BComponent jobSrv) {
            if (this.log.isTraceOn()) {
                this.log.trace("Checking for save station job completions");
            }
            int totalExecuting = 0;
            Object[] saveJobs = jobSrv.getChildren(BStationSaveJob.class);
            for (int i = 0; i < saveJobs.length; ++i) {
                BStationSaveJob saveJob = (BStationSaveJob)saveJobs[i];
                switch (saveJob.getJobState().getOrdinal()) {
                    case 1: 
                    case 2: {
                        ++totalExecuting;
                    }
                }
            }
            if (totalExecuting == 0) {
                if (this.log.isTraceOn()) {
                    this.log.trace("No station saves are active");
                }
                BAbstractMbusNetwork.this.noStationSaves();
            } else {
                if (this.log.isTraceOn()) {
                    this.log.trace(totalExecuting + " station saves are active");
                }
                BAbstractMbusNetwork.this.stationSavesActive();
            }
        }
    }
}

