/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.seriestransform.terminal;

import com.tridium.seriestransform.terminal.BTerminalMap;
import com.tridium.seriestransform.terminal.BTerminalMapping;
import com.tridium.seriestransform.terminal.BTerminalTable;
import java.util.LinkedList;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.seriestransform.BSeriesTransformTable;
import javax.baja.seriestransform.exceptions.ConfigException;
import javax.baja.seriestransform.exceptions.TransformException;
import javax.baja.seriestransform.graph.BGraphNode;
import javax.baja.seriestransform.graph.BSeriesSchema;
import javax.baja.seriestransform.graph.BStatusSchema;
import javax.baja.seriestransform.graph.GraphNodeParams;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperty(name="transformOutput", type="BStatusSchema", flags=14, defaultValue="new BStatusSchema()", override=true)
public class BTerminalNode
extends BGraphNode {
    public static final Property transformOutput = BTerminalNode.newProperty((int)14, (BValue)new BStatusSchema(), null);
    public static final Type TYPE = Sys.loadType(BTerminalNode.class);
    private BTerminalMap map = new BTerminalMap();

    @Override
    public Type getType() {
        return TYPE;
    }

    @Override
    protected BSeriesTransformTable[] doResolve(BSeriesTransformTable[] inputs, GraphNodeParams params, BOrd base) throws TransformException {
        LinkedList<BTerminalTable> tables = new LinkedList<BTerminalTable>();
        for (BSeriesTransformTable table : inputs) {
            tables.add(new BTerminalTable(this.getName(), this.getSchema(), this, table));
        }
        return tables.toArray(new BSeriesTransformTable[tables.size()]);
    }

    @Override
    public void doCheckSchema() throws ConfigException {
        BGraphNode[] inputSources = this.getSources();
        if (inputSources.length == 0) {
            String msg = lex.getText("fault.msg.schema.nosources");
            throw new ConfigException(msg);
        }
    }

    @Override
    public BSeriesSchema doGetSchema() {
        BSeriesSchema schema;
        BGraphNode[] inputSources = this.getSources();
        if (inputSources.length > 0) {
            BTerminalMapping[] mappings;
            BGraphNode src = inputSources[0];
            BSeriesSchema srcSchema = src.getSchema();
            BSeriesSchema copy = (BSeriesSchema)srcSchema.newCopy(true);
            if (!this.map.correspondsTo(srcSchema)) {
                this.map = new BTerminalMap(srcSchema);
            }
            if ((mappings = (BTerminalMapping[])this.map.getChildren(BTerminalMapping.class)).length > 0) {
                Property[] reorder = new Property[mappings.length];
                for (int i = 0; i < mappings.length; ++i) {
                    String name = mappings[i].getElementName();
                    reorder[i] = copy.getProperty(name);
                }
                copy.reorder(reorder);
            }
            schema = copy;
        } else {
            schema = new BSeriesSchema();
        }
        return schema;
    }

    public BIcon getIcon() {
        String iconsrc = lex.getText("terminal.icon");
        return BIcon.make((BOrd)BOrd.make((String)iconsrc));
    }

    public BTerminalMap getMap() {
        BSeriesSchema schema = this.getSchema();
        if (!this.map.correspondsTo(schema)) {
            this.map = new BTerminalMap(schema);
        }
        return this.map;
    }

    public void setMap(BTerminalMap map) {
        this.map = map;
    }
}

