/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.seriestransform.servlets;

import com.tridium.bql.util.BDynamicTimeRange;
import com.tridium.json.JSONWriter;
import com.tridium.json.quick.QuickJSONWriter;
import com.tridium.nre.util.Version;
import com.tridium.seriestransform.graph.BTransformGraph;
import com.tridium.seriestransform.source.BHistorySourceNode;
import com.tridium.seriestransform.timeshift.BTimeShiftNode;
import com.tridium.web.RestUtil;
import com.tridium.web.WebUtil;
import com.tridium.webChart.WebChartUtil;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.baja.collection.BITable;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdTarget;
import javax.baja.naming.SlotPath;
import javax.baja.naming.ViewQuery;
import javax.baja.security.PermissionException;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComplex;
import javax.baja.sys.Context;
import javax.baja.sys.Cursor;
import javax.baja.util.BAbsTimeRange;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public final class SeriesTransformWebChartQueryServlet
extends HttpServlet {
    private static final int MAX_INDENT = 8;
    private static final Pattern dataPattern = Pattern.compile("/data/.+");
    private static final Version version = new Version("1");
    private static final Logger log = Logger.getLogger("webChart");

    private static Writer getWriter(HttpServletResponse resp, int indent) throws IOException {
        return indent > 0 ? new StringWriter() : resp.getWriter();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        block15: {
            resp.setHeader("transfer-encoding", "chunked");
            try {
                Context cx = (Context)req.getAttribute("niagara.context");
                RestUtil util = new RestUtil(req, resp);
                if (!util.acceptJson()) {
                    resp.sendError(406);
                    return;
                }
                RestUtil.Accept accept = util.getJsonAccept();
                if (!(!accept.isCustomMediaType() || "webChart".equals(accept.getCustomProtocol()) && accept.getCustomVersion().equals((Object)version))) {
                    resp.sendError(406);
                    return;
                }
                if (util.matches(dataPattern)) {
                    util.respond(accept, "text/plain").respondNoCache();
                } else {
                    util.respond(accept, "application/json").respondNoCache();
                }
                try (Writer writer = null;){
                    if (util.matches(dataPattern)) {
                        String escapedOrd = util.get(1);
                        BOrd ord = BOrd.make((String)SlotPath.unescape((String)escapedOrd)).relativizeToSession().normalize();
                        if (ord == null) {
                            resp.sendError(404);
                        } else {
                            writer = SeriesTransformWebChartQueryServlet.getWriter(resp);
                            this.encodeSeriesTransformData(writer, ord, cx);
                        }
                    } else {
                        resp.sendError(404);
                    }
                }
            }
            catch (Exception e) {
                if (WebUtil.isAbortException((Throwable)e)) {
                    log.log(Level.FINE, "Connection Aborted", e);
                    return;
                }
                log.log(Level.SEVERE, "ServletException", e);
                if (e instanceof ServletException || e instanceof IOException) break block15;
                throw new ServletException(e.getMessage(), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void encodeSeriesTransformData(Writer out, BOrd ord, Context cx) throws Exception {
        ViewQuery viewQuery = ord.resolve().getViewQuery();
        BAbsTimeRange range = WebChartUtil.getAbsTimeRangeFromViewOrd((ViewQuery)viewQuery, (BAbsTime)BAbsTime.DEFAULT, (BAbsTime)BAbsTime.DEFAULT);
        BAbsTime start = range.getStartTime();
        BAbsTime end = range.getEndTime();
        OrdTarget target = ord.resolve(null, cx);
        if (!target.canRead()) {
            throw new PermissionException();
        }
        BTransformGraph transformGraph = (BTransformGraph)target.get();
        boolean hasTimeShift = this.hasTimeShift(transformGraph);
        try (Cursor<BComplex> cursor = SeriesTransformWebChartQueryServlet.retrieveCursor(transformGraph, hasTimeShift, start, end, cx);){
            boolean first = false;
            boolean skip = false;
            while (cursor.next()) {
                if (!skip) {
                    if (!first) {
                        first = true;
                    } else {
                        out.append('\n');
                    }
                }
                JSONWriter json = QuickJSONWriter.make((Appendable)out);
                BComplex entry = (BComplex)cursor.get();
                if (hasTimeShift) {
                    skip = !WebChartUtil.encodeMinifiedGenericRecord((JSONWriter)json, (BComplex)entry, (BAbsTime)start, (BAbsTime)end, (Context)cx);
                    continue;
                }
                skip = !WebChartUtil.encodeMinifiedGenericRecord((JSONWriter)json, (BComplex)entry, (Context)cx);
            }
        }
    }

    private static Cursor<BComplex> retrieveCursor(BTransformGraph graph, boolean hasTimeShift, BAbsTime start, BAbsTime end, Context cx) throws Exception {
        BOrd ord = BOrd.make((String)(graph.getAbsoluteOrd() + "|transform:"));
        if (!(hasTimeShift || start == BAbsTime.DEFAULT && end == BAbsTime.DEFAULT)) {
            String timeEncoding = BDynamicTimeRange.make((BAbsTime)start, (BAbsTime)end).encodeToString();
            ord = BOrd.make((String)("" + ord + graph.getSlotPathOrd()));
            for (BHistorySourceNode node : (BHistorySourceNode[])graph.getChildren(BHistorySourceNode.class)) {
                ord = BOrd.make((String)(ord + "?" + node.getSlotPath().toString().substring(5) + "/dateRange=" + timeEncoding));
            }
        }
        BITable table = (BITable)ord.resolve(null, cx).get();
        return table.cursor();
    }

    public boolean hasTimeShift(BTransformGraph graph) {
        return ((BTimeShiftNode[])graph.getChildren(BTimeShiftNode.class)).length > 0;
    }

    private static Writer getWriter(HttpServletResponse resp) throws IOException {
        return resp.getWriter();
    }
}

