/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.forge.msg;

import com.tridium.cloudLink.channel.BAbstractClientChannel;
import com.tridium.cloudLink.channel.BChannelConfig;
import com.tridium.cloudLink.file.FileUploadRequest;
import com.tridium.cloudLink.file.FileUploader;
import com.tridium.cloudLink.forge.channel.BForgeModelChannelConfig;
import com.tridium.cloudLink.forge.model.ModelEncoderPlugin;
import com.tridium.cloudLink.forge.msg.ForgeAmqpSendModelResult;
import com.tridium.cloudLink.forge.msg.ForgeFileComponentSerializer;
import com.tridium.cloudLink.forge.msg.ForgeFileHistoryConfigSerializer;
import com.tridium.cloudLink.forge.msg.ForgeFileJsonObjectSerializer;
import com.tridium.cloudLink.msg.ISendModelEntitiesHandler;
import com.tridium.cloudLink.msg.ISendModelResult;
import com.tridium.cloudLink.transport.IMessage;
import com.tridium.cloudLink.transport.IMessageResponse;
import com.tridium.cloudLink.util.ProtectedFileUtil;
import com.tridium.cloudLink.util.TeeOutputStream;
import com.tridium.json.JSONObject;
import com.tridium.json.JSONWriter;
import com.tridium.json.quick.QuickJSONWriter;
import com.tridium.sys.tag.ComponentRelations;
import com.tridium.sys.tag.ComponentTags;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.zip.GZIPOutputStream;
import javax.baja.collection.BITable;
import javax.baja.collection.TableCursor;
import javax.baja.data.DataTypes;
import javax.baja.history.BHistoryConfig;
import javax.baja.naming.BOrd;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIObject;
import javax.baja.sys.BObject;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.tag.Id;
import javax.baja.tag.Relation;
import javax.baja.tag.RelationInfo;
import javax.baja.tag.Tag;
import javax.baja.tag.TagDictionary;
import javax.baja.tag.TagInfo;
import javax.baja.tagdictionary.BTagDictionaryService;

public class ForgeFileSendModelEntitiesHandler
implements ISendModelEntitiesHandler {
    public static final String FILE_NAME_TEMPLATE = "%s_%s_%s.json.gz";
    public static final String ENDING_FILE_NAME_TEMPLATE = "%s_%s_%s_end.json.gz";
    public static final String FILE_TYPE = "filetype";
    public static final String N4_COMPS = "n4comps";
    public static final String MIME_TYPE = "mimetype";
    public static final String VERSION = "version";
    public static final String VERSION_VALUE = "1";
    public static final String CUSTOMER_ID = "customerId";
    public static final String FORMAT_TXT = "format";
    protected static final Logger log = Logger.getLogger("cloudLink.channel.model");
    protected final BForgeModelChannelConfig config;
    protected Map<String, Object> properties = new HashMap<String, Object>();
    protected Map<String, Set<String>> tagDictionaryNameSpaces;
    protected Map<String, Map<String, String>> adHocTagInfo;
    protected Predicate<Tag> isAdHocTag = tag -> {
        Id tagId = tag.getId();
        String dictionary = tagId.getDictionary();
        return !this.tagDictionaryNameSpaces.containsKey(dictionary) || !this.tagDictionaryNameSpaces.get(dictionary).contains(tagId.getName());
    };
    protected Map<String, Set<String>> relationDictionaryInfo;
    protected Map<String, Set<String>> adHocRelInfo;
    protected Predicate<Id> isAdHocRelation = tagId -> {
        String dictionary = tagId.getDictionary();
        return !this.relationDictionaryInfo.containsKey(dictionary) || !this.relationDictionaryInfo.get(dictionary).contains(tagId.getName());
    };
    private CompletableFuture<OutputStream> uploadStreamInitialized;
    private CompletableFuture<Void> dataUploaded;
    private CompletableFuture<Void> uploadCompleted;
    private CompletableFuture<IMessageResponse> internalFileUploadCompleted;
    private final boolean uploadModelFiles;
    private final boolean writeModelFilesToDisk;
    private ForgeFileComponentSerializer componentSerializer;
    private ForgeFileHistoryConfigSerializer historyConfigSerializer;
    private ForgeFileJsonObjectSerializer jsonObjectSerializer;
    private boolean _hasData;
    private File currentFile;
    private int fileCounter = -1;
    private OutputStream uploadStream;
    private OutputStream fileStream;
    private DataOutputStream countingStream;
    private GZIPOutputStream compressedStream;
    private OutputStreamWriter writer;
    private JSONWriter jsonSerializer;
    protected final Map<String, String> metadata;
    private final long defaultMessageTimeoutMillis;
    private int historyConfigsSerialized;
    private final int historyConfigsToSerializeBeforeEndFile;
    private static final double HEURISTIC_COMPRESSED_BYTES_PER_HISTORY_CONFIG = 60.0;

    public ForgeFileSendModelEntitiesHandler(BChannelConfig channelConfig) {
        int numHistoryConfigs;
        this.config = (BForgeModelChannelConfig)channelConfig;
        this.uploadModelFiles = this.config.getUploadModelFiles();
        this.writeModelFilesToDisk = !this.config.getDeleteModelFiles();
        this.initializeDictionaryNameSpaces();
        this.defaultMessageTimeoutMillis = this.config.getTransport(ISendModelEntitiesHandler.getOperationId()).getDefaultMessageTimeout().getMillis();
        this.metadata = new HashMap<String, String>();
        this.metadata.put(FILE_TYPE, N4_COMPS);
        this.metadata.put(MIME_TYPE, "application/json+gzip");
        this.metadata.put(VERSION, VERSION_VALUE);
        this.metadata.put(CUSTOMER_ID, this.config.getCustomerId());
        BITable countTable = (BITable)BOrd.make((String)"history:|bql:select count(*)").get((BObject)Sys.getStation());
        try (TableCursor cursor = countTable.cursor();){
            if (!cursor.next()) {
                throw new RuntimeException("Unable to get number of historyConfigs for model file upload");
            }
            numHistoryConfigs = DataTypes.otoi((BIObject)cursor.cell(countTable.getColumns().get(0)));
        }
        double maxFileSize = this.config.getMaxMessageSize(ISendModelEntitiesHandler.getOperationId());
        int historyConfigsToSerializeInEndFile = (int)Math.floor(maxFileSize / 60.0);
        this.historyConfigsToSerializeBeforeEndFile = Math.max(numHistoryConfigs - historyConfigsToSerializeInEndFile, 0);
    }

    public void setProperties(Map<String, Object> properties) {
        this.properties.putAll(properties);
        this.adHocRelInfo = (Map)properties.get("adHocRelation");
        if (this.adHocRelInfo == null) {
            log.warning("The ad hoc relation map is not available in the properties");
        }
        this.adHocTagInfo = (Map)properties.get("adHocTag");
        if (this.adHocTagInfo == null) {
            log.warning("The ad hoc tag map is not available in the properties");
        }
    }

    public int add(Object entity) {
        if (this.countingStream == null) {
            this.initialize(false);
        }
        if (this.uploadModelFiles) {
            if (this.uploadCompleted.isCompletedExceptionally()) {
                this.uploadCompleted.join();
            }
            if (this.dataUploaded.isCompletedExceptionally()) {
                this.dataUploaded.join();
            }
        }
        try {
            if (entity instanceof JSONObject) {
                this.jsonObjectSerializer.serialize((JSONObject)entity);
            } else if (entity instanceof BHistoryConfig) {
                if (this.historyConfigsSerialized >= this.historyConfigsToSerializeBeforeEndFile && this.internalFileUploadCompleted == null) {
                    this.toMessage(false);
                    this.internalFileUploadCompleted = this.getFuture(new CompletableFuture<ISendModelResult>(), null);
                    this.initialize(true);
                    if (this.uploadModelFiles) {
                        if (this.uploadCompleted.isCompletedExceptionally()) {
                            this.uploadCompleted.join();
                        }
                        if (this.dataUploaded.isCompletedExceptionally()) {
                            this.dataUploaded.join();
                        }
                    }
                }
                this.historyConfigSerializer.serialize((BHistoryConfig)entity);
                ++this.historyConfigsSerialized;
            } else if (entity instanceof BComponent) {
                BComponent component = ((BObject)entity).asComponent();
                this.updateAdHocTags(component);
                this.updateAdHocRelations(component);
                this.componentSerializer.serialize(component);
            } else {
                log.fine(() -> "The entity is not a supported type for model encoding: " + entity.getClass());
            }
        }
        catch (Exception ex) {
            log.log(Level.FINE, "The entity was not added to the model encoding ", ex);
        }
        return this.countingStream != null ? this.countingStream.size() : 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IMessage toMessage(boolean isFinal) {
        if (this.countingStream == null) {
            String msg = "Error uploading model file: upload stream close requested before stream was initialized";
            log.warning(msg);
            throw new RuntimeException(msg);
        }
        if (this.uploadModelFiles) {
            if (this.uploadCompleted.isCompletedExceptionally()) {
                this.uploadStreamInitialized = null;
                this._hasData = false;
                this.uploadCompleted.join();
            }
            if (this.dataUploaded.isCompletedExceptionally()) {
                this.uploadStreamInitialized = null;
                this._hasData = false;
                this.dataUploaded.join();
            }
        }
        this.jsonSerializer.endObject().endObject();
        try {
            this.close();
            if (this.uploadModelFiles) {
                this.dataUploaded.complete(null);
            }
        }
        catch (Exception ex) {
            String msg = "Unable to complete the model entities file processing.";
            log.log(Level.WARNING, msg, log.isLoggable(Level.FINE) ? ex : null);
            if (this.uploadModelFiles) {
                this.dataUploaded.completeExceptionally(ex);
            }
        }
        finally {
            this.uploadStreamInitialized = null;
            this.countingStream = null;
            this._hasData = false;
        }
        return null;
    }

    public CompletableFuture<IMessageResponse> getFuture(CompletableFuture<ISendModelResult> channelFuture, IMessage message) {
        CompletableFuture<IMessageResponse> future = new CompletableFuture<IMessageResponse>();
        if (this.uploadModelFiles) {
            if (this.uploadCompleted == null) {
                String msg = "Cannot get future for model file";
                log.warning(msg);
                future.completeExceptionally(new RuntimeException(msg));
                channelFuture.completeExceptionally(new RuntimeException(msg));
                return future;
            }
            if (this.internalFileUploadCompleted != null) {
                this.internalFileUploadCompleted.whenComplete((resp, err) -> {
                    if (err != null) {
                        future.completeExceptionally((Throwable)err);
                    } else {
                        this.uploadCompleted.whenComplete((uploadCompletedResp, uploadCompletedErr) -> {
                            if (uploadCompletedErr != null) {
                                future.completeExceptionally((Throwable)uploadCompletedErr);
                            } else {
                                future.complete(null);
                            }
                        });
                    }
                });
            } else {
                this.uploadCompleted.whenComplete((resp, err) -> {
                    if (err != null) {
                        future.completeExceptionally((Throwable)err);
                    } else {
                        future.complete(null);
                    }
                });
            }
            String filename = this.currentFile != null ? this.currentFile.getAbsoluteFile().toString() : "";
            future.whenComplete((resp, err) -> {
                if (err != null) {
                    log.log(Level.WARNING, String.format("Model file upload failed %s", filename), log.isLoggable(Level.FINE) ? err : null);
                    channelFuture.completeExceptionally((Throwable)err);
                    return;
                }
                log.finer(String.format("Model file uploaded successfully %s", filename));
                channelFuture.complete(new ForgeAmqpSendModelResult());
            });
        } else {
            future.complete(null);
            channelFuture.complete(new ForgeAmqpSendModelResult());
        }
        return future;
    }

    public boolean hasData() {
        return this._hasData;
    }

    public void close() throws IOException {
        try (ForgeFileJsonObjectSerializer closingJsonObjectSerializer = this.jsonObjectSerializer;
             ForgeFileHistoryConfigSerializer closingHistoryConfigSerializer = this.historyConfigSerializer;
             ForgeFileComponentSerializer closingComponentSerializer = this.componentSerializer;
             OutputStreamWriter closingWriter = this.writer;){
            this.writer = null;
            this.componentSerializer = null;
            this.historyConfigSerializer = null;
            this.jsonSerializer = null;
            if (closingWriter != null) {
                closingWriter.flush();
            }
        }
        ForgeFileSendModelEntitiesHandler.closeStream(this.fileStream);
        this.fileStream = null;
        ForgeFileSendModelEntitiesHandler.closeStream(this.uploadStream);
        this.uploadStream = null;
        ForgeFileSendModelEntitiesHandler.closeStream(this.compressedStream);
        this.compressedStream = null;
        ForgeFileSendModelEntitiesHandler.closeStream(this.countingStream);
        this.countingStream = null;
    }

    protected void initialize(boolean isFinal) {
        String filename = String.format(isFinal ? ENDING_FILE_NAME_TEMPLATE : FILE_NAME_TEMPLATE, this.config.getSystemGuid(), this.config.getExportId(), ++this.fileCounter);
        this.metadata.put(FORMAT_TXT, filename);
        if (!this.uploadModelFiles && !this.writeModelFilesToDisk) {
            String msg = "Model channel is configured to not upload model files and to not keep them on disk, so model upload will have no effect";
            log.warning(msg);
            throw new RuntimeException(msg);
        }
        try {
            if (this.writeModelFilesToDisk) {
                log.info(String.format("Temporary model file %s will not be deleted due to channel configuration settings, manual deletion is recommended", filename));
                this.fileStream = this.initializeFileStream(filename);
            }
            if (this.uploadModelFiles) {
                this.uploadStream = this.initializeUploadStream(filename);
                if (this.uploadCompleted.isCompletedExceptionally()) {
                    this.uploadCompleted.join();
                }
                if (this.dataUploaded.isCompletedExceptionally()) {
                    this.dataUploaded.join();
                }
            }
            if (this.uploadStream != null && this.fileStream != null) {
                this.countingStream = new DataOutputStream((OutputStream)new TeeOutputStream(this.uploadStream, this.fileStream));
            } else if (this.uploadStream != null) {
                this.countingStream = new DataOutputStream(this.uploadStream);
            } else if (this.fileStream != null) {
                this.countingStream = new DataOutputStream(this.fileStream);
            }
            try {
                this.compressedStream = new GZIPOutputStream(this.countingStream);
            }
            catch (IOException ex) {
                log.log(Level.WARNING, "Unable to create compressed upload stream for model file " + filename, log.isLoggable(Level.FINE) ? ex : null);
                if (this.uploadModelFiles) {
                    this.uploadStreamInitialized = null;
                    this.dataUploaded.completeExceptionally(ex);
                    return;
                }
                throw new RuntimeException(ex);
            }
            this.writer = new OutputStreamWriter((OutputStream)this.compressedStream, StandardCharsets.UTF_8);
            this.jsonSerializer = QuickJSONWriter.make((Appendable)this.writer);
            try {
                ModelEncoderPlugin plugin = new ModelEncoderPlugin(this.jsonSerializer);
                this.componentSerializer = new ForgeFileComponentSerializer(this.config, this.properties, plugin);
                this.historyConfigSerializer = new ForgeFileHistoryConfigSerializer(this.config, this.properties, plugin);
                this.jsonObjectSerializer = new ForgeFileJsonObjectSerializer(this.config, this.properties, plugin);
                this.jsonSerializer.object();
                this.jsonSerializer.key("metadata").value((Object)this.config.makeModelMetadata());
                this.jsonSerializer.key("components").object();
                this._hasData = true;
            }
            catch (IOException ex) {
                if (this.uploadModelFiles) {
                    this.uploadStreamInitialized = null;
                    this.dataUploaded.completeExceptionally(ex);
                    return;
                }
                throw new RuntimeException("Unable to create model upload file", ex);
            }
        }
        catch (Exception ex) {
            try {
                this.close();
            }
            catch (IOException ioex) {
                log.log(Level.WARNING, "Error while closing model upload file handler " + ioex, log.isLoggable(Level.FINE) ? ex : null);
            }
            throw ex;
        }
    }

    protected OutputStream initializeUploadStream(String filename) {
        BAbstractClientChannel channel = (BAbstractClientChannel)this.config.getParent();
        Optional optUploader = channel.getConnectionService().flatMap(ccs -> ccs.getFileUploader(channel));
        if (!optUploader.isPresent()) {
            String msg = "Cannot upload model file as no file uploader is registered for the Model Channel";
            log.warning(msg);
            throw new RuntimeException(msg);
        }
        long dataUploadTimeoutMillis = this.config.getModelFileUploadTimeout().getMillis();
        this.uploadStreamInitialized = new CompletableFuture();
        CompletableFuture localDataUploaded = new CompletableFuture();
        this.dataUploaded = localDataUploaded;
        Consumer<OutputStream> fileData = out -> {
            this.uploadStreamInitialized.complete((OutputStream)out);
            try {
                localDataUploaded.get(dataUploadTimeoutMillis, TimeUnit.MILLISECONDS);
            }
            catch (TimeoutException ex) {
                String msg = String.format("Upload for model file timed out after %d ms", dataUploadTimeoutMillis);
                log.log(Level.WARNING, msg, log.isLoggable(Level.FINE) ? ex : null);
                throw new RuntimeException(msg, new IOException(ex));
            }
            catch (InterruptedException | ExecutionException ex) {
                String msg = "Error while waiting on model file to upload";
                log.log(Level.WARNING, msg, log.isLoggable(Level.FINE) ? ex : null);
                throw new RuntimeException(msg, new IOException(ex));
            }
        };
        FileUploader uploader = (FileUploader)optUploader.get();
        FileUploadRequest request = new FileUploadRequest(filename, fileData, this.metadata);
        this.uploadCompleted = uploader.upload(request);
        try {
            return this.uploadStreamInitialized.get(this.defaultMessageTimeoutMillis, TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException ex) {
            log.log(Level.WARNING, String.format("Attempt to initialize upload for model file %s timed out after %d ms", filename, this.defaultMessageTimeoutMillis), log.isLoggable(Level.FINE) ? ex : null);
            this.uploadStreamInitialized = null;
            this.dataUploaded.completeExceptionally(ex);
            return null;
        }
        catch (InterruptedException | ExecutionException ex) {
            log.log(Level.WARNING, "There was an error while initializing the upload for model file " + filename, log.isLoggable(Level.FINE) ? ex : null);
            this.uploadStreamInitialized = null;
            this.dataUploaded.completeExceptionally(ex);
            return null;
        }
    }

    private OutputStream initializeFileStream(String filename) {
        FileOutputStream fileStream;
        try {
            AccessController.doPrivileged(() -> {
                ProtectedFileUtil.getOrCreateProtectedFolder((String)"cloudLinkModel");
                this.currentFile = ProtectedFileUtil.makeProtectedFile((String)("cloudLinkModel" + File.separator + filename));
                return null;
            });
        }
        catch (PrivilegedActionException ex) {
            throw new RuntimeException("Unable to create model upload file", ex.getCause());
        }
        try {
            fileStream = new FileOutputStream(this.currentFile);
        }
        catch (FileNotFoundException ex) {
            throw new RuntimeException("Unable to create model upload file", ex.getCause());
        }
        return fileStream;
    }

    private void initializeDictionaryNameSpaces() {
        BTagDictionaryService tagDictionaryService = (BTagDictionaryService)Sys.getService((Type)BTagDictionaryService.TYPE);
        this.tagDictionaryNameSpaces = tagDictionaryService.getTagDictionaries().stream().collect(Collectors.toMap(TagDictionary::getNamespace, tagDictionary -> {
            HashSet<String> tagNames = new HashSet<String>();
            Iterator i = tagDictionary.getTags();
            while (i.hasNext()) {
                tagNames.add(((TagInfo)i.next()).getName());
            }
            return tagNames;
        }));
        this.relationDictionaryInfo = tagDictionaryService.getTagDictionaries().stream().collect(Collectors.toMap(TagDictionary::getNamespace, tagDictionary -> {
            HashSet<String> relationNames = new HashSet<String>();
            Iterator i = tagDictionary.getRelations();
            while (i.hasNext()) {
                relationNames.add(((RelationInfo)i.next()).getName());
            }
            return relationNames;
        }));
    }

    private void updateAdHocRelations(BComponent component) {
        if (this.adHocRelInfo != null) {
            new ComponentRelations(component).getAll().stream().map(Relation::getId).filter(this.isAdHocRelation).forEach(tagId -> ForgeFileSendModelEntitiesHandler.updateAdHocRelationProp(tagId, this.adHocRelInfo));
        }
    }

    private void updateAdHocTags(BComponent component) {
        if (this.adHocTagInfo != null) {
            new ComponentTags(component).getAll().stream().filter(this.isAdHocTag).forEach(tag -> ForgeFileSendModelEntitiesHandler.updateAdHocTagProp(tag, this.adHocTagInfo));
        }
    }

    private static void updateAdHocTagProp(Tag tag, Map<String, Map<String, String>> adHocProp) {
        Id id = tag.getId();
        String dictionary = id.getDictionary();
        String qName = id.getQName();
        String type = tag.getValue().getType().toString();
        if (adHocProp.containsKey(dictionary)) {
            Map<String, String> tagInfo = adHocProp.get(dictionary);
            if (tagInfo.containsKey(qName)) {
                if (!tagInfo.get(qName).equals(type)) {
                    log.info(String.format("Skipping the encoding for ad hoc tag: '%s', type '%s'. A tag with the same name is already encoded with type '%s'.", qName, type, tagInfo.get(qName)));
                }
            } else {
                tagInfo.put(qName, type);
            }
        } else {
            HashMap<String, String> tagInfo = new HashMap<String, String>();
            tagInfo.put(qName, type);
            adHocProp.put(dictionary, tagInfo);
        }
    }

    private static void updateAdHocRelationProp(Id id, Map<String, Set<String>> adHocProp) {
        String dictionary = id.getDictionary();
        Set qNames = adHocProp.getOrDefault(dictionary, new HashSet());
        qNames.add(id.getQName());
        adHocProp.put(dictionary, qNames);
    }

    private static void closeStream(OutputStream stream) {
        if (stream != null) {
            try {
                stream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

