/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.forge.msg;

import com.tridium.clUtils.util.TagUtil;
import com.tridium.cloudLink.forge.channel.BForgeModelChannelConfig;
import com.tridium.cloudLink.forge.model.ComponentEncoder;
import com.tridium.cloudLink.forge.model.ModelEncoderPlugin;
import com.tridium.cloudLink.forge.msg.IForgeModelEntitySerializer;
import com.tridium.cloudLink.model.BModelExportPolicy;
import java.io.IOException;
import java.util.Map;
import java.util.Optional;
import javax.baja.data.BIDataValue;
import javax.baja.sys.BComponent;
import javax.baja.sys.BValue;

public final class ForgeFileComponentSerializer
implements IForgeModelEntitySerializer<BComponent>,
AutoCloseable {
    private final ModelEncoderPlugin plugin;
    private ComponentEncoder encoder;

    public ForgeFileComponentSerializer(BForgeModelChannelConfig config, Map<String, Object> properties, ModelEncoderPlugin plugin) throws IOException {
        this.plugin = plugin;
        this.encoder = new ComponentEncoder(plugin);
        this.encoder.setEncodeTransients(false);
        this.encoder.setConfig(config);
        BModelExportPolicy policy = (BModelExportPolicy)properties.get("policy");
        this.encoder.setComponentTypePredicate(policy.getComponentTypeIncludedInModel());
        this.encoder.setRelationTypePredicate(policy.getRelationTypeIncludeInModel());
    }

    @Override
    public void serialize(BComponent component) throws IOException {
        Optional optCloudId = TagUtil.getCloudId((BComponent)component);
        if (optCloudId.isPresent()) {
            String cloudId = ((BIDataValue)optCloudId.get()).toString();
            this.plugin.key(cloudId);
            this.encoder.encode(component.getName(), (BValue)component, 0);
        }
    }

    @Override
    public void close() throws IOException {
        if (this.encoder != null) {
            this.encoder.close();
            this.encoder = null;
        }
    }
}

