/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.forge.msg;

import com.tridium.clUtils.util.TagUtil;
import com.tridium.cloudLink.channel.BChannelConfig;
import com.tridium.cloudLink.forge.channel.BForgeAmqpPointChannelConfig;
import com.tridium.cloudLink.forge.msg.ForgeAmqpHandler;
import com.tridium.cloudLink.forge.util.ForgeUtils;
import com.tridium.cloudLink.msg.ISendPointValuesHandler;
import com.tridium.cloudLink.points.CovRecord;
import com.tridium.cloudLink.transport.BAbstractTransport;
import com.tridium.cloudLink.transport.IMessage;
import com.tridium.cloudLink.transport.IMessageResponse;
import java.time.OffsetDateTime;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.control.BControlPoint;
import javax.baja.naming.OrdQuery;
import javax.baja.nav.BINavNode;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BIObject;

public class ForgeAmqpSendPointValuesHandler
extends ForgeAmqpHandler
implements ISendPointValuesHandler {
    private boolean _hasData;
    private final BForgeAmqpPointChannelConfig config;
    public static final String ITEM_NAME = "ItemName";
    public static final String QUALITY = "Quality";
    public static final String TIME = "Time";
    public static final String VALUE = "Value";
    public static final String COMMAND = "HistoryUpdateMessage";
    public static final String VERSION = "1";
    private static final int MSG_END_SIZE = 2;
    private static final Logger log = Logger.getLogger("cloudLink.channel.point");

    public ForgeAmqpSendPointValuesHandler(BChannelConfig channelConfig) {
        this.config = (BForgeAmqpPointChannelConfig)channelConfig;
        this.makeMessageHeaders(COMMAND, VERSION, this.config);
        this.initializeMessage();
    }

    public int add(BIObject value) {
        if (value == null) {
            log.info("Unable to add item to snapshot point update; input is null");
            return this.stringWriter.getBuffer().length() + 2;
        }
        String id = TagUtil.getCloudIdString((BIObject)value).orElse(null);
        if (id == null && value instanceof BINavNode) {
            OrdQuery[] ordParts = ((BINavNode)value).getNavOrd().parse();
            id = ordParts[ordParts.length - 1].toString();
        }
        if (id != null) {
            this.jsonSerializer.object();
            this.jsonSerializer.key(ITEM_NAME).value((Object)id);
            if (value instanceof BControlPoint) {
                BStatusValue statusValue = ((BControlPoint)value).getOutStatusValue();
                this.jsonSerializer.key(QUALITY).value((Object)('\"' + statusValue.getStatus().toString() + '\"'));
                this.jsonSerializer.key(TIME).value((Object)OffsetDateTime.now().toString());
                this.jsonSerializer.key(VALUE).value((Object)ForgeUtils.getStringValue(statusValue.getValueValue()));
            } else {
                this.jsonSerializer.key(QUALITY).value((Object)"\"\"");
                this.jsonSerializer.key(TIME).value((Object)OffsetDateTime.now().toString());
                this.jsonSerializer.key(VALUE).value((Object)value);
            }
            this.jsonSerializer.endObject();
            this._hasData = true;
        } else {
            log.info("Unable to add item to snapshot point update; cloud id is null");
        }
        return this.stringWriter.getBuffer().length() + 2;
    }

    public int add(CovRecord value) {
        if (value == null) {
            log.info("Unable to add item to snapshot point update; input is null");
            return this.stringWriter.getBuffer().length() + 2;
        }
        this.jsonSerializer.object();
        this.jsonSerializer.key(ITEM_NAME).value((Object)value.getId());
        BStatusValue statusValue = value.getStatusValue();
        this.jsonSerializer.key(QUALITY).value((Object)('\"' + statusValue.getStatus().toString() + '\"'));
        this.jsonSerializer.key(TIME).value((Object)value.getTimeStamp().encodeToString());
        this.jsonSerializer.key(VALUE).value((Object)ForgeUtils.getStringValue(statusValue.getValueValue()));
        this.jsonSerializer.endObject();
        this._hasData = true;
        return this.stringWriter.getBuffer().length() + 2;
    }

    public boolean hasData() {
        return this._hasData;
    }

    @Override
    public IMessage toMessage(boolean isFinal) {
        this.jsonSerializer.endArray();
        this.jsonSerializer.endObject();
        return super.toMessage(isFinal);
    }

    public CompletableFuture<IMessageResponse> getFuture(CompletableFuture<Boolean> channelFuture, IMessage message) {
        CompletableFuture<IMessageResponse> future = new CompletableFuture<IMessageResponse>();
        future.whenComplete((resp, err) -> {
            if (err != null) {
                log.log(Level.WARNING, "Point Snapshot Update message got error", log.isLoggable(Level.FINE) ? err : null);
                channelFuture.complete(false);
            } else {
                log.finer("Point Snapshot Update message sent successfully");
                channelFuture.complete(true);
            }
        });
        return future;
    }

    @Override
    protected void initializeMessage() {
        super.initializeMessage();
        this.jsonSerializer.object();
        this.jsonSerializer.key("HistorySamples");
        this.jsonSerializer.array();
        this._hasData = false;
    }

    @Override
    protected BAbstractTransport getTransport() {
        return this.config.getTransport(ISendPointValuesHandler.getOperationId());
    }
}

