/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.forge.msg;

import com.tridium.cloudLink.alarm.AlarmCountEvent;
import com.tridium.cloudLink.channel.BChannelConfig;
import com.tridium.cloudLink.command.CommandEvent;
import com.tridium.cloudLink.forge.channel.BForgeMonoTransportChannelConfig;
import com.tridium.cloudLink.forge.msg.ForgeAmqpAlarmCountEventSerializer;
import com.tridium.cloudLink.forge.msg.ForgeAmqpCommandEventSerializer;
import com.tridium.cloudLink.forge.msg.ForgeAmqpComponentEventSerializer;
import com.tridium.cloudLink.forge.msg.ForgeAmqpEventSerializer;
import com.tridium.cloudLink.forge.msg.ForgeAmqpHandler;
import com.tridium.cloudLink.msg.ISendEventHandler;
import com.tridium.cloudLink.transport.BAbstractTransport;
import com.tridium.cloudLink.transport.IMessage;
import com.tridium.cloudLink.transport.IMessageResponse;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.event.BEvent;
import javax.baja.sys.BComponentEvent;

public class ForgeAmqpSendEventHandler
extends ForgeAmqpHandler
implements ISendEventHandler {
    private boolean _hasData;
    protected final BForgeMonoTransportChannelConfig config;
    public static final String NEW_EVENT_MSG = "NewEventMessage";
    public static final String VERSION = "2";
    private static final int MSG_END_SIZE = 2;
    private static final Logger log = Logger.getLogger("cloudLink.channel.event");

    public ForgeAmqpSendEventHandler(BChannelConfig channelConfig) {
        this.config = (BForgeMonoTransportChannelConfig)channelConfig;
        this.makeMessageHeaders(NEW_EVENT_MSG, VERSION, this.config);
        this.initializeMessage();
    }

    public int add(BEvent event) {
        try {
            this.jsonSerializer.object();
            this.addCommonData();
            ForgeAmqpEventSerializer serializer = new ForgeAmqpEventSerializer();
            serializer.serialize(event, (BChannelConfig)this.config, this.jsonSerializer);
            this.jsonSerializer.endObject();
            this._hasData = true;
        }
        catch (Exception ex) {
            log.log(Level.INFO, String.format("Error serializing Niagara BEvent to Forge Event:%s", ex), log.isLoggable(Level.FINE) ? ex : null);
        }
        return this.stringWriter.getBuffer().length() + 2;
    }

    public int add(BComponentEvent componentEvent) {
        try {
            this.jsonSerializer.object();
            this.addCommonData();
            ForgeAmqpComponentEventSerializer serializer = new ForgeAmqpComponentEventSerializer();
            serializer.serialize(componentEvent, (BChannelConfig)this.config, this.jsonSerializer);
            this.jsonSerializer.endObject();
            this._hasData = true;
        }
        catch (Exception ex) {
            log.log(Level.INFO, String.format("Error serializing Niagara BComponentEvent to Forge Event:%s", ex), log.isLoggable(Level.FINE) ? ex : null);
        }
        return this.stringWriter.getBuffer().length() + 2;
    }

    public int add(CommandEvent eventData) {
        try {
            this.jsonSerializer.object();
            this.addCommonData();
            ForgeAmqpCommandEventSerializer serializer = new ForgeAmqpCommandEventSerializer();
            serializer.serialize(eventData, (BChannelConfig)this.config, this.jsonSerializer);
            this.jsonSerializer.endObject();
            this.correlationId = eventData.getCorrelationId();
            this.messageHeaders.put("CorrelationId", this.correlationId);
            this._hasData = true;
        }
        catch (Exception ex) {
            log.log(Level.INFO, String.format("Error serializing CommandEvent to Forge Event:%s", ex), log.isLoggable(Level.FINE) ? ex : null);
        }
        return this.stringWriter.getBuffer().length() + 2;
    }

    public int add(AlarmCountEvent eventData) {
        try {
            this.jsonSerializer.object();
            this.addCommonData();
            ForgeAmqpAlarmCountEventSerializer serializer = new ForgeAmqpAlarmCountEventSerializer();
            serializer.serialize(eventData, (BChannelConfig)this.config, this.jsonSerializer);
            this.jsonSerializer.endObject();
            this._hasData = true;
        }
        catch (Exception ex) {
            log.log(Level.INFO, String.format("Error serializing AlarmCountEvent to Forge Event:%s", ex), log.isLoggable(Level.FINE) ? ex : null);
        }
        return this.stringWriter.getBuffer().length() + 2;
    }

    @Override
    protected void initializeMessage() {
        super.initializeMessage();
        this.jsonSerializer.object();
        this.jsonSerializer.key("SystemGuid").value((Object)this.config.getSystemGuid());
        this.jsonSerializer.key("Events").array();
        this._hasData = false;
    }

    @Override
    protected BAbstractTransport getTransport() {
        return this.config.getTransport(ISendEventHandler.getOperationId());
    }

    protected void addCommonData() {
        this.jsonSerializer.key("GeneratorId").value((Object)this.config.getSystemGuid());
        this.jsonSerializer.key("GeneratorType").value((Object)"CloudLink");
    }

    @Override
    public IMessage toMessage(boolean isFinal) {
        if (!this._hasData) {
            return null;
        }
        this.jsonSerializer.endArray();
        this.jsonSerializer.endObject();
        return super.toMessage(isFinal);
    }

    public CompletableFuture<IMessageResponse> getFuture(CompletableFuture<Boolean> channelFuture, IMessage message) {
        CompletableFuture<IMessageResponse> future = new CompletableFuture<IMessageResponse>();
        future.whenComplete((resp, err) -> {
            if (err != null) {
                log.log(Level.WARNING, "Event message got error", log.isLoggable(Level.FINE) ? err : null);
                channelFuture.complete(false);
            } else {
                log.finer(String.format("Event message sent successfully: correlationId=[%s]", this.correlationId));
                channelFuture.complete(true);
            }
        });
        return future;
    }
}

