/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.forge.command;

import com.tridium.cloudLink.command.CommandRequest;
import com.tridium.cloudLink.forge.command.BIForgeCommand;
import com.tridium.cloudLink.queue.BAbstractCommandQueue;
import com.tridium.cloudLink.transport.AmqpMessage;
import com.tridium.json.JSONObject;
import com.tridium.json.JSONUtil;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;

public class ForgeAmqpCommandRequest
extends CommandRequest {
    private final JSONObject data;
    private JSONObject platformHeaders;
    private String payload;
    private final String messageId;
    private final Map<String, Object> headers;
    private final String commandId;
    private boolean isValid = true;
    private String invalidRequestMessage;
    private static final Logger log = Logger.getLogger("cloudLink.channel.command");

    public ForgeAmqpCommandRequest(AmqpMessage message) {
        this.data = new JSONObject(new String(message.getPayload(), StandardCharsets.UTF_8));
        this.messageId = (String)message.getMessage().getMessageId();
        this.headers = message.getMetadata();
        this.payload = "";
        if ("SystemCommand".equals(this.headers.get("ObjectType"))) {
            if (!this.data.has("CommandId")) {
                log.info("Invalid System Command body. Attribute 'CommandId' not found for message " + this.messageId);
                throw new RuntimeException("Invalid command body. Attribute 'CommandId' not found for message " + this.messageId);
            }
            this.commandId = JSONUtil.getString((JSONObject)this.data, (String)"CommandId");
            log.info(() -> String.format("Command request with message id %s has command id %s", this.messageId, this.commandId));
            if (this.data.has("CommandParameters")) {
                JSONObject parameters = this.data.getJSONObject("CommandParameters");
                if (parameters.has("CloudPlatformHeaders")) {
                    try {
                        this.platformHeaders = new JSONObject(JSONUtil.getString((JSONObject)parameters, (String)"CloudPlatformHeaders"));
                    }
                    catch (Exception ex) {
                        log.log(Level.INFO, String.format("Unable to deserialize cloud platform headers in system command %s", this.messageId), log.isLoggable(Level.FINE) ? ex : null);
                        this.platformHeaders = new JSONObject();
                        this.isValid = false;
                        this.invalidRequestMessage = String.format("Unable to deserialize cloud platform headers in system command %s", this.messageId);
                    }
                } else {
                    this.platformHeaders = new JSONObject();
                }
                if (parameters.has("CommandPayload")) {
                    this.payload = JSONUtil.getString((JSONObject)parameters, (String)"CommandPayload");
                }
            }
        } else {
            this.commandId = this.messageId;
        }
    }

    public String getCaller() {
        if (this.data.has("CallingIdentity")) {
            return JSONUtil.getString((JSONObject)this.data, (String)"CallingIdentity");
        }
        return "";
    }

    public Object getAuth() {
        if (this.headers.containsKey("ForgeCommandToken")) {
            return this.headers.get("ForgeCommandToken");
        }
        if (this.platformHeaders != null) {
            return this.platformHeaders.opt("Auth");
        }
        return null;
    }

    public String getMessageId() {
        return this.messageId;
    }

    public String getCommandId() {
        return this.commandId;
    }

    public String getCommandName() {
        String commandName = null;
        if (this.data.has("Command")) {
            commandName = JSONUtil.getString((JSONObject)this.data, (String)"Command");
        }
        if (commandName == null || commandName.isEmpty()) {
            commandName = this.headers.get("ObjectType").toString();
        }
        return commandName;
    }

    public String getCommandParams() {
        return this.payload;
    }

    public Map<String, Object> getMetadata() {
        return Collections.unmodifiableMap(this.headers);
    }

    public int getPriority() {
        if (this.platformHeaders == null) {
            return BAbstractCommandQueue.getHighestPriority();
        }
        try {
            int rv = this.platformHeaders.optInt("Priority", BAbstractCommandQueue.getLowestPriority());
            if (rv > BAbstractCommandQueue.getLowestPriority()) {
                return BAbstractCommandQueue.getLowestPriority();
            }
            return Math.max(rv, BAbstractCommandQueue.getHighestPriority());
        }
        catch (Exception ignore) {
            return BAbstractCommandQueue.getLowestPriority();
        }
    }

    public boolean getSuppressStatusResponse() {
        return this.platformHeaders == null;
    }

    public boolean isValid() {
        return this.isValid;
    }

    public String getInvalidRequestMessage() {
        return this.invalidRequestMessage;
    }

    public void execute() {
        BIForgeCommand forgeCommand = (BIForgeCommand)this.command.as(BIForgeCommand.class);
        forgeCommand.execute(this.commandId, this.data, (Context)new BasicContext(this.user));
    }

    protected final void finalize() throws Throwable {
    }
}

