/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.forge.command;

import com.tridium.cloudLink.command.BCloudWriteInfo;
import com.tridium.cloudLink.command.BReadPointInputsCommand;
import com.tridium.cloudLink.forge.command.BForgeCommandContainer;
import com.tridium.cloudLink.forge.command.BIForgeCommand;
import com.tridium.cloudLink.forge.command.ForgeCommandDataEvent;
import com.tridium.json.JSONArray;
import com.tridium.json.JSONObject;
import com.tridium.json.JSONUtil;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComponent;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public class BForgeReadPointInputsSystemCommand
extends BReadPointInputsCommand
implements BIForgeCommand {
    public static final Type TYPE = Sys.loadType(BForgeReadPointInputsSystemCommand.class);
    public static final String COMMAND = "SystemCommand";
    public static final String COMMAND_NAME = "CloudPointReadInputsCommand";
    public static final String VERSION = "1";

    public Type getType() {
        return TYPE;
    }

    public void started() throws Exception {
        super.started();
        this.setCommandId(this.getCommandName());
    }

    public final boolean isParentLegal(BComponent parent) {
        return parent instanceof BForgeCommandContainer;
    }

    @Override
    public String getRoute() {
        return "SystemCommand.1";
    }

    @Override
    public String getCommandName() {
        return COMMAND_NAME;
    }

    @Override
    public String getVersion() {
        return VERSION;
    }

    @Override
    public CompletableFuture<Boolean> execute(String messageId, JSONObject data, Context cx) {
        int code;
        JSONObject payload = new JSONObject(JSONUtil.getString((JSONObject)data.getJSONObject("CommandParameters"), (String)"CommandPayload"));
        String pointId = JSONUtil.getString((JSONObject)payload, (String)"PointId");
        BCloudWriteInfo[] inputs = this.getCloudWrites(messageId, pointId, cx);
        JSONObject body = new JSONObject();
        if (inputs != null) {
            JSONArray inputArray = new JSONArray();
            for (BCloudWriteInfo input : inputs) {
                JSONObject obj = new JSONObject();
                obj.put("Source", (Object)input.getSource());
                obj.put("Priority", input.getPriority().getOrdinal());
                obj.put("Value", (Object)Objects.toString(input.getValue()));
                obj.put("Expiration", (Object)input.getExpiration().encodeToString());
                inputArray.put((Object)obj);
            }
            body.put(pointId, (Object)inputArray);
            body.put("ResponseCode", 200);
            body.put("ErrorMessage", (Object)"Status: OK");
            code = 200;
        } else {
            body.put("ResponseCode", 403);
            body.put("ErrorMessage", (Object)"Error: Access Not Allowed");
            code = 403;
        }
        BForgeCommandContainer container = (BForgeCommandContainer)this.getParent().as(BForgeCommandContainer.class);
        return container.sendDataEvent(new ForgeCommandDataEvent(messageId, code, body));
    }
}

