/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.forge.command;

import com.tridium.cloudLink.BAbstractCloudLinkHandlerFactory;
import com.tridium.cloudLink.BCloudConnectionService;
import com.tridium.cloudLink.ICloudLinkMessageHandler;
import com.tridium.cloudLink.channel.BChannelConfig;
import com.tridium.cloudLink.channel.BCommandsChannel;
import com.tridium.cloudLink.command.BReadPointCommand;
import com.tridium.cloudLink.forge.command.BForgeCommandContainer;
import com.tridium.cloudLink.forge.command.BIForgeCommand;
import com.tridium.cloudLink.forge.msg.IForgePointReadCommandHandler;
import com.tridium.cloudLink.msg.IPointReadCommandHandler;
import com.tridium.cloudLink.transport.BAbstractTransport;
import com.tridium.cloudLink.transport.MessageWrapper;
import com.tridium.json.JSONObject;
import com.tridium.json.JSONUtil;
import java.io.IOException;
import java.security.AccessController;
import java.util.concurrent.CompletableFuture;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComponent;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public class BForgeReadPointCommand
extends BReadPointCommand
implements BIForgeCommand {
    public static final Type TYPE = Sys.loadType(BForgeReadPointCommand.class);
    public static final String COMMAND = "PointReadCommand";
    public static final String VERSION = "1";

    public Type getType() {
        return TYPE;
    }

    public void started() throws Exception {
        super.started();
        this.setCommandId(this.getCommandName());
    }

    public final boolean isParentLegal(BComponent parent) {
        return parent instanceof BForgeCommandContainer;
    }

    @Override
    public String getRoute() {
        return "PointReadCommand.1";
    }

    @Override
    public String getCommandName() {
        return COMMAND;
    }

    @Override
    public String getVersion() {
        return VERSION;
    }

    @Override
    public ICloudLinkMessageHandler<Boolean> getErrorResponse(BAbstractCloudLinkHandlerFactory msgFactory, BChannelConfig channelConfig, String correlationId, int code, String message) {
        IForgePointReadCommandHandler handler = (IForgePointReadCommandHandler)msgFactory.getMessageHandler(IForgePointReadCommandHandler.class, channelConfig);
        handler.addError(code, message);
        handler.setCorrelationId(correlationId);
        return handler;
    }

    @Override
    public CompletableFuture<Boolean> execute(String messageId, JSONObject data, Context cx) {
        CompletableFuture<Boolean> future = new CompletableFuture<Boolean>();
        String pointId = JSONUtil.getString((JSONObject)data, (String)"PointId");
        BReadPointCommand.StatusWrapper result = this.readPoint(messageId, pointId, cx);
        BCommandsChannel channel = this.getChannel();
        if (channel == null) {
            future.completeExceptionally(new IOException("no channel"));
            return future;
        }
        BChannelConfig config = channel.getChannelConfig();
        BAbstractTransport transport = config.getTransport(IPointReadCommandHandler.getOperationId());
        if (!transport.canSend()) {
            log.warning("unable to send command response transport down " + messageId);
            future.completeExceptionally(new IOException("transport down"));
            return future;
        }
        BAbstractCloudLinkHandlerFactory msgFactory = (BAbstractCloudLinkHandlerFactory)((BCloudConnectionService)channel.getConnectionService().orElseThrow(() -> new IllegalStateException("Unable to locate Cloud Connection Service."))).getMessageHandlerFactory(channel.getPlatformType(), transport.getTransportType()).orElseThrow(() -> new IllegalStateException("Unable to locate message handler factory."));
        IForgePointReadCommandHandler handler = (IForgePointReadCommandHandler)msgFactory.getMessageHandler(IForgePointReadCommandHandler.class, config);
        if (result == null) {
            handler.addError(403, "Error: Access Not Allowed");
        } else {
            handler.add(result);
        }
        handler.setCorrelationId(messageId);
        MessageWrapper wrapper = new MessageWrapper(handler.toMessage(), handler.getFuture(future), transport.getMessageRetries());
        AccessController.doPrivileged(() -> {
            config.enqueueMessage(IPointReadCommandHandler.getOperationId(), wrapper);
            return null;
        });
        transport.notifyPending();
        return future;
    }
}

