/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.forge.command;

import com.tridium.cloudLink.command.BReadPointCommand;
import com.tridium.cloudLink.forge.command.BForgeCommandContainer;
import com.tridium.cloudLink.forge.command.BIForgeCommand;
import com.tridium.cloudLink.forge.command.ForgeCommandDataEvent;
import com.tridium.json.JSONArray;
import com.tridium.json.JSONObject;
import com.tridium.json.JSONUtil;
import java.util.concurrent.CompletableFuture;
import javax.baja.data.BIDataValue;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public class BForgeReadMultiPointSystemCommand
extends BReadPointCommand
implements BIForgeCommand {
    public static final Type TYPE = Sys.loadType(BForgeReadMultiPointSystemCommand.class);
    public static final String COMMAND = "SystemCommand";
    public static final String COMMAND_NAME = "CloudMultiPointReadCommand";
    public static final String VERSION = "1";

    public Type getType() {
        return TYPE;
    }

    public void started() throws Exception {
        super.started();
        this.setCommandId(this.getCommandName());
    }

    public final boolean isParentLegal(BComponent parent) {
        return parent instanceof BForgeCommandContainer;
    }

    @Override
    public String getRoute() {
        return "SystemCommand.1";
    }

    @Override
    public String getCommandName() {
        return COMMAND_NAME;
    }

    @Override
    public String getVersion() {
        return VERSION;
    }

    @Override
    public CompletableFuture<Boolean> execute(String messageId, JSONObject data, Context cx) {
        int code;
        JSONObject payload = new JSONObject(JSONUtil.getString((JSONObject)data.getJSONObject("CommandParameters"), (String)"CommandPayload"));
        JSONArray pointIds = payload.getJSONArray("PointIds");
        JSONObject values = new JSONObject();
        boolean success = false;
        for (int lcv = 0; lcv < pointIds.length(); ++lcv) {
            String pointId = JSONUtil.getString((JSONArray)pointIds, (int)lcv);
            BReadPointCommand.StatusWrapper result = this.readPoint(messageId, pointId, cx);
            JSONObject pointData = new JSONObject();
            if (result == null) {
                pointData.put("Status", (Object)"Error: Access Not Allowed");
                pointData.put("Value", null);
            } else {
                BasicContext conversionContext = new BasicContext(cx, BFacets.make((String)"precision", (BIDataValue)result.getPrecision()));
                pointData.put("Status", (Object)result.getValue().getStatus().toString());
                pointData.put("Value", (Object)result.getValue().getValueValue().toString((Context)conversionContext));
                success = true;
            }
            values.put(pointId, (Object)pointData);
        }
        JSONObject body = new JSONObject();
        body.put("PointValues", (Object)values);
        if (success) {
            body.put("ResponseCode", 200);
            body.put("ErrorMessage", (Object)"Status: OK");
            code = 200;
        } else {
            body.put("ResponseCode", 403);
            body.put("ErrorMessage", (Object)"Error: Access Not Allowed");
            code = 403;
        }
        BForgeCommandContainer container = (BForgeCommandContainer)this.getParent().as(BForgeCommandContainer.class);
        return container.sendDataEvent(new ForgeCommandDataEvent(messageId, code, body));
    }
}

