/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.forge.command;

import com.tridium.cloudLink.command.BDeleteTagCommand;
import com.tridium.cloudLink.forge.command.BForgeCommandContainer;
import com.tridium.cloudLink.forge.command.BIForgeCommand;
import com.tridium.cloudLink.forge.command.ForgeCommandDataEvent;
import com.tridium.json.JSONArray;
import com.tridium.json.JSONObject;
import com.tridium.json.JSONUtil;
import java.util.concurrent.CompletableFuture;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public class BForgeDeleteMultiTagSystemCommand
extends BDeleteTagCommand
implements BIForgeCommand {
    public static final Type TYPE = Sys.loadType(BForgeDeleteMultiTagSystemCommand.class);
    public static final String COMMAND = "SystemCommand";
    public static final String COMMAND_NAME = "CloudMultiTagDeleteCommand";
    public static final String VERSION = "1";

    public Type getType() {
        return TYPE;
    }

    @Override
    public String getRoute() {
        return "SystemCommand.1";
    }

    @Override
    public String getCommandName() {
        return COMMAND_NAME;
    }

    @Override
    public String getVersion() {
        return VERSION;
    }

    @Override
    public CompletableFuture<Boolean> execute(String messageId, JSONObject data, Context cx) {
        int code;
        JSONObject payload = new JSONObject(JSONUtil.getString((JSONObject)data.getJSONObject("CommandParameters"), (String)"CommandPayload"));
        JSONArray tags = payload.getJSONArray("TagDeletes");
        JSONArray results = new JSONArray();
        boolean success = false;
        for (int lcv = 0; lcv < tags.length(); ++lcv) {
            JSONObject tag = tags.getJSONObject(lcv);
            String pointId = JSONUtil.getString((JSONObject)tag, (String)"PointId");
            String namespace = JSONUtil.getString((JSONObject)tag, (String)"Namespace");
            String tagName = JSONUtil.getString((JSONObject)tag, (String)"TagName");
            boolean result = this.deleteTag(messageId, pointId, namespace, tagName, cx);
            JSONObject pointData = new JSONObject();
            pointData.put("PointId", (Object)pointId);
            pointData.put("Namespace", (Object)namespace);
            pointData.put("TagName", (Object)tagName);
            pointData.put("Status", (Object)(result ? "Success" : "Error: Invalid tag delete"));
            results.put((Object)pointData);
            success |= result;
        }
        JSONObject body = new JSONObject();
        body.put("TagDeleteDetails", (Object)results);
        if (success) {
            body.put("ResponseCode", 200);
            body.put("ErrorMessage", (Object)"Status: OK");
            code = 200;
        } else {
            body.put("ResponseCode", 403);
            body.put("ErrorMessage", (Object)"Error: Access Not Allowed");
            code = 403;
        }
        BForgeCommandContainer container = (BForgeCommandContainer)this.getParent().as(BForgeCommandContainer.class);
        return container.sendDataEvent(new ForgeCommandDataEvent(messageId, code, body));
    }
}

