/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.forge.command;

import com.tridium.cloudLink.BAbstractCloudLinkHandlerFactory;
import com.tridium.cloudLink.BCloudConnectionService;
import com.tridium.cloudLink.ICloudLinkMessageHandler;
import com.tridium.cloudLink.channel.BChannelConfig;
import com.tridium.cloudLink.channel.BCommandsChannel;
import com.tridium.cloudLink.command.BAckAlarmCommand;
import com.tridium.cloudLink.forge.command.BForgeCommandContainer;
import com.tridium.cloudLink.forge.command.BIForgeCommand;
import com.tridium.cloudLink.forge.msg.IForgeAckAlarmCommandHandler;
import com.tridium.cloudLink.msg.AckAlarmResult;
import com.tridium.cloudLink.msg.IAckAlarmCommandHandler;
import com.tridium.cloudLink.msg.IPointWriteCommandHandler;
import com.tridium.cloudLink.transport.BAbstractTransport;
import com.tridium.cloudLink.transport.MessageWrapper;
import com.tridium.json.JSONObject;
import com.tridium.json.JSONUtil;
import java.io.IOException;
import java.security.AccessController;
import java.util.concurrent.CompletableFuture;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComponent;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public class BForgeAckAlarmCommand
extends BAckAlarmCommand
implements BIForgeCommand {
    public static final Type TYPE = Sys.loadType(BForgeAckAlarmCommand.class);
    public static final String COMMAND = "AlarmAckRequest";
    public static final String VERSION = "2";

    public Type getType() {
        return TYPE;
    }

    public void started() throws Exception {
        super.started();
        this.setCommandId(this.getCommandName());
    }

    public final boolean isParentLegal(BComponent parent) {
        return parent instanceof BForgeCommandContainer;
    }

    @Override
    public String getRoute() {
        return "AlarmAckRequest.2";
    }

    @Override
    public String getCommandName() {
        return COMMAND;
    }

    @Override
    public String getVersion() {
        return VERSION;
    }

    @Override
    public ICloudLinkMessageHandler<Boolean> getErrorResponse(BAbstractCloudLinkHandlerFactory msgFactory, BChannelConfig channelConfig, String messageId, int code, String message) {
        IForgeAckAlarmCommandHandler handler = (IForgeAckAlarmCommandHandler)msgFactory.getMessageHandler(IForgeAckAlarmCommandHandler.class, channelConfig);
        handler.addError(code, message);
        handler.setCorrelationId(messageId);
        return handler;
    }

    @Override
    public CompletableFuture<Boolean> execute(String messageId, JSONObject data, Context cx) {
        CompletableFuture<Boolean> future = new CompletableFuture<Boolean>();
        String alarmId = JSONUtil.getString((JSONObject)data, (String)"AlarmId");
        String acknowledgingApplication = JSONUtil.getString((JSONObject)data, (String)"AcknowledgingApplicationName");
        String callingIdentity = JSONUtil.getString((JSONObject)data, (String)"CallingIdentity");
        AckAlarmResult result = this.acknowledgeAlarm(messageId, alarmId, callingIdentity, acknowledgingApplication, cx);
        BCommandsChannel channel = this.getChannel();
        if (channel == null) {
            future.completeExceptionally(new IOException("no channel"));
            return future;
        }
        BChannelConfig config = channel.getChannelConfig();
        BAbstractTransport transport = config.getTransport(IAckAlarmCommandHandler.getOperationId());
        if (!transport.canSend()) {
            log.warning("unable to send command response transport down " + messageId);
            future.completeExceptionally(new IOException("transport down"));
            return future;
        }
        BAbstractCloudLinkHandlerFactory msgFactory = (BAbstractCloudLinkHandlerFactory)((BCloudConnectionService)channel.getConnectionService().orElseThrow(() -> new IllegalStateException("Unable to locate Cloud Connection Service."))).getMessageHandlerFactory(channel.getPlatformType(), transport.getTransportType()).orElseThrow(() -> new IllegalStateException("Unable to locate message handler factory."));
        IForgeAckAlarmCommandHandler handler = (IForgeAckAlarmCommandHandler)msgFactory.getMessageHandler(IForgeAckAlarmCommandHandler.class, config);
        handler.add(result);
        handler.setCorrelationId(messageId);
        MessageWrapper wrapper = new MessageWrapper(handler.toMessage(), handler.getFuture(future), transport.getMessageRetries());
        AccessController.doPrivileged(() -> {
            config.enqueueMessage(IPointWriteCommandHandler.getOperationId(), wrapper);
            return null;
        });
        transport.notifyPending();
        return future;
    }
}

