/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.forge.auth;

import com.tridium.cloudLink.transport.HttpResponseMessage;
import com.tridium.json.JSONObject;
import java.io.ByteArrayInputStream;
import java.nio.charset.StandardCharsets;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ForgeCsrResponse {
    private final int statusCode;
    private X509Certificate deviceCert;
    private X509Certificate issuerCert;
    private X509Certificate rootCert;
    private String dpsEndpoint;
    private String dpsScope;
    private String systemConnectionPath;
    private static final Logger log = Logger.getLogger("cloudLink.auth.forge");
    private static final String CERT_WRAPPER = "-----BEGIN PKCS7-----\n%s\n-----END PKCS7-----";
    private static final String DEVICE_CERTIFICATE = "device_leaf_certificate";
    private static final String DPS_ENDPOINT = "dps_global_endpoint";
    private static final String DPS_SCOPE = "dps_id_scope";
    private static final String ERROR_MSG_TEMPLATE = "Forge CSR response body is not in %s format, response body is %s";
    private static final String ISSUER_CERTIFICATE = "intermediate_ca_certificate";
    private static final String ROOT_CERTIFICATE = "root_ca_certificate";
    private static final String SYSTEM_CONNECTION_PATH = "system_connection_path";

    public ForgeCsrResponse(HttpResponseMessage message) {
        this.statusCode = message.getStatusCode();
        List headers = (List)message.getHeaders().get("content-type");
        if (headers == null || !headers.contains("application/json")) {
            log.config(() -> String.format(ERROR_MSG_TEMPLATE, "application/json", message.getBodyAsString()));
            return;
        }
        try {
            JSONObject data = new JSONObject(message.getBodyAsString());
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            ByteArrayInputStream inputStream = new ByteArrayInputStream(String.format(CERT_WRAPPER, data.getString(DEVICE_CERTIFICATE)).getBytes(StandardCharsets.UTF_8));
            this.deviceCert = (X509Certificate)certificateFactory.generateCertificate(inputStream);
            inputStream = new ByteArrayInputStream(String.format(CERT_WRAPPER, data.getString(ISSUER_CERTIFICATE)).getBytes(StandardCharsets.UTF_8));
            this.issuerCert = (X509Certificate)certificateFactory.generateCertificate(inputStream);
            inputStream = new ByteArrayInputStream(String.format(CERT_WRAPPER, data.getString(ROOT_CERTIFICATE)).getBytes(StandardCharsets.UTF_8));
            this.rootCert = (X509Certificate)certificateFactory.generateCertificate(inputStream);
            this.dpsEndpoint = data.optString(DPS_ENDPOINT);
            this.dpsEndpoint = this.dpsEndpoint.contains("://") ? this.dpsEndpoint.split("://", 2)[1] : this.dpsEndpoint;
            this.dpsScope = data.optString(DPS_SCOPE);
            this.systemConnectionPath = data.optString(SYSTEM_CONNECTION_PATH);
            log.finest(() -> String.format("Forge CSR response status = %d, Device cert = %s", this.statusCode, this.deviceCert));
        }
        catch (Exception ex) {
            log.log(Level.INFO, "Error processing Forge CSR response", log.isLoggable(Level.FINE) ? ex : null);
        }
    }

    public boolean isSuccessful() {
        return this.statusCode == 200 && this.deviceCert != null && this.issuerCert != null && this.rootCert != null;
    }

    public X509Certificate[] getCertChain() {
        return new X509Certificate[]{this.deviceCert, this.issuerCert, this.rootCert};
    }

    public String getDpsEndpoint() {
        return this.dpsEndpoint;
    }

    public String getDpsScope() {
        return this.dpsScope;
    }

    public String getSystemConnectionPath() {
        return this.systemConnectionPath;
    }
}

