/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.forge.auth;

import com.tridium.cloudLink.msg.IMessageBuilder;
import com.tridium.cloudLink.transport.HttpRequestMessage;
import com.tridium.cloudLink.transport.IMessage;
import com.tridium.crypto.core.cert.NPKCS10CertificationRequest;
import com.tridium.json.JSONWriter;
import com.tridium.json.quick.QuickJSONWriter;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ForgeCsrRequest
implements IMessageBuilder {
    private final String accessToken;
    private final String registrationHost;
    private final String systemGuid;
    private final String systemId;
    private final String systemType;
    private final NPKCS10CertificationRequest csr;
    private static final Logger log = Logger.getLogger("cloudLink.auth.forge");
    private static final String CSR = "csr";
    private static final String API_PATH = "/v2/device/%s/enroll";
    private static final String SYSTEM_TYPE = "system_type";
    private static final String SYSTEM_ID = "system_number";
    private static final String BEARER = "Bearer ";

    public ForgeCsrRequest(String server, String systemGuid, String accessToken, NPKCS10CertificationRequest csr, String systemType, String systemId) {
        this.registrationHost = server;
        this.systemGuid = systemGuid;
        this.accessToken = accessToken;
        this.systemType = systemType;
        this.systemId = systemId;
        this.csr = csr;
    }

    public IMessage toMessage(boolean isFinal) {
        URL url;
        StringWriter stringWriter = new StringWriter();
        JSONWriter jsonSerializer = QuickJSONWriter.make((Appendable)stringWriter);
        jsonSerializer.object();
        try {
            jsonSerializer.key(CSR).value((Object)this.csr.encodeToString().replace("\r\n", "\n").trim());
        }
        catch (Exception ex) {
            log.log(Level.INFO, "Unable to serialize Forge csr request", log.isLoggable(Level.FINE) ? ex : null);
            return null;
        }
        jsonSerializer.key(SYSTEM_TYPE).value((Object)this.systemType);
        jsonSerializer.key(SYSTEM_ID).value((Object)this.systemId);
        jsonSerializer.endObject();
        stringWriter.flush();
        String urlString = "https://" + this.registrationHost + String.format(API_PATH, this.systemGuid);
        try {
            url = new URL(urlString);
        }
        catch (MalformedURLException ex) {
            log.log(Level.INFO, "Unable to build URL for Forge csr request url = [" + urlString + ']', log.isLoggable(Level.FINE) ? ex : null);
            return null;
        }
        String correlationId = UUID.randomUUID().toString();
        log.config(() -> "Sending Forge csr request message with correlation " + correlationId);
        HashMap<String, String> requestHeaders = new HashMap<String, String>();
        requestHeaders.put("x-activity-id", correlationId);
        requestHeaders.put("Authorization", BEARER + this.accessToken);
        return new HttpRequestMessage.HttpRequestMessageBuilder(HttpRequestMessage.HttpMethod.POST, url, requestHeaders).mimeType("application/json").body(stringWriter.getBuffer().toString()).build();
    }
}

