/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.forge.auth;

import com.tridium.cloudLink.auth.BAbstractClientAuthenticator;
import com.tridium.cloudLink.auth.BClientAuthenticatorsFolder;
import com.tridium.cloudLink.auth.FederatedIdentityOcspRequest;
import com.tridium.cloudLink.auth.RsaKeyPairGeneratorSupplier;
import com.tridium.cloudLink.channel.BMessagingChannel;
import com.tridium.cloudLink.forge.auth.BAbstractForgeAuthenticator;
import com.tridium.cloudLink.forge.auth.BSystemRegistrationState;
import com.tridium.cloudLink.forge.auth.ConnectionInfo;
import com.tridium.cloudLink.forge.auth.ForgeBootstrapDeviceAuthRequest;
import com.tridium.cloudLink.forge.auth.ForgeBootstrapDeviceAuthResponse;
import com.tridium.cloudLink.forge.auth.ForgeCsrRenewalRequest;
import com.tridium.cloudLink.forge.auth.ForgeCsrRenewalResponse;
import com.tridium.cloudLink.forge.auth.ForgeCsrRequest;
import com.tridium.cloudLink.forge.auth.ForgeCsrResponse;
import com.tridium.cloudLink.forge.auth.ForgeDeviceAuthTokenRequest;
import com.tridium.cloudLink.forge.auth.ForgeDeviceAuthTokenResponse;
import com.tridium.cloudLink.forge.auth.ForgeOcspResponse;
import com.tridium.cloudLink.forge.auth.ForgeSystemConnectionsRequest;
import com.tridium.cloudLink.forge.auth.ForgeSystemConnectionsResponse;
import com.tridium.cloudLink.transport.BAbstractTransport;
import com.tridium.cloudLink.transport.HttpResponseMessage;
import com.tridium.cloudLink.transport.HttpStatusException;
import com.tridium.cloudLink.transport.IMessage;
import com.tridium.cloudLink.util.BICachingCertificateConsumer;
import com.tridium.cloudLink.util.BIDevConfigurer;
import com.tridium.cloudLink.util.CertificateAliasAndPasswordWrapper;
import com.tridium.cloudLink.util.IValueWrapper;
import com.tridium.cloudLink.util.PasswordWrapper;
import com.tridium.cloudLink.util.StringWrapper;
import com.tridium.crypto.core.cert.CertUtils;
import com.tridium.crypto.core.cert.KeyPurpose;
import com.tridium.crypto.core.cert.NCertificateParameters;
import com.tridium.nre.security.NiagaraBasicPermission;
import com.tridium.nre.security.SecretChars;
import com.tridium.util.CompUtil;
import java.io.IOException;
import java.net.URLDecoder;
import java.security.AccessController;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.Permission;
import java.security.cert.X509Certificate;
import java.time.Instant;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.baja.alarm.AlarmSupport;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.alarm.BAlarmSourceInfo;
import javax.baja.alarm.BIAlarmSource;
import javax.baja.alarm.BSourceState;
import javax.baja.data.BIDataValue;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraTopic;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.security.IX509CertificateEntry;
import javax.baja.security.BCertificateAliasAndPassword;
import javax.baja.security.BPassword;
import javax.baja.security.crypto.CertManagerFactory;
import javax.baja.security.crypto.IKeyStore;
import javax.baja.security.crypto.ITrustStore;
import javax.baja.status.BStatus;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;
import javax.baja.util.BFormat;
import javax.baja.util.ExecutorUtil;
import javax.baja.util.Lexicon;
import org.bouncycastle.cert.ocsp.CertificateStatus;
import org.bouncycastle.cert.ocsp.RevokedStatus;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="registrationState", type="BSystemRegistrationState", defaultValue="BSystemRegistrationState.DEFAULT", flags=257), @NiagaraProperty(name="authenticatorId", type="BString", defaultValue="BString.make(AUTH_PLATFORM_TYPE_CERT)", flags=1, override=true), @NiagaraProperty(name="alarmSourceInfo", type="BAlarmSourceInfo", defaultValue="initAlarmSourceInfo()"), @NiagaraProperty(name="registrationKey", type="String", defaultValue="", flags=3), @NiagaraProperty(name="deviceCode", type="String", defaultValue="", flags=7), @NiagaraProperty(name="codeExpiration", type="BAbsTime", defaultValue="BAbsTime.DEFAULT", flags=3), @NiagaraProperty(name="registrationHost", type="BString", defaultValue="BString.DEFAULT", flags=5), @NiagaraProperty(name="assignedHub", type="BString", defaultValue="BString.DEFAULT", flags=5), @NiagaraProperty(name="dpsEndpoint", type="BString", defaultValue="BString.DEFAULT", flags=5), @NiagaraProperty(name="dpsScope", type="BString", defaultValue="BString.DEFAULT", flags=5), @NiagaraProperty(name="statusMessage", type="String", defaultValue="", flags=259), @NiagaraProperty(name="certificatePassword", type="BPassword", defaultValue="BPassword.make(\"\")", flags=64, facets={@Facet(name="BPassword.PLACEHOLDER_TEXT", value="\"%lexicon(workbench:default.password.placeholder.label)%\""), @Facet(value="BFacets.make(BFacets.SECURITY, BBoolean.TRUE)")}), @NiagaraProperty(name="certRenewalDays", type="BInteger", defaultValue="BInteger.make(90)", flags=5, facets={@Facet(name="BFacets.MIN", value="15"), @Facet(name="BFacets.MAX", value="330")})})
@NiagaraActions(value={@NiagaraAction(name="startRegistration", flags=257), @NiagaraAction(name="ackAlarm", parameterType="BAlarmRecord", defaultValue="new BAlarmRecord()", returnType="BBoolean", flags=4)})
@NiagaraTopic(name="certificateUpdate", eventType="BString", flags=4)
public class BForgeCertificateAuthenticator
extends BAbstractForgeAuthenticator
implements BIAlarmSource {
    public static final Property registrationState = BForgeCertificateAuthenticator.newProperty((int)257, (BValue)BSystemRegistrationState.DEFAULT, null);
    public static final Property authenticatorId = BForgeCertificateAuthenticator.newProperty((int)1, (BValue)BString.make((String)"ForgeCertAuthenticator"), null);
    public static final Property alarmSourceInfo = BForgeCertificateAuthenticator.newProperty((int)0, (BValue)BForgeCertificateAuthenticator.initAlarmSourceInfo(), null);
    public static final Property registrationKey = BForgeCertificateAuthenticator.newProperty((int)3, (String)"", null);
    public static final Property deviceCode = BForgeCertificateAuthenticator.newProperty((int)7, (String)"", null);
    public static final Property codeExpiration = BForgeCertificateAuthenticator.newProperty((int)3, (BValue)BAbsTime.DEFAULT, null);
    public static final Property registrationHost = BForgeCertificateAuthenticator.newProperty((int)5, (BValue)BString.DEFAULT, null);
    public static final Property assignedHub = BForgeCertificateAuthenticator.newProperty((int)5, (BValue)BString.DEFAULT, null);
    public static final Property dpsEndpoint = BForgeCertificateAuthenticator.newProperty((int)5, (BValue)BString.DEFAULT, null);
    public static final Property dpsScope = BForgeCertificateAuthenticator.newProperty((int)5, (BValue)BString.DEFAULT, null);
    public static final Property statusMessage = BForgeCertificateAuthenticator.newProperty((int)259, (String)"", null);
    public static final Property certificatePassword = BForgeCertificateAuthenticator.newProperty((int)64, (BValue)BPassword.make((String)""), (BFacets)BFacets.make((BFacets)BFacets.make((String)"placeholderText", (String)"%lexicon(workbench:default.password.placeholder.label)%"), (BFacets)BFacets.make((String)"security", (BIDataValue)BBoolean.TRUE)));
    public static final Property certRenewalDays = BForgeCertificateAuthenticator.newProperty((int)5, (int)((BInteger)BInteger.make((int)90).as(BInteger.class)).getInt(), (BFacets)BFacets.make((BFacets)BFacets.make((String)"min", (int)15), (BFacets)BFacets.make((String)"max", (int)330)));
    public static final Action startRegistration = BForgeCertificateAuthenticator.newAction((int)257, null);
    public static final Action ackAlarm = BForgeCertificateAuthenticator.newAction((int)4, (BValue)new BAlarmRecord(), null);
    public static final Topic certificateUpdate = BForgeCertificateAuthenticator.newTopic((int)4, null);
    public static final Type TYPE = Sys.loadType(BForgeCertificateAuthenticator.class);
    private volatile Map<String, ConnectionInfo> cachedConnectionInfoMap = Collections.emptyMap();
    private ScheduledExecutorService executor;
    private BMessagingChannel messagingChannel;
    private boolean registering;
    private final Object syncObj = new Object();
    private final Object syncKeyStoreObj = new Object();
    private AlarmSupport alarmSupport;
    private BPassword currentCertPassword;
    private static final Lexicon lex;
    private static final Logger log;
    private static final int CERT_EXPIRATION_CHECK_DAYS = 1;
    private static final long jwtExpirationClockSkew;
    private static final String SAS_KEY_SE = "se";
    private static final Pattern SAS_PATTERN;
    private static final String SAS_TOKEN_PREFIX = "SharedAccessSignature";
    private static final String AUTH_DEV_CONFIGURER = "cloudLinkInternal:AuthDevConfigurer";
    private static final String MAKE_HOST_ID = "makeHostId";

    public BSystemRegistrationState getRegistrationState() {
        return (BSystemRegistrationState)this.get(registrationState);
    }

    public void setRegistrationState(BSystemRegistrationState v) {
        this.set(registrationState, (BValue)v, null);
    }

    public BAlarmSourceInfo getAlarmSourceInfo() {
        return (BAlarmSourceInfo)this.get(alarmSourceInfo);
    }

    public void setAlarmSourceInfo(BAlarmSourceInfo v) {
        this.set(alarmSourceInfo, (BValue)v, null);
    }

    public String getRegistrationKey() {
        return this.getString(registrationKey);
    }

    public void setRegistrationKey(String v) {
        this.setString(registrationKey, v, null);
    }

    public String getDeviceCode() {
        return this.getString(deviceCode);
    }

    public void setDeviceCode(String v) {
        this.setString(deviceCode, v, null);
    }

    public BAbsTime getCodeExpiration() {
        return (BAbsTime)this.get(codeExpiration);
    }

    public void setCodeExpiration(BAbsTime v) {
        this.set(codeExpiration, (BValue)v, null);
    }

    public String getRegistrationHost() {
        return this.getString(registrationHost);
    }

    public void setRegistrationHost(String v) {
        this.setString(registrationHost, v, null);
    }

    public String getAssignedHub() {
        return this.getString(assignedHub);
    }

    public void setAssignedHub(String v) {
        this.setString(assignedHub, v, null);
    }

    public String getDpsEndpoint() {
        return this.getString(dpsEndpoint);
    }

    public void setDpsEndpoint(String v) {
        this.setString(dpsEndpoint, v, null);
    }

    public String getDpsScope() {
        return this.getString(dpsScope);
    }

    public void setDpsScope(String v) {
        this.setString(dpsScope, v, null);
    }

    public String getStatusMessage() {
        return this.getString(statusMessage);
    }

    public void setStatusMessage(String v) {
        this.setString(statusMessage, v, null);
    }

    public BPassword getCertificatePassword() {
        return (BPassword)this.get(certificatePassword);
    }

    public void setCertificatePassword(BPassword v) {
        this.set(certificatePassword, (BValue)v, null);
    }

    public int getCertRenewalDays() {
        return this.getInt(certRenewalDays);
    }

    public void setCertRenewalDays(int v) {
        this.setInt(certRenewalDays, v, null);
    }

    public void startRegistration() {
        this.invoke(startRegistration, null, null);
    }

    public BBoolean ackAlarm(BAlarmRecord parameter) {
        return (BBoolean)this.invoke(ackAlarm, (BValue)parameter, null);
    }

    public void fireCertificateUpdate(BString event) {
        this.fire(certificateUpdate, (BValue)event, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    public void serviceStarted() throws Exception {
        if (this.getConnectionService().map(c -> c.isFatalFault()).orElse(true).booleanValue()) {
            return;
        }
        super.serviceStarted();
        this.currentCertPassword = BPassword.make((String)AccessController.doPrivileged(() -> ((BPassword)this.getCertificatePassword()).getValue()));
        this.alarmSupport = new AlarmSupport((BIAlarmSource)this, this.getAlarmSourceInfo());
        this.executor = ExecutorUtil.newSingleThreadBackgroundScheduledExecutor((String)"federatedIdentityAuth", (long)2L, (TimeUnit)TimeUnit.MINUTES);
        this.getConnectionService().ifPresent(ccs -> ccs.registerForConnectionServiceReady(() -> {
            this.executor.schedule(this::checkCertExpiration, 1L, TimeUnit.MINUTES);
            for (BICachingCertificateConsumer consumer : (BICachingCertificateConsumer[])CompUtil.getDescendants((BComponent)ccs, BICachingCertificateConsumer.class)) {
                if (!(consumer instanceof BComponent)) continue;
                ((BComponent)consumer).linkTo((BComponent)this, (Slot)certificateUpdate, (Slot)consumer.getCertificateUpdateAction());
            }
        }));
        this.registerTransport();
    }

    public void changed(Property p, Context cx) {
        super.changed(p, cx);
        if (!this.isRunning()) {
            return;
        }
        if (p.equals(certificatePassword)) {
            if (this.currentCertPassword == null) {
                return;
            }
            this.executor.execute(this::changeCertificatePassword);
        }
    }

    public void serviceStopped() throws Exception {
        super.serviceStopped();
        if (this.executor != null) {
            this.executor.shutdownNow();
        }
    }

    public final void addMessageHandlerProperties(BAbstractTransport transport, String audience, Map<String, Object> encoderProps) {
        if (!this.isOperational()) {
            log.info("Cannot supply certificate to message handler because authenticator is disabled");
            return;
        }
        SecurityManager sm = System.getSecurityManager();
        if (sm == null) {
            log.finest("addMessageHandlerProperties called with no security manager");
            return;
        }
        sm.checkPermission((Permission)new NiagaraBasicPermission("CLOUD_GET_CONNECTION_INFORMATION"));
        BCertificateAliasAndPassword certAliasAndPass = new BCertificateAliasAndPassword(this.getCertAlias(), this.currentCertPassword);
        encoderProps.put("certAliasAndPassword", certAliasAndPass);
    }

    public final Map<String, IValueWrapper<?>> getConnectionInfo(String id) {
        if (!this.isOperational()) {
            log.finest("getConnectionInfo called while authenticator is not operational");
            return Collections.emptyMap();
        }
        SecurityManager sm = System.getSecurityManager();
        if (sm == null) {
            log.finest("getConnectionInfo called with no security manager");
            return Collections.emptyMap();
        }
        sm.checkPermission((Permission)new NiagaraBasicPermission("CLOUD_GET_CONNECTION_INFORMATION"));
        String alias = this.getCertAlias();
        if (alias == null || this.registering) {
            log.finest("getConnectionInfo called while authenticator is not authenticated");
            return Collections.emptyMap();
        }
        HashMap connectionMap = new HashMap();
        ConnectionInfo info = null;
        try {
            if (!this.cachedConnectionInfoMap.isEmpty()) {
                BPassword password;
                String passwordValue;
                info = this.cachedConnectionInfoMap.get(id);
                if (info != null && BForgeCertificateAuthenticator.isSasTokenExpired(passwordValue = AccessController.doPrivileged(() -> BForgeCertificateAuthenticator.lambda$getConnectionInfo$3(password = info.getPassword())))) {
                    this.getTokens().get(30L, TimeUnit.SECONDS);
                    info = this.cachedConnectionInfoMap.get(id);
                }
            } else {
                this.getTokens().get(30L, TimeUnit.SECONDS);
                info = this.cachedConnectionInfoMap.get(id);
            }
        }
        catch (InterruptedException | ExecutionException | TimeoutException ex) {
            log.log(Level.INFO, "error updating connection info", log.isLoggable(Level.FINE) ? ex : null);
        }
        if (info != null) {
            connectionMap.put("hostName", (IValueWrapper<?>)new StringWrapper(info.getPath()));
            connectionMap.put("id", (IValueWrapper<?>)new StringWrapper(info.getUserName()));
            connectionMap.put("token", (IValueWrapper<?>)new PasswordWrapper(info.getPassword()));
        } else {
            connectionMap.put("hostName", (IValueWrapper<?>)new StringWrapper(this.getRegistrationHost()));
            connectionMap.put("id", (IValueWrapper<?>)new StringWrapper(this.getSystemGuid()));
            BCertificateAliasAndPassword certAliasAndPass = new BCertificateAliasAndPassword(this.getCertAlias(), this.currentCertPassword);
            connectionMap.put("certAliasAndPassword", (IValueWrapper<?>)new CertificateAliasAndPasswordWrapper(certAliasAndPass));
        }
        return connectionMap;
    }

    public Map<String, Object> getPlatformProperties() {
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("systemGuid", this.getSystemGuid());
        props.put("systemType", this.getSystemType());
        props.put("systemId", this.getSystemId());
        return props;
    }

    public boolean canAuthenticate() {
        return this.isOperational() && this.getCertAlias() != null;
    }

    public boolean isRegistered() {
        return this.getRegistrationState().isRegistered();
    }

    public Type[] getServiceTypes() {
        return new Type[]{TYPE};
    }

    public BBoolean doAckAlarm(BAlarmRecord alarmRecord) {
        try {
            boolean ack = this.alarmSupport.ackAlarm(alarmRecord);
            if (ack) {
                this.setStatus(BStatus.make((BStatus)this.getStatus(), (int)128, (boolean)false));
            }
            return BBoolean.make((boolean)ack);
        }
        catch (Exception ex) {
            log.log(Level.WARNING, "Cannot process alarm ack:" + ex.getMessage(), log.isLoggable(Level.FINE) ? ex : null);
            return BBoolean.FALSE;
        }
    }

    public final void doStartRegistration() {
        if (!this.isOperational()) {
            log.warning("Start registration called when Authenticator is not operational");
            this.setStatusMessage(lex.get("fca.notOperational"));
            return;
        }
        if (this.getCertAlias() != null) {
            log.info("Start registration called when already registered");
            return;
        }
        this.setStatusMessage("");
        String hostId = this.getSystemId();
        if (hostId.isEmpty()) {
            hostId = Arrays.stream(((BClientAuthenticatorsFolder)this.getParent().as(BClientAuthenticatorsFolder.class)).getChildren(BIDevConfigurer.class)).filter(biDevConfigurer -> AUTH_DEV_CONFIGURER.equals(biDevConfigurer.getType().toString())).findFirst().map(biDevConfigurer -> String.valueOf(biDevConfigurer.configure((BAbstractClientAuthenticator)this, new Object[]{MAKE_HOST_ID}))).orElse(Sys.getHostId());
            this.setSystemId(hostId);
        }
        ForgeBootstrapDeviceAuthRequest request = new ForgeBootstrapDeviceAuthRequest(this.getRegistrationHost(), this.getSystemType());
        CompletableFuture reqFuture = AccessController.doPrivileged(() -> this.messagingChannel.sendAsync("HTTP", request.toMessage(true)));
        reqFuture.whenComplete((resp, err) -> {
            if (err != null) {
                log.log(Level.SEVERE, "Error in Forge bootstrap device authentication: " + err.getMessage(), log.isLoggable(Level.FINE) ? err : null);
                this.setStatusMessage(this.getInitError((Throwable)err));
            } else {
                ForgeBootstrapDeviceAuthResponse response = new ForgeBootstrapDeviceAuthResponse((HttpResponseMessage)resp);
                if (response.isSuccessful()) {
                    log.config("received successful bootstrap registration response");
                    this.setDeviceCode(response.getDeviceCode());
                    this.setRegistrationKey(response.getRegistrationKey());
                    this.setCodeExpiration(response.getExpirationTime());
                    int delay = 18;
                    List values = (List)((HttpResponseMessage)resp).getHeaders().get("retry-after");
                    if (values != null && !values.isEmpty()) {
                        try {
                            delay = Integer.parseInt((String)values.get(0));
                        }
                        catch (NumberFormatException ex) {
                            log.log(Level.INFO, "unable to parse retry after value, using default", log.isLoggable(Level.FINE) ? ex : null);
                        }
                    }
                    this.executor.schedule(this::checkRegistered, (long)delay, TimeUnit.SECONDS);
                } else {
                    log.severe("bootstrap registration response missing device code");
                }
            }
        });
    }

    protected void checkRegistered() {
        if (!this.getSystemGuid().isEmpty()) {
            log.config("System Guid already set, aborting");
            return;
        }
        ForgeDeviceAuthTokenRequest request = new ForgeDeviceAuthTokenRequest(this.getRegistrationHost(), this.getSystemType(), this.getDeviceCode());
        CompletableFuture reqFuture = AccessController.doPrivileged(() -> this.messagingChannel.sendAsync("HTTP", request.toMessage(true)));
        reqFuture.whenComplete((resp, err) -> {
            if (err != null) {
                if (BAbsTime.now().isAfter(this.getCodeExpiration())) {
                    log.log(Level.INFO, "Registration key expired before device registered", log.isLoggable(Level.FINE) ? err : null);
                    this.setStatusMessage(lex.get("fca.expired"));
                } else if (err instanceof HttpStatusException && ((HttpStatusException)err).getStatusCode() == 410) {
                    log.log(Level.INFO, "Registration key expired before device registered", log.isLoggable(Level.FINE) ? err : null);
                    this.setStatusMessage(lex.get("fca.expired"));
                } else {
                    log.log(Level.SEVERE, "Error in Forge certificate authentication get system guid", log.isLoggable(Level.FINE) ? err : null);
                    this.setStatusMessage(this.getInitError((Throwable)err));
                }
            } else {
                ForgeDeviceAuthTokenResponse response = new ForgeDeviceAuthTokenResponse((HttpResponseMessage)resp);
                if (response.isSuccessful()) {
                    log.config("received device UUID");
                    Object object = this.syncObj;
                    synchronized (object) {
                        if (!this.getSystemId().isEmpty() && this.getSystemId().equals(response.getDeviceGuid())) {
                            log.info("System Guid already set, aborting");
                            return;
                        }
                        this.setSystemGuid(response.getDeviceGuid());
                    }
                    this.setRegistrationState(BSystemRegistrationState.needsProvisioning);
                    this.registering = true;
                    this.makeCSR(response.getAccessToken());
                } else {
                    int delay = 18;
                    List values = (List)((HttpResponseMessage)resp).getHeaders().get("retry-after");
                    if (values != null && !values.isEmpty()) {
                        try {
                            delay = Integer.parseInt((String)values.get(0));
                        }
                        catch (NumberFormatException ex) {
                            log.log(Level.INFO, "unable to parse retry after value, using default", log.isLoggable(Level.FINE) ? ex : null);
                        }
                    }
                    this.executor.schedule(this::checkRegistered, (long)delay, TimeUnit.SECONDS);
                }
            }
        });
    }

    protected void makeCSR(String accessToken) {
        ForgeCsrRequest request;
        KeyPairGenerator keyPairGen = new RsaKeyPairGeneratorSupplier().get();
        KeyPair keyPair = keyPairGen.generateKeyPair();
        String alias = "Forge_" + this.getSystemGuid();
        try {
            IX509CertificateEntry cert = this.makeX509Certificate(keyPair, alias, 120);
            request = new ForgeCsrRequest(this.getRegistrationHost(), this.getSystemGuid(), accessToken, CertUtils.generateCSR((IX509CertificateEntry)cert), this.getSystemType(), this.getSystemId());
        }
        catch (Exception ex) {
            this.setStatusMessage(lex.get("fca.makeCsrError"));
            log.log(Level.SEVERE, "unable to generate certificate", log.isLoggable(Level.FINE) ? ex : null);
            this.registering = false;
            return;
        }
        IMessage msg = request.toMessage(true);
        if (msg == null) {
            this.setStatusMessage(lex.get("fca.sendCsrError"));
            log.severe("unable to generate CSR message");
            this.registering = false;
            return;
        }
        CompletableFuture reqFuture = AccessController.doPrivileged(() -> this.messagingChannel.sendAsync("HTTP", msg));
        reqFuture.whenComplete((resp, err) -> {
            block25: {
                if (err != null) {
                    if (this.getCodeExpiration().subtract(BRelTime.MINUTE).isAfter(BAbsTime.now())) {
                        log.log(Level.INFO, "Error requesting Forge CSR, retrying", log.isLoggable(Level.FINE) ? err : null);
                        this.setStatusMessage(lex.get("fca.makeCsrErrorRetry"));
                        this.executor.schedule(() -> this.makeCSR(accessToken), 1L, TimeUnit.MINUTES);
                    } else {
                        log.log(Level.SEVERE, "Error in Forge CSR, station will need to be re-registered", log.isLoggable(Level.FINE) ? err : null);
                        this.setStatusMessage(this.getInitError((Throwable)err));
                        this.setRegistrationState(BSystemRegistrationState.unregistered);
                        this.setSystemGuid("");
                        this.registering = false;
                    }
                } else {
                    try {
                        ForgeCsrResponse response = new ForgeCsrResponse((HttpResponseMessage)resp);
                        if (response.isSuccessful()) {
                            X509Certificate[] certChain = response.getCertChain();
                            ITrustStore userTrustStore = CertManagerFactory.getInstance().getUserTrustStore();
                            userTrustStore.setCertificateEntry("ForgeDeviceCA", certChain[certChain.length - 1]);
                            userTrustStore.save();
                            IKeyStore userKeyStore = CertManagerFactory.getInstance().getKeyStore();
                            try (SecretChars secret = AccessController.doPrivileged(() -> ((BPassword)this.currentCertPassword).getSecretChars());){
                                userKeyStore.setKeyEntry(alias, (Key)keyPair.getPrivate(), secret.get(), certChain);
                                userKeyStore.save();
                            }
                            this.setDpsEndpoint(response.getDpsEndpoint());
                            this.setDpsScope(response.getDpsScope());
                            if (!response.getSystemConnectionPath().isEmpty()) {
                                this.getTokens().whenComplete((res, error) -> {
                                    this.setRegistrationState(BSystemRegistrationState.registered);
                                    this.registering = false;
                                    this.fireCertificateUpdate(BString.make((String)("Forge_" + this.getSystemGuid())));
                                });
                            } else {
                                log.warning("CSR response did not include Connection Info data.");
                                this.setStatusMessage(lex.get("fca.noConnectionInfoEndpoint"));
                            }
                            break block25;
                        }
                        if (this.getCodeExpiration().subtract(BRelTime.MINUTE).isAfter(BAbsTime.now())) {
                            log.info("Forge CSR response did not contain certificate, retrying");
                            this.setStatusMessage(lex.get("fca.makeCsrErrorRetry"));
                            this.executor.schedule(() -> this.makeCSR(accessToken), 1L, TimeUnit.MINUTES);
                        } else {
                            this.setStatusMessage(lex.get("fca.csrResponseError"));
                            log.warning("Forge CSR response did not contain certificate, token expired unable to retry");
                            this.setRegistrationState(BSystemRegistrationState.unregistered);
                            this.setSystemGuid("");
                            this.registering = false;
                        }
                    }
                    catch (Exception ex) {
                        if (this.getCodeExpiration().subtract(BRelTime.MINUTE).isAfter(BAbsTime.now())) {
                            log.log(Level.INFO, "Error requesting Forge CSR, retrying", log.isLoggable(Level.FINE) ? ex : null);
                            this.setStatusMessage(lex.get("fca.makeCsrErrorRetry"));
                            this.executor.schedule(() -> this.makeCSR(accessToken), 1L, TimeUnit.MINUTES);
                        }
                        this.setStatusMessage(lex.get("fca.csrResponseError"));
                        log.log(Level.SEVERE, "Error processing Forge CSR response", log.isLoggable(Level.FINE) ? ex : null);
                        this.setRegistrationState(BSystemRegistrationState.unregistered);
                        this.setSystemGuid("");
                        this.registering = false;
                    }
                }
            }
        });
    }

    protected CompletableFuture<Void> getTokens() {
        ForgeSystemConnectionsRequest request = new ForgeSystemConnectionsRequest(this.getRegistrationHost(), new BCertificateAliasAndPassword("Forge_" + this.getSystemGuid(), this.currentCertPassword));
        CompletableFuture reqFuture = AccessController.doPrivileged(() -> this.messagingChannel.sendAsync("HTTP", request.toMessage(true)));
        CompletableFuture<Void> responseFuture = new CompletableFuture<Void>();
        reqFuture.whenComplete((resp, err) -> {
            if (err != null) {
                log.log(Level.WARNING, "Error getting connection info", log.isLoggable(Level.FINE) ? err : null);
                responseFuture.completeExceptionally((Throwable)err);
            } else {
                ForgeSystemConnectionsResponse response = new ForgeSystemConnectionsResponse((HttpResponseMessage)resp);
                if (response.isSuccessful()) {
                    this.cachedConnectionInfoMap = response.getConectionsMap();
                    responseFuture.complete(null);
                } else {
                    responseFuture.completeExceptionally(new IOException("no connection information returned"));
                }
            }
        });
        return responseFuture;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkCertExpiration() {
        try {
            BAbsTime expiration;
            IKeyStore userKeyStore = CertManagerFactory.getInstance().getKeyStore();
            String alias = "Forge_" + this.getSystemGuid();
            X509Certificate cert = AccessController.doPrivileged(() -> userKeyStore.getCertificate(alias));
            if (cert != null && (expiration = BAbsTime.make((long)cert.getNotAfter().getTime())).isBefore(BAbsTime.now().add(BRelTime.makeDays((int)this.getCertRenewalDays())))) {
                this.checkOcsp().whenComplete((resp, err) -> {
                    if (err != null && expiration.isBefore(BAbsTime.now().add(BRelTime.makeDays((int)1))) && !this.getStatus().isAlarm()) {
                        BFacets alarmData = this.getAlarmSourceInfo().makeAlarmData(BSourceState.offnormal);
                        String msgText = alarmData.gets("msgText", "");
                        alarmData = BFacets.make((BFacets)alarmData, (String)"msgText", (BIDataValue)BString.make((String)(msgText + " \n" + lex.get("fca.cert.expiration") + ' ' + expiration.encodeToString())));
                        try {
                            this.alarmSupport.newOffnormalAlarm(alarmData);
                        }
                        catch (Exception ex) {
                            log.log(Level.SEVERE, "Cannot generate off normal alarm for certificate expiration:" + ex.getLocalizedMessage(), log.isLoggable(Level.FINE) ? ex : null);
                        }
                        int newStatus = this.getStatus().getBits();
                        this.setStatus(BStatus.make((int)(newStatus |= 0x88)));
                    }
                    if (err == null) {
                        this.clearCertAlarm();
                    }
                });
            }
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, "error checking certificate expiration", log.isLoggable(Level.FINE) ? ex : null);
        }
        finally {
            this.executor.schedule(this::checkCertExpiration, 1L, TimeUnit.DAYS);
        }
    }

    protected CompletableFuture<Void> checkOcsp() {
        CompletableFuture<Void> renewFuture = new CompletableFuture<Void>();
        try {
            IKeyStore userKeyStore = CertManagerFactory.getInstance().getKeyStore();
            String alias = "Forge_" + this.getSystemGuid();
            X509Certificate[] certChain = userKeyStore.getCertificateChain(alias);
            BCertificateAliasAndPassword aliasAndPassword = new BCertificateAliasAndPassword(alias, this.currentCertPassword);
            if (certChain != null && certChain.length > 1) {
                FederatedIdentityOcspRequest request = new FederatedIdentityOcspRequest(aliasAndPassword, certChain[0], certChain[1]);
                IMessage msg = request.toMessage(true);
                if (msg == null) {
                    this.setStatusMessage(lex.get("fca.sendOcspError"));
                    log.info("unable to generate OCSP message");
                    renewFuture.completeExceptionally(new IOException("unable to generate OCSP message"));
                    return renewFuture;
                }
                CompletableFuture reqFuture = AccessController.doPrivileged(() -> this.messagingChannel.sendAsync("HTTP", msg));
                reqFuture.whenComplete((resp, err) -> {
                    if (err != null) {
                        log.info("error from OCSP server");
                        renewFuture.completeExceptionally((Throwable)err);
                    } else {
                        try {
                            ForgeOcspResponse response = new ForgeOcspResponse((HttpResponseMessage)resp, certChain[1]);
                            CertificateStatus certStatus = response.getCertStatus(request.getCertificateID());
                            if (certStatus instanceof RevokedStatus) {
                                log.warning("OCSP server has revoked device certificate for Forge");
                                this.getConnectionService().ifPresent(ccs -> {
                                    ccs.setEnabled(false);
                                    ccs.configFail(lex.get("fca.cert.revoked"));
                                });
                            } else {
                                this.rollCert(renewFuture);
                            }
                        }
                        catch (Exception ex) {
                            log.log(Level.INFO, "error processing OCSP response", log.isLoggable(Level.FINE) ? ex : null);
                            renewFuture.completeExceptionally(ex);
                        }
                    }
                });
            }
        }
        catch (Exception ex) {
            log.log(Level.INFO, "error preforming OCSP check", log.isLoggable(Level.FINE) ? ex : null);
            renewFuture.completeExceptionally(ex);
        }
        return renewFuture;
    }

    protected void rollCert(CompletableFuture<Void> renewFuture) {
        ForgeCsrRenewalRequest request;
        KeyPairGenerator keyPairGen = new RsaKeyPairGeneratorSupplier().get();
        KeyPair keyPair = keyPairGen.generateKeyPair();
        String alias = "Forge_" + this.getSystemGuid();
        BCertificateAliasAndPassword aliasAndPassword = new BCertificateAliasAndPassword(alias, this.currentCertPassword);
        try {
            IX509CertificateEntry cert = this.makeX509Certificate(keyPair, alias, 120);
            request = new ForgeCsrRenewalRequest(this.getRegistrationHost(), aliasAndPassword, CertUtils.generateCSR((IX509CertificateEntry)cert));
        }
        catch (Exception ex) {
            this.setStatusMessage(lex.get("fca.makeCsrError"));
            log.log(Level.SEVERE, "unable to generate renewal certificate", log.isLoggable(Level.FINE) ? ex : null);
            this.registering = false;
            return;
        }
        IMessage msg = request.toMessage(true);
        if (msg == null) {
            this.setStatusMessage(lex.get("fca.sendCsrError"));
            log.severe("unable to generate renewal CSR message");
            this.registering = false;
            return;
        }
        CompletableFuture reqFuture = AccessController.doPrivileged(() -> this.messagingChannel.sendAsync("HTTP", msg));
        reqFuture.whenComplete((resp, err) -> {
            block18: {
                if (err != null) {
                    log.log(Level.SEVERE, "Error in Forge renewal CSR", log.isLoggable(Level.FINE) ? err : null);
                    this.setStatusMessage(this.getInitError((Throwable)err));
                    renewFuture.completeExceptionally((Throwable)err);
                } else {
                    try {
                        ForgeCsrRenewalResponse response = new ForgeCsrRenewalResponse((HttpResponseMessage)resp);
                        if (response.isSuccessful()) {
                            IKeyStore userKeyStore = CertManagerFactory.getInstance().getKeyStore();
                            X509Certificate[] certChain = userKeyStore.getCertificateChain(alias);
                            certChain[0] = response.getDeviceCert();
                            try (SecretChars secret = AccessController.doPrivileged(() -> ((BPassword)this.currentCertPassword).getSecretChars());){
                                userKeyStore.setKeyEntry(alias, (Key)keyPair.getPrivate(), secret.get(), certChain);
                                userKeyStore.save();
                            }
                            renewFuture.complete(null);
                            this.fireCertificateUpdate(BString.make((String)("Forge_" + this.getSystemGuid())));
                            break block18;
                        }
                        log.info("Forge CSR response did not contain certificate, retrying");
                        this.executor.schedule(() -> this.rollCert(renewFuture), 1L, TimeUnit.MINUTES);
                    }
                    catch (Exception ex) {
                        this.setStatusMessage(lex.get("fca.csrResponseError"));
                        log.log(Level.WARNING, "Error processing Forge renewal CSR response", log.isLoggable(Level.FINE) ? ex : null);
                        renewFuture.completeExceptionally(ex);
                    }
                }
            }
        });
    }

    private void registerTransport() {
        this.getConnectionService().ifPresent(ccs -> {
            this.messagingChannel = (BMessagingChannel)ccs.getChannel("Messaging");
        });
        if (this.messagingChannel == null) {
            log.warning("Could not find messaging channel for use by the Forge Certificate Authenticator; will not be able to authenticate!");
        }
    }

    public String getCertAlias() {
        return AccessController.doPrivileged(() -> {
            try {
                IKeyStore userKeyStore = CertManagerFactory.getInstance().getKeyStore();
                String alias = "Forge_" + this.getSystemGuid();
                X509Certificate cert = userKeyStore.getCertificate(alias);
                Date now = Date.from(Instant.now());
                if (cert != null && cert.getNotAfter().after(now)) {
                    return alias;
                }
            }
            catch (Exception ex) {
                log.log(Level.WARNING, "error getting Forge cert", log.isLoggable(Level.FINE) ? ex : null);
            }
            return null;
        });
    }

    protected IX509CertificateEntry makeX509Certificate(KeyPair keyPair, String alias, int months) throws Exception {
        String dn = String.format("CN=%s", this.getSystemGuid());
        Calendar cal = Calendar.getInstance();
        Date notBefore = cal.getTime();
        cal.add(2, months);
        Date notAfter = cal.getTime();
        NCertificateParameters parameters = new NCertificateParameters(alias, dn, dn, notBefore, notAfter, 0, KeyPurpose.CLIENT_CERT, null, null, null);
        IX509CertificateEntry cert = CertUtils.generateSelfSignedCert((KeyPair)keyPair, (NCertificateParameters)parameters);
        return cert;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void changeCertificatePassword() {
        Object object = this.syncKeyStoreObj;
        synchronized (object) {
            block34: {
                BPassword newCertPassword = BPassword.make((String)AccessController.doPrivileged(() -> ((BPassword)this.getCertificatePassword()).getValue()));
                if (newCertPassword.getValue().isEmpty()) {
                    log.info("attempt to set Forge certificate authenticator password to the empty string, restoring previous password.");
                    this.setCertificatePassword(this.currentCertPassword);
                    return;
                }
                if (this.currentCertPassword.validate(newCertPassword)) {
                    log.finest("The new certificate password matched the current certificate password. The certificate's password was not changed.");
                    return;
                }
                log.info("Changing the certificate password...");
                String systemGuid = this.getSystemGuid();
                if (systemGuid.isEmpty()) {
                    this.currentCertPassword = newCertPassword;
                    log.info("Completed certificate password change.");
                    return;
                }
                try {
                    IKeyStore userKeyStore = CertManagerFactory.getInstance().getKeyStore();
                    String alias = "Forge_" + this.getSystemGuid();
                    if (!userKeyStore.containsAlias(alias)) break block34;
                    try (SecretChars currentSecret = AccessController.doPrivileged(() -> ((BPassword)this.currentCertPassword).getSecretChars());
                         SecretChars newSecret = AccessController.doPrivileged(() -> ((BPassword)newCertPassword).getSecretChars());){
                        Key privateKey = userKeyStore.getKey(alias, currentSecret.get());
                        X509Certificate[] certChain = userKeyStore.getCertificateChain(alias);
                        try {
                            userKeyStore.setKeyEntry(alias, privateKey, newSecret.get(), certChain);
                            userKeyStore.save();
                            this.currentCertPassword = newCertPassword;
                        }
                        catch (Exception ex) {
                            userKeyStore.setKeyEntry(alias, privateKey, currentSecret.get(), certChain);
                            throw new Exception("Forge certificate password change failed.", ex);
                        }
                    }
                }
                catch (Exception except) {
                    log.fine("Reverting the certificatePassword property change.");
                    this.setCertificatePassword(this.currentCertPassword);
                    log.log(Level.WARNING, "The certificate password was not changed.", log.isLoggable(Level.FINE) ? except : null);
                }
            }
        }
    }

    private void clearCertAlarm() {
        if (this.getStatus().isAlarm()) {
            this.setStatus(BStatus.make((BStatus)this.getStatus(), (int)8, (boolean)false));
            try {
                this.alarmSupport.toNormal(null);
            }
            catch (Exception ex) {
                log.log(Level.WARNING, "Cannot clear offnormal alarm for certificate expiration:" + ex.getMessage(), log.isLoggable(Level.FINE) ? ex : null);
            }
        }
    }

    private static BAlarmSourceInfo initAlarmSourceInfo() {
        BAlarmSourceInfo asi = new BAlarmSourceInfo();
        asi.setSourceName(BFormat.make((String)"CloudLink %parent.displayName%"));
        asi.setToOffnormalText(BFormat.make((String)"%lexicon(cloudLinkForge:fca.cert.failure)%"));
        asi.setToNormalText(BFormat.make((String)"%lexicon(cloudLinkForge:fca.cert.success)%"));
        return asi;
    }

    private static boolean isSasTokenExpired(String token) {
        try {
            Map<String, String> sasParams;
            String sasValueSe;
            if (BForgeCertificateAuthenticator.isSasToken(token) && (sasValueSe = (sasParams = BForgeCertificateAuthenticator.parseSasToken(token)).get(SAS_KEY_SE)) != null) {
                long epochSec = Long.parseLong(sasValueSe);
                BAbsTime expirationTime = BAbsTime.make((long)((epochSec - jwtExpirationClockSkew) * 1000L));
                BAbsTime now = BAbsTime.now();
                log.config(() -> String.format("Expiration time from token: %s", expirationTime));
                return expirationTime.isBefore(now);
            }
        }
        catch (Exception ex) {
            log.fine(() -> String.format("Could not determine expiration of token: %s", ex));
        }
        return true;
    }

    public static boolean isSasToken(String sasToken) {
        if (sasToken == null || sasToken.isEmpty()) {
            return false;
        }
        return sasToken.trim().startsWith(SAS_TOKEN_PREFIX);
    }

    private static Map<String, String> parseSasToken(String sasToken) {
        HashMap<String, String> sasParams = new HashMap<String, String>();
        if (sasToken == null || sasToken.isEmpty()) {
            return sasParams;
        }
        try {
            Matcher matcher = SAS_PATTERN.matcher(sasToken);
            while (matcher.find()) {
                String key = matcher.group(1);
                String value = matcher.group(2);
                if (key == null || key.isEmpty()) continue;
                value = value == null ? "unavailable" : URLDecoder.decode(value.trim(), "UTF-8");
                sasParams.put(key, value);
            }
        }
        catch (Exception ex) {
            log.log(Level.CONFIG, "An error occurred while parsing the SAS Token.", log.isLoggable(Level.FINE) ? ex : null);
        }
        return sasParams;
    }

    public String getInitError(Throwable err) {
        return lex.get("fca.generalError");
    }

    private static /* synthetic */ String lambda$getConnectionInfo$3(BPassword password) {
        return password == null ? null : password.getValue();
    }

    static {
        jwtExpirationClockSkew = Long.getLong("niagara.cloud.jwt.expiration.skew", BRelTime.HOUR.getSeconds());
        lex = Lexicon.make(BForgeCertificateAuthenticator.class);
        log = Logger.getLogger("cloudLink.auth.forge");
        SAS_PATTERN = Pattern.compile("(\\w+)=([^&]+)(?:&|$)");
    }
}

