/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.forge.auth;

import com.tridium.cloudLink.transport.HttpResponseMessage;
import com.tridium.json.JSONObject;
import java.util.List;
import java.util.logging.Logger;

public class AzureDpsRegisterCertResponse {
    private final int statusCode;
    private int retryAfter = 5;
    private String operationId;
    private String status;
    private static final Logger log = Logger.getLogger("cloudLink.auth.forge");
    private static final String ERROR_MSG_TEMPLATE = "Azure DPS register response body is not in %s format, response body is %s";
    private static final String OPERATION_ID = "operationId";
    private static final String STATUS = "status";

    public AzureDpsRegisterCertResponse(HttpResponseMessage message) {
        this.statusCode = message.getStatusCode();
        List headers = (List)message.getHeaders().get("content-type");
        if (headers == null || headers.isEmpty() || !((String)headers.get(0)).startsWith("application/json")) {
            log.config(() -> String.format(ERROR_MSG_TEMPLATE, "application/json", message.getBodyAsString()));
            return;
        }
        headers = (List)message.getHeaders().get("retry-after");
        if (headers != null && !headers.isEmpty()) {
            this.retryAfter = Integer.parseInt((String)headers.get(0));
        }
        JSONObject data = new JSONObject(message.getBodyAsString());
        this.operationId = data.getString(OPERATION_ID);
        this.status = data.getString(STATUS);
        log.finest(() -> String.format("Azure DPS register cert response status = %d, operation id = %s, status message = %s", this.statusCode, this.operationId, this.status));
    }

    public boolean isSuccessful() {
        return this.statusCode == 202 && this.operationId != null;
    }

    public String getOperationId() {
        return this.operationId;
    }

    public String getStatus() {
        return this.status;
    }

    public int getRetryAfter() {
        return this.retryAfter;
    }
}

