/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.forge.auth;

import com.tridium.cloudLink.transport.HttpResponseMessage;
import com.tridium.json.JSONObject;
import java.util.List;
import java.util.logging.Logger;

public class AzureDpsCheckRegistrationResponse {
    protected static final Logger log = Logger.getLogger("cloudLink.auth.forge");
    private final int statusCode;
    private String assignedHub;
    private String status;
    private static final String BOOTSTRAP_ERROR_MSG_TEMPLATE = "Forge bootstrap device authentication response body is not in %s format, response body is %s";
    private static final String REGISTRATION_STATE = "registrationState";
    private static final String ASSIGNED_HUB = "assignedHub";
    private static final String STATUS = "status";
    private static final String SUCCESS = "assigned";

    public AzureDpsCheckRegistrationResponse(HttpResponseMessage message) {
        this.statusCode = message.getStatusCode();
        List headers = (List)message.getHeaders().get("content-type");
        if (headers == null || headers.isEmpty() || !((String)headers.get(0)).startsWith("application/json")) {
            log.config(() -> String.format(BOOTSTRAP_ERROR_MSG_TEMPLATE, "application/json", message.getBodyAsString()));
            return;
        }
        JSONObject data = new JSONObject(message.getBodyAsString());
        this.status = data.getString(STATUS);
        if (this.status.equals(SUCCESS)) {
            JSONObject state = data.getJSONObject(REGISTRATION_STATE);
            this.assignedHub = state.getString(ASSIGNED_HUB);
            log.finest(() -> String.format("Azure DPS registration status response response status = %d, status message = %s, assigned hub = %s", this.statusCode, this.status, this.assignedHub));
        }
    }

    public boolean isSuccessful() {
        return this.statusCode == 200 && this.assignedHub != null && !this.assignedHub.isEmpty();
    }

    public String getAssignedHub() {
        return this.assignedHub;
    }
}

