/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.clUtils.util;

import com.tridium.clUtils.CloudIdException;
import com.tridium.clUtils.util.CloudIdConstants;
import java.io.IOException;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.data.BIDataValue;
import javax.baja.naming.BOrd;
import javax.baja.naming.SlotPath;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.tag.BIEntity;
import javax.baja.tag.Id;
import javax.baja.tag.Tag;
import javax.baja.tag.Tags;
import javax.baja.tag.util.SmartTagSet;

public final class TagUtil {
    static final Logger log = Logger.getLogger("cloudLink.tag");

    public static Optional<BIDataValue> getTag(BIEntity entity, Id tagId) {
        if (entity == null) {
            return Optional.empty();
        }
        Tags tags = entity.tags();
        if (tags == null || !tags.contains(tagId)) {
            return Optional.empty();
        }
        return tags.get(tagId);
    }

    public static Optional<BIDataValue> getCloudId(BIEntity entity) {
        return TagUtil.getTag(entity, CloudIdConstants.CLOUD_ID);
    }

    public static Optional<BIDataValue> getCloudId(BComponent component) {
        BValue value = component.get(CloudIdConstants.ESCAPED_CLOUD_ID_TAG);
        if (value instanceof BIDataValue) {
            return Optional.of((BIDataValue)value);
        }
        return Optional.empty();
    }

    public static boolean hasTag(BIEntity entity, Id tagId) {
        return TagUtil.getTag(entity, tagId).isPresent();
    }

    public static boolean hasCloudId(BIEntity entity) {
        return TagUtil.getCloudId(entity).isPresent();
    }

    public static boolean addTag(BIEntity entity, Id tagId, BIDataValue tagValue, int slotFlags) {
        if (entity == null) {
            log.finest("addTag called with null entity");
            return false;
        }
        try {
            if (!TagUtil.hasTag(entity, tagId)) {
                if (entity instanceof BComponent) {
                    BComponent component = (BComponent)entity;
                    component.add(SlotPath.escape((String)tagId.getQName()), (BValue)tagValue.as(BValue.class), slotFlags | 0x4000);
                } else {
                    Tags tags = entity.tags();
                    Tag tag = new Tag(tagId, tagValue);
                    tags.set(tag);
                }
                log.finest(() -> String.format("addTag, added tag with id %s for %s on %s", tagId.getQName(), entity.getOrdToEntity().orElse(BOrd.DEFAULT).encodeToString(), Thread.currentThread().getName()));
                return true;
            }
            log.finest(() -> String.format("addTag hasTag found exiting tag with id %s for %s on %s", tagId.getQName(), entity.getOrdToEntity().orElse(BOrd.DEFAULT).encodeToString(), Thread.currentThread().getName()));
        }
        catch (Exception ex) {
            log.log(Level.INFO, String.format("Error adding tag %s to entity %s: %s", tagId.toString(), entity, ex.getMessage()), log.isLoggable(Level.FINE) ? ex : null);
            return false;
        }
        return false;
    }

    public static boolean addTag(BIEntity entity, Id tagId, BIDataValue tagValue) {
        return TagUtil.addTag(entity, tagId, tagValue, 0);
    }

    public static Optional<String> getCloudIdString(BIObject object) {
        if (object instanceof BIEntity) {
            return TagUtil.getCloudId((BIEntity)object).map(id -> {
                try {
                    return id.encodeToString();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            });
        }
        return Optional.empty();
    }

    public static String getOrAddCloudId(BIEntity entity, Function<BIEntity, String> cloudIdFunction) {
        Objects.requireNonNull(entity);
        return TagUtil.getCloudId(entity).map(id -> {
            try {
                return id.encodeToString();
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }).orElseGet(() -> {
            log.finest(() -> String.format("getOrAddCloudId no existing cloud id found, adding one for %s on %s", entity.getOrdToEntity().orElse(BOrd.DEFAULT).encodeToString(), Thread.currentThread().getName()));
            String id = (String)cloudIdFunction.apply(entity);
            TagUtil.addCloudId(entity, id);
            return id;
        });
    }

    public static void addCloudId(BIEntity entity, String cloudIdValue) {
        if (!TagUtil.addTag(entity, CloudIdConstants.CLOUD_ID, (BIDataValue)BString.make((String)cloudIdValue), 24577)) {
            log.finest(() -> String.format("addCloudId, addTag returns false for %s on %s", entity.getOrdToEntity().orElse(BOrd.DEFAULT).encodeToString(), Thread.currentThread().getName()));
            throw TagUtil.makeCloudIdExceptionSupplier(entity).get();
        }
        log.finest(() -> String.format("addCloudId, addTag returns true for %s on %s", entity.getOrdToEntity().orElse(BOrd.DEFAULT).encodeToString(), Thread.currentThread().getName()));
    }

    public static Supplier<CloudIdException> makeCloudIdExceptionSupplier(BIEntity entity) {
        return () -> {
            Optional ordOpt = entity.getOrdToEntity();
            String msg = "nc:cloudId tag was not found";
            if (ordOpt.isPresent()) {
                msg = msg + " on entity: " + ((BOrd)ordOpt.get()).encodeToString();
            }
            return new CloudIdException(msg);
        };
    }

    public static boolean deleteTag(BIEntity entity, Id tagId) {
        if (entity == null) {
            log.finest("deleteTag called with null entity");
            return false;
        }
        String entityOrdPath = entity.getOrdToEntity().orElse(BOrd.DEFAULT).encodeToString();
        Tags tags = entity.tags();
        if (!tags.contains(tagId)) {
            log.finest(() -> String.format("deleteTag - tag %s not found for %s on %s", tagId.toString(), entityOrdPath, Thread.currentThread().getName()));
            return true;
        }
        if (tags instanceof SmartTagSet && ((SmartTagSet)tags).getImpliedTags().contains(tagId)) {
            log.finest(() -> String.format("deleteTag - implied tag %s cannot be deleted from %s on %s", tagId.toString(), entityOrdPath, Thread.currentThread().getName()));
            return false;
        }
        try {
            return tags.removeAll(tagId);
        }
        catch (IllegalArgumentException | UnsupportedOperationException ex) {
            log.log(Level.INFO, String.format("Error deleting tag %s from entity %s: %s", tagId.toString(), entityOrdPath, ex.getMessage()), log.isLoggable(Level.FINE) ? ex : null);
            return false;
        }
    }

    private TagUtil() {
    }
}

