/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.clUtils.device;

import com.tridium.clUtils.device.IDeviceInfoHelper;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.agent.BIAgent;
import javax.baja.driver.BDevice;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.registry.TypeInfo;
import javax.baja.sys.BObject;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType(agent={@AgentOn(types={"driver:Device"})})
public abstract class BDeviceInfoHelper
extends BObject
implements IDeviceInfoHelper,
BIAgent {
    public static final Type TYPE = Sys.loadType(BDeviceInfoHelper.class);
    private static Map<String, IDeviceInfoHelper> helperMap;
    protected static final Logger log;

    public Type getType() {
        return TYPE;
    }

    public static Map<String, Object> getData(BDevice device) {
        if (helperMap == null) {
            BDeviceInfoHelper.registerHelpers();
        }
        if (!helperMap.containsKey(device.getClass().getName())) {
            return BDeviceInfoHelper.getDefaultDeviceData(device);
        }
        return helperMap.get(device.getClass().getName()).getDeviceData(device);
    }

    protected static void registerHelper(String className, IDeviceInfoHelper device) {
        helperMap.put(className, device);
    }

    private static void registerHelpers() {
        try {
            TypeInfo[] helperInfos = Sys.getRegistry().getConcreteTypes(TYPE.getTypeInfo());
            helperMap = new HashMap<String, IDeviceInfoHelper>();
            for (TypeInfo helperInfo : helperInfos) {
                BDeviceInfoHelper helper = (BDeviceInfoHelper)helperInfo.getInstance().as(BDeviceInfoHelper.class);
                helper.registerSelf();
            }
        }
        catch (Exception e) {
            log.log(Level.INFO, "Cannot add a device info helper implementation", log.isLoggable(Level.FINE) ? e : null);
        }
    }

    private static Map<String, Object> getDefaultDeviceData(BDevice device) {
        HashMap<String, Object> valueMap = new HashMap<String, Object>();
        valueMap.put("name", device.getName());
        valueMap.put("version", 1);
        return valueMap;
    }

    @Override
    public Map<String, Object> getDeviceData(BDevice device) {
        return BDeviceInfoHelper.getDefaultDeviceData(device);
    }

    protected abstract void registerSelf();

    static {
        log = Logger.getLogger("cloudLink.deviceInfoHelper");
    }
}

