/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.clUtilsBacnet.util;

import com.tridium.clUtils.util.BProxyPointHelper;
import java.io.IOException;
import java.util.Optional;
import java.util.logging.Level;
import javax.baja.bacnet.datatypes.BBacnetDeviceObjectPropertyReference;
import javax.baja.bacnet.point.BBacnetProxyExt;
import javax.baja.driver.point.BProxyExt;
import javax.baja.nre.annotations.NiagaraSingleton;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.registry.TypeInfo;
import javax.baja.sys.NotRunningException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraSingleton
public class BBacnetProxyPointHelper
extends BProxyPointHelper {
    public static final BBacnetProxyPointHelper INSTANCE = new BBacnetProxyPointHelper();
    public static final Type TYPE = Sys.loadType(BBacnetProxyPointHelper.class);

    public Type getType() {
        return TYPE;
    }

    public Optional<String> getReferenceInfo(BProxyExt proxyExt) {
        if (!(proxyExt instanceof BBacnetProxyExt)) {
            return Optional.empty();
        }
        try {
            BBacnetProxyExt bacnetProxyExt = (BBacnetProxyExt)proxyExt;
            if (bacnetProxyExt.getPropertyId() == null || bacnetProxyExt.device() == null) {
                return Optional.empty();
            }
            BBacnetDeviceObjectPropertyReference reference = new BBacnetDeviceObjectPropertyReference(bacnetProxyExt.getObjectId(), bacnetProxyExt.getPropertyId().getOrdinal(), bacnetProxyExt.getPropertyArrayIndex(), bacnetProxyExt.device().getObjectId());
            return Optional.of(reference.encodeToString());
        }
        catch (IOException | IllegalStateException | NotRunningException ex) {
            log.log(Level.INFO, "unable to obtain bacnet device object property reference", log.isLoggable(Level.FINE) ? ex : null);
            return Optional.empty();
        }
    }

    protected void registerSelf() {
        TypeInfo[] proxyExtInfos;
        for (TypeInfo proxyExtInfo : proxyExtInfos = Sys.getRegistry().getConcreteTypes(BBacnetProxyExt.TYPE.getTypeInfo())) {
            BProxyPointHelper.registerHelper((String)proxyExtInfo.getTypeClassName(), this::getReferenceInfo);
        }
    }
}

