/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.clUtilsBacnet;

import com.tridium.bacnet.job.BBacnetDiscoverPointsJob;
import com.tridium.bacnet.job.BDiscoveryPoint;
import com.tridium.bacnet.job.BDiscoveryPointTable;
import com.tridium.clUtils.BModelDiscoverer;
import com.tridium.clUtils.DiscoveryUtils;
import com.tridium.util.EscUtil;
import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipOutputStream;
import javax.baja.bacnet.BBacnetDevice;
import javax.baja.driver.BDevice;
import javax.baja.driver.BDeviceNetwork;
import javax.baja.job.BJob;
import javax.baja.job.JobLog;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.tag.Entity;
import javax.baja.util.Lexicon;

@NiagaraType(agent={@AgentOn(types={"bacnet:BacnetDevice", "bacnet:BacnetNetwork"})})
public class BBacnetModelDiscoverer
extends BModelDiscoverer {
    public static final Type TYPE = Sys.loadType(BBacnetModelDiscoverer.class);
    protected static final Lexicon lex = Lexicon.make((String)"clUtilsBacnet");
    private static final String lexWriteErrorKey = "modelDiscovererBacnet.device.writePoint.error";
    private static final String lexDeviceStartKey = "modelDiscovererBacnet.device.start";
    private static final Set<Integer> discoveryProperties = new HashSet<Integer>();
    private static final Set<Integer> deviceDiscoveryProps;

    public Type getType() {
        return TYPE;
    }

    public BBacnetModelDiscoverer() {
        this.historyToCloudIdMap = new HashMap();
    }

    public boolean discoverModelInfo(ZipOutputStream out, BDeviceNetwork network, BJob job) throws Exception {
        job.log().message(lex.getText("modelDiscovererBacnet.network.discoverModelInfo.notSupported"));
        return false;
    }

    public boolean discoverModelInfo(ZipOutputStream out, BDevice d, BJob job) throws Exception {
        JobLog log = job.log();
        BBacnetDevice device = (BBacnetDevice)d;
        log.message(lex.getText(lexDeviceStartKey, new Object[]{BBacnetModelDiscoverer.getDeviceName((BDevice)device)}));
        String basePath = DiscoveryUtils.getDevicePathFromNetwork((BDevice)device);
        this.pointsMap = this.discoverPoints((BDevice)device, log);
        this.writePointInfo(this.pointsMap, this.facetsMap, basePath, out, log, lex, lexWriteErrorKey);
        this.releaseMaps();
        return true;
    }

    protected Map<String, Entity> discoverPoints(BDevice remoteDevice, JobLog log) {
        HashMap<String, Entity> entityMap = new HashMap<String, Entity>();
        BBacnetDevice device = (BBacnetDevice)remoteDevice;
        BOrd jobOrd = device.getPoints().doSubmitPointDiscoveryJob(null);
        if (jobOrd == null) {
            return Collections.emptyMap();
        }
        BBacnetDiscoverPointsJob job = (BBacnetDiscoverPointsJob)jobOrd.get((BObject)Sys.getStation());
        DiscoveryUtils.waitForJob((BJob)job, (JobLog)log, (String)(BBacnetModelDiscoverer.getDeviceName((BDevice)device) + ".points"));
        BDiscoveryPoint[] discPts = (BDiscoveryPoint[])job.getChildren(BDiscoveryPoint.class);
        log.message(lex.getText("modelDiscovererBacnet.device.foundPoints", new Object[]{discPts.length, BBacnetModelDiscoverer.getDeviceName((BDevice)device)}));
        for (BDiscoveryPoint e : discPts) {
            BDiscoveryPoint[] props;
            String key = File.separator + EscUtil.slot.escape(e.getObjectName());
            BDiscoveryPointTable discPtProps = job.doDiscover(e);
            for (BDiscoveryPoint propPt : props = (BDiscoveryPoint[])discPtProps.getChildren(BDiscoveryPoint.class)) {
                BFacets newFacet = BFacets.make((String)propPt.getPropertyIdentifier(), (String)propPt.getValue().toString());
                e.setFacets(BFacets.make((BFacets)e.getFacets(), (BFacets)newFacet));
            }
            this.facetsMap.put(key, e.getFacets());
            entityMap.put(key, (Entity)e);
        }
        return entityMap;
    }

    protected static String getDeviceName(BDevice device) {
        return device.isMounted() ? device.getName() : "BacnetDevice";
    }

    public String getPointCreationName(String slotpath, Entity e) {
        return slotpath.substring(slotpath.lastIndexOf(47) + 1);
    }

    static {
        Collections.addAll(discoveryProperties, 117, 4, 46, 110, 69, 65, 106, 31);
        deviceDiscoveryProps = new HashSet<Integer>();
        Collections.addAll(deviceDiscoveryProps, 58, 28, 77, 44, 12, 70);
    }
}

