/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.transport.internal;

import com.tridium.cloudLink.transport.AmqpMessage;
import com.tridium.cloudLink.transport.internal.IAmqpSessionHandler;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import org.apache.qpid.proton.Proton;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.amqp.messaging.Accepted;
import org.apache.qpid.proton.amqp.messaging.Source;
import org.apache.qpid.proton.amqp.transport.DeliveryState;
import org.apache.qpid.proton.amqp.transport.ReceiverSettleMode;
import org.apache.qpid.proton.engine.BaseHandler;
import org.apache.qpid.proton.engine.Delivery;
import org.apache.qpid.proton.engine.EndpointState;
import org.apache.qpid.proton.engine.Event;
import org.apache.qpid.proton.engine.Handler;
import org.apache.qpid.proton.engine.Link;
import org.apache.qpid.proton.engine.Receiver;
import org.apache.qpid.proton.message.Message;
import org.apache.qpid.proton.reactor.FlowController;

public abstract class AmqpReceiverLinkHandler
extends BaseHandler {
    protected String id;
    protected Receiver receiver;
    protected String linkAddress;
    protected Map<Symbol, Object> amqpProperties = new HashMap<Symbol, Object>();
    protected IAmqpSessionHandler parentSessionHandler;
    protected final Set<AmqpMessage> receivedMessages;
    protected static final Logger log = Logger.getLogger("cloudLink.transport.amqp.client");

    protected AmqpReceiverLinkHandler(Receiver receiver, String linkId, IAmqpSessionHandler parent) {
        this.amqpProperties.put(Symbol.getSymbol("com.microsoft:api-version"), "2020-05-31-preview");
        this.id = linkId;
        this.receiver = receiver;
        this.parentSessionHandler = parent;
        this.receivedMessages = ConcurrentHashMap.newKeySet();
        BaseHandler.setHandler(receiver, (Handler)this);
        this.add(new FlowController());
    }

    void close() {
        if (this.receiver.getLocalState() != EndpointState.CLOSED) {
            this.receiver.close();
        }
    }

    @Override
    public void onLinkInit(Event event) {
        log.finest(event.toString());
        Link link = event.getLink();
        Source source = new Source();
        source.setAddress(this.linkAddress);
        link.setSource(source);
        link.setReceiverSettleMode(ReceiverSettleMode.FIRST);
        link.setProperties(this.amqpProperties);
        link.open();
    }

    @Override
    public void onLinkRemoteOpen(Event event) {
        log.finest(event.toString());
        this.parentSessionHandler.linkOpened(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onDelivery(Event event) {
        log.finest(event.toString());
        Receiver receiverLink = (Receiver)event.getLink();
        AmqpMessage amqpMessage = this.getMessageFromReceiverLink(receiverLink);
        if (amqpMessage != null) {
            this.receivedMessages.add(amqpMessage);
            try {
                if (this.parentSessionHandler.getClient().getCallbackHandler() != null) {
                    this.parentSessionHandler.getClient().getCallbackHandler().onMessageReceived(amqpMessage, null);
                } else {
                    log.info("delivery received when client callback handler is null");
                }
            }
            finally {
                this.acknowledgeReceivedMessage(amqpMessage, Accepted.getInstance());
            }
        }
    }

    @Override
    public void onLinkRemoteClose(Event event) {
        log.finest(event.toString());
        Link link = event.getLink();
        if (link.getLocalState() == EndpointState.ACTIVE) {
            log.config("unexpected remote close of link with id " + this.id);
            this.parentSessionHandler.linkLost(link.getRemoteCondition(), this);
            link.close();
        } else {
            this.parentSessionHandler.close();
        }
    }

    @Override
    public void onLinkLocalClose(Event event) {
        log.finest(event.toString());
        Link link = event.getLink();
        if (link.getRemoteState() == EndpointState.CLOSED) {
            this.parentSessionHandler.close();
        }
    }

    public boolean acknowledgeReceivedMessage(AmqpMessage message, DeliveryState ackType) {
        if (this.receivedMessages.contains(message)) {
            this.receivedMessages.remove(message);
            message.getDelivery().disposition(ackType);
            message.getDelivery().settle();
            return true;
        }
        return false;
    }

    AmqpMessage getMessageFromReceiverLink(Receiver receiver) {
        Delivery delivery = receiver.current();
        if (delivery != null && delivery.isReadable() && !delivery.isPartial()) {
            int size = delivery.pending();
            byte[] buffer = new byte[size];
            int bytesRead = receiver.recv(buffer, 0, buffer.length);
            log.finer(() -> String.format("read %d bytes from receiver link %s", bytesRead, receiver.getName()));
            boolean receiverLinkAdvanced = receiver.advance();
            if (!receiverLinkAdvanced) {
                log.config(() -> String.format("%s receiver link with link correlation id %s did not advance after bytes were read from it", this.getClass().getName(), this.id));
            }
            if (size != bytesRead) {
                log.config(() -> String.format("Amqp read from %s receiver link with link correlation id %s did not read the expected amount of bytes. Read %d but expected %d", this.getClass().getName(), this.id, bytesRead, size));
            }
            Message message = Proton.message();
            message.decode(buffer, 0, buffer.length);
            AmqpMessage amqpMessage = new AmqpMessage(message, delivery);
            return amqpMessage;
        }
        return null;
    }
}

