/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.transport;

import com.tridium.cloudLink.BCloudConnectionService;
import com.tridium.cloudLink.CloudLinkUtils;
import com.tridium.cloudLink.transport.BAbstractTransport;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BFolder;
import javax.baja.util.BIRestrictedComponent;
import javax.baja.util.Lexicon;

@NiagaraType
public final class BTransportsFolder
extends BFolder
implements BIRestrictedComponent {
    public static final Type TYPE = Sys.loadType(BTransportsFolder.class);
    private static final Lexicon lex = Lexicon.make((String)"cloudLink");

    public Type getType() {
        return TYPE;
    }

    public boolean isChildLegal(BComponent child) {
        return child.getType().is(BAbstractTransport.TYPE);
    }

    public BIcon getIcon() {
        return BIcon.make((String)lex.getText("TransportsFolder.icon"));
    }

    public BAbstractTransport getTransport(String transportType) {
        BAbstractTransport[] transports;
        if (transportType == null) {
            return null;
        }
        for (BAbstractTransport transport : transports = (BAbstractTransport[])this.getChildren(BAbstractTransport.class)) {
            if (!transportType.equals(transport.getTransportType())) continue;
            return transport;
        }
        return null;
    }

    public List<BAbstractTransport> getTransports() {
        BAbstractTransport[] transports = (BAbstractTransport[])this.getChildren(BAbstractTransport.class);
        return new ArrayList<BAbstractTransport>(Arrays.asList(transports));
    }

    public BCloudConnectionService getConnectionService() {
        return (BCloudConnectionService)this.getParent();
    }

    public void checkParentForRestrictedComponent(BComponent parent, Context cx) {
        CloudLinkUtils.checkParentForDuplicates(parent, (BComponent)this, BCloudConnectionService.TYPE, true, cx);
    }
}

