/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.transport;

import com.tridium.cloudLink.BCloudConnectionService;
import com.tridium.cloudLink.queue.BAbstractMessageQueue;
import com.tridium.cloudLink.transport.BAbstractConnectedTransport;
import com.tridium.cloudLink.transport.BTransportsFolder;
import com.tridium.cloudLink.transport.IMessage;
import com.tridium.cloudLink.transport.IMessageResponse;
import com.tridium.cloudLink.transport.MessageWrapper;
import com.tridium.cloudLink.util.BCompressionMode;
import com.tridium.cloudLink.util.IResettableCompressionStream;
import com.tridium.cloudLink.util.IResettableDecompressionStream;
import com.tridium.cloudLink.util.ResettableGZIPInputStream;
import com.tridium.cloudLink.util.ResettableGZIPOutputStream;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.data.BIDataValue;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.spy.SpyWriter;
import javax.baja.status.BStatus;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BAbstractService;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.ExecutorUtil;
import javax.baja.util.Lexicon;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="pendingMessageLimit", type="int", defaultValue="DEFAULT_PENDING_MESSAGES", flags=4, facets={@Facet(name="BFacets.MIN", value="1")}), @NiagaraProperty(name="messageRetries", type="int", defaultValue="DEFAULT_MESSAGE_RETRIES", facets={@Facet(name="BFacets.MIN", value="0"), @Facet(name="BFacets.MAX", value="MAX_MESSAGE_RETRIES")}), @NiagaraProperty(name="compression", type="BCompressionMode", defaultValue="BCompressionMode.none"), @NiagaraProperty(name="messageThrottlingLimit", type="int", defaultValue="0", facets={@Facet(name="BFacets.MIN", value="0"), @Facet(name="BFacets.MAX", value="Integer.MAX_VALUE")}), @NiagaraProperty(name="defaultMessageTimeout", type="BRelTime", defaultValue="BRelTime.make(DEFAULT_MESSAGE_TIMEOUT)", facets={@Facet(name="BFacets.MIN", value="BRelTime.make(MIN_MESSAGE_TIMEOUT)"), @Facet(name="BFacets.MAX", value="BRelTime.make(MAX_MESSAGE_TIMEOUT)")})})
@NiagaraAction(name="resetMetrics", flags=128)
public abstract class BAbstractTransport
extends BAbstractService {
    public static final Property pendingMessageLimit = BAbstractTransport.newProperty((int)4, (int)50, (BFacets)BFacets.make((String)"min", (int)1));
    public static final Property messageRetries = BAbstractTransport.newProperty((int)0, (int)2, (BFacets)BFacets.make((BFacets)BFacets.make((String)"min", (int)0), (BFacets)BFacets.make((String)"max", (int)10)));
    public static final Property compression = BAbstractTransport.newProperty((int)0, (BValue)BCompressionMode.none, null);
    public static final Property messageThrottlingLimit = BAbstractTransport.newProperty((int)0, (int)0, (BFacets)BFacets.make((BFacets)BFacets.make((String)"min", (int)0), (BFacets)BFacets.make((String)"max", (int)Integer.MAX_VALUE)));
    public static final Property defaultMessageTimeout = BAbstractTransport.newProperty((int)0, (BValue)BRelTime.make((long)60000L), (BFacets)BFacets.make((BFacets)BFacets.make((String)"min", (BIDataValue)BRelTime.make((long)1000L)), (BFacets)BFacets.make((String)"max", (BIDataValue)BRelTime.make((long)300000L))));
    public static final Action resetMetrics = BAbstractTransport.newAction((int)128, null);
    public static final Type TYPE = Sys.loadType(BAbstractTransport.class);
    protected boolean fatalFault;
    protected boolean configFault;
    private final ArrayList<BAbstractMessageQueue> queues = new ArrayList();
    private int maxWeight;
    private int currentWeight = -1;
    private int pendingMessages;
    private int lastQueueIndex = -1;
    private int oldStatus;
    private int messageWindowCount;
    private long messageWindowEnd;
    private boolean activeMessages;
    private boolean activeManager;
    private long messageCompressionFailureCount;
    private long lastMessageCompressionFailureTime;
    private long messageDecompressionFailureCount;
    private long lastMessageDecompressionFailureTime;
    private long messageWindowFullCount;
    private long messageWindowFullTime;
    private long lastResetTime;
    private long messagesSentOkCount;
    private long lastMessageSentOkTime;
    private long messagesSendFailureCount;
    private long lastMessageSendFailureTime;
    private long bytesSentCount;
    private final Object metricLock = new Object();
    private IResettableCompressionStream compressor;
    protected final Map<String, Class<?>> decompressorTypeMap = new HashMap();
    private final Map<String, IResettableDecompressionStream> decompressorMap = new HashMap<String, IResettableDecompressionStream>();
    private ExecutorService manager;
    protected ExecutorService threadPool;
    private static final ReadWriteLock messageControlLock = new ReentrantReadWriteLock();
    private static final int MIN_THREADPOOL_THREADS = 4;
    protected static final Logger log = Logger.getLogger("cloudLink.transport");
    protected static final Lexicon lex = Lexicon.make((String)"cloudLink");

    public int getPendingMessageLimit() {
        return this.getInt(pendingMessageLimit);
    }

    public void setPendingMessageLimit(int v) {
        this.setInt(pendingMessageLimit, v, null);
    }

    public int getMessageRetries() {
        return this.getInt(messageRetries);
    }

    public void setMessageRetries(int v) {
        this.setInt(messageRetries, v, null);
    }

    public BCompressionMode getCompression() {
        return (BCompressionMode)this.get(compression);
    }

    public void setCompression(BCompressionMode v) {
        this.set(compression, (BValue)v, null);
    }

    public int getMessageThrottlingLimit() {
        return this.getInt(messageThrottlingLimit);
    }

    public void setMessageThrottlingLimit(int v) {
        this.setInt(messageThrottlingLimit, v, null);
    }

    public BRelTime getDefaultMessageTimeout() {
        return (BRelTime)this.get(defaultMessageTimeout);
    }

    public void setDefaultMessageTimeout(BRelTime v) {
        this.set(defaultMessageTimeout, (BValue)v, null);
    }

    public void resetMetrics() {
        this.invoke(resetMetrics, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public final Object fw(int x, Object a, Object b, Object c, Object d) {
        switch (x) {
            case 11: {
                this.fwStarted();
                break;
            }
            case 2: {
                this.fwChanged((Property)a);
                break;
            }
            case 12: {
                this.fwStopped();
            }
        }
        return super.fw(x, a, b, c, d);
    }

    public BIcon getIcon() {
        return BIcon.make((String)lex.getText("AbstractTransport.icon"));
    }

    protected void fwStarted() {
        this.setupCompression();
        this.resetCounters();
    }

    protected void fwChanged(Property prop) {
        if (!this.isRunning()) {
            return;
        }
        if (prop.equals(compression)) {
            this.setupCompression();
        }
    }

    protected void fwStopped() {
    }

    private void setupCompression() {
        try {
            switch (this.getCompression().getOrdinal()) {
                case 1: {
                    this.compressor = new ResettableGZIPOutputStream();
                    break;
                }
                case 0: {
                    this.compressor = null;
                    break;
                }
                default: {
                    log.info("unknown compression type " + this.getCompression().encodeToString());
                    break;
                }
            }
        }
        catch (IOException ex) {
            log.log(Level.INFO, "unable to initialize compression for transport " + this.getType().getTypeName(), log.isLoggable(Level.FINE) ? ex : null);
        }
        if (this.decompressorTypeMap.isEmpty()) {
            this.decompressorTypeMap.put(ResettableGZIPInputStream.getContentTypeExtension(), ResettableGZIPInputStream.class);
        }
    }

    public void doResetMetrics() {
        this.resetCounters();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetCounters() {
        Object object = this.metricLock;
        synchronized (object) {
            this.lastResetTime = System.currentTimeMillis();
            this.messageCompressionFailureCount = 0L;
            this.lastMessageCompressionFailureTime = 0L;
            this.messageDecompressionFailureCount = 0L;
            this.lastMessageDecompressionFailureTime = 0L;
            this.messageWindowFullCount = 0L;
            this.messageWindowFullTime = 0L;
            this.messagesSentOkCount = 0L;
            this.lastMessageSentOkTime = 0L;
            this.messagesSendFailureCount = 0L;
            this.lastMessageSendFailureTime = 0L;
            this.bytesSentCount = 0L;
        }
    }

    public abstract String getTransportType();

    public void started() throws Exception {
        super.started();
        this.manager = ExecutorUtil.newSingleThreadBackgroundExecutor((String)"cloudLink.messageDeliveryManager", (long)1L, (TimeUnit)TimeUnit.MINUTES);
        this.threadPool = Executors.newFixedThreadPool(Math.max(Runtime.getRuntime().availableProcessors(), 4));
        ((ThreadPoolExecutor)this.threadPool).setKeepAliveTime(500L, TimeUnit.MILLISECONDS);
        ((ThreadPoolExecutor)this.threadPool).allowCoreThreadTimeOut(true);
    }

    public void stopped() throws Exception {
        super.stopped();
        this.manager.shutdown();
        this.threadPool.shutdown();
    }

    public boolean isParentLegal(BComponent parent) {
        return parent instanceof BTransportsFolder;
    }

    public abstract void send(MessageWrapper<? extends IMessage> var1) throws IOException;

    public abstract boolean canSend();

    public void registerQueue(BAbstractMessageQueue queue) {
        if (this.queues.contains((Object)queue)) {
            log.fine(() -> String.format("Attempt to register queue [%s] that has already been registered; ignoring since the queue is already in the list...", new Object[]{queue}));
            return;
        }
        this.queues.add(queue);
        log.fine(() -> String.format("%s: Registered queue [%s] with weight %s", new Object[]{this.getName(), queue, queue.getWeight()}));
        if (queue.getWeight() > this.maxWeight) {
            this.maxWeight = queue.getWeight();
        }
    }

    public void deregisterQueue(BAbstractMessageQueue queue) {
        if (this.queues.remove((Object)queue) && queue.getWeight() == this.maxWeight) {
            this.maxWeight = 0;
            for (BAbstractMessageQueue msgQueue : this.queues) {
                if (msgQueue.getWeight() <= this.maxWeight) continue;
                this.maxWeight = msgQueue.getWeight();
            }
            log.fine(() -> String.format("%s: Deregistered queue [%s] with weight %s", new Object[]{this.getName(), queue, queue.getWeight()}));
        }
    }

    public boolean isQueueRegistered(BAbstractMessageQueue queue) {
        return this.queues.contains((Object)queue);
    }

    public void notifyPending() {
        messageControlLock.writeLock().lock();
        if (!this.activeMessages) {
            this.activeMessages = true;
            messageControlLock.writeLock().unlock();
            this.manager.execute(this::sendMessages);
        } else {
            messageControlLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public synchronized byte[] compressData(byte[] payload, String messageId) {
        if (this.compressor == null) {
            return payload;
        }
        this.compressor.write(payload);
        this.compressor.finish();
        byte[] byArray = this.compressor.toCompressedByteArray();
        try {
            this.compressor.reset();
        }
        catch (IOException ex) {
            log.log(Level.WARNING, String.format("%s: Error resetting compressor after message %s", new Object[]{this, messageId}), log.isLoggable(Level.FINE) ? ex : null);
        }
        return byArray;
        catch (IOException ex) {
            try {
                Object object = this.metricLock;
                synchronized (object) {
                    ++this.messageCompressionFailureCount;
                    this.lastMessageCompressionFailureTime = System.currentTimeMillis();
                }
                log.log(Level.WARNING, String.format("%s: Error compressing message %s", this.getName(), messageId), log.isLoggable(Level.FINE) ? ex : null);
            }
            catch (Throwable throwable) {
                try {
                    this.compressor.reset();
                }
                catch (IOException ex2) {
                    log.log(Level.WARNING, String.format("%s: Error resetting compressor after message %s", new Object[]{this, messageId}), log.isLoggable(Level.FINE) ? ex2 : null);
                }
                throw throwable;
            }
            try {
                this.compressor.reset();
            }
            catch (IOException ex3) {
                log.log(Level.WARNING, String.format("%s: Error resetting compressor after message %s", new Object[]{this, messageId}), log.isLoggable(Level.FINE) ? ex3 : null);
            }
        }
        return payload;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized byte[] uncompressData(String type, byte[] payload, String messageId) {
        try {
            int result;
            IResettableDecompressionStream decompressor;
            if (this.decompressorMap.get(type) == null) {
                decompressor = new ResettableGZIPInputStream(payload);
                this.decompressorMap.put(type, decompressor);
            } else {
                decompressor = this.decompressorMap.get(type);
                decompressor.reset(payload);
            }
            byte[] buff = new byte[payload.length * 4];
            int len = 0;
            while ((result = decompressor.read(buff, len, buff.length - len)) != -1) {
                if ((len += result) != buff.length) continue;
                buff = Arrays.copyOf(buff, buff.length * 2);
            }
            return Arrays.copyOf(buff, len);
        }
        catch (IOException ex) {
            Object object = this.metricLock;
            synchronized (object) {
                ++this.messageDecompressionFailureCount;
                this.lastMessageDecompressionFailureTime = System.currentTimeMillis();
            }
            log.log(Level.WARNING, String.format("%s: Error decompressing message %s", new Object[]{this, messageId}), log.isLoggable(Level.FINE) ? ex : null);
            return payload;
        }
    }

    public String getCompressionExtension() {
        return this.compressor == null ? "" : this.compressor.getContentTypeExtension();
    }

    public final void updateStatus() {
        int newStatus = this.getStatus().getBits();
        Optional<BCloudConnectionService> cloudConnectionService = this.getConnectionService();
        BStatus parentStatus = cloudConnectionService.map(ccs -> ccs.getStatus()).orElse(BStatus.ok);
        newStatus = !this.getEnabled() || parentStatus.isDisabled() ? (newStatus |= 1) : (newStatus &= 0xFFFFFFFE);
        if (this instanceof BAbstractConnectedTransport && !((BAbstractConnectedTransport)this).isConnected() || parentStatus.isDown()) {
            newStatus |= 4;
        } else {
            newStatus &= 0xFFFFFFFB;
            messageControlLock.readLock().lock();
            if (this.activeMessages && !this.activeManager) {
                messageControlLock.readLock().unlock();
                this.manager.execute(this::sendMessages);
            } else {
                messageControlLock.readLock().unlock();
            }
        }
        newStatus = this.fatalFault || this.configFault || parentStatus.isFault() ? (newStatus |= 2) : (newStatus &= 0xFFFFFFFD);
        if (this.oldStatus == newStatus) {
            return;
        }
        this.setStatus(BStatus.make((int)newStatus));
        this.oldStatus = newStatus;
    }

    protected Optional<BCloudConnectionService> getConnectionService() {
        for (BComplex parent = this.getParent(); parent != null; parent = parent.getParent()) {
            if (!(parent instanceof BCloudConnectionService)) continue;
            return Optional.of((BCloudConnectionService)parent);
        }
        return Optional.empty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendMessages() {
        log.finer(() -> String.format("%s: Entering sendMessages", new Object[]{this}));
        if (this.queues.isEmpty()) {
            log.config(() -> String.format("%s: sendMessages called with no message queues registered.", new Object[]{this}));
            messageControlLock.writeLock().lock();
            if (this.activeMessages) {
                this.activeMessages = false;
            }
            messageControlLock.writeLock().unlock();
            return;
        }
        if (!this.canSend()) {
            log.config(() -> String.format("%s: sendMessages called while transport is unavailable.", new Object[]{this}));
            return;
        }
        messageControlLock.writeLock().lock();
        this.activeManager = true;
        messageControlLock.writeLock().unlock();
        try {
            int emptyCount = 0;
            while (this.pendingMessages < this.getPendingMessageLimit()) {
                MessageWrapper<? extends IMessage> msg;
                BAbstractMessageQueue queue;
                if (this.getMessageThrottlingLimit() > 0) {
                    long now = Clock.ticks();
                    if (this.messageWindowEnd < now) {
                        this.messageWindowEnd = now + 1000L;
                        this.messageWindowCount = 0;
                    }
                    if (this.messageWindowCount >= this.getMessageThrottlingLimit()) {
                        Object object = this.metricLock;
                        synchronized (object) {
                            ++this.messageWindowFullCount;
                            this.messageWindowFullTime = now;
                        }
                        try {
                            long sleepTime = this.messageWindowEnd - now;
                            log.fine(() -> String.format("%s: Message throttling window full; sleeping for %s ms", new Object[]{this, sleepTime}));
                            Thread.sleep(sleepTime);
                            this.messageWindowEnd += 1000L;
                            this.messageWindowCount = 0;
                        }
                        catch (InterruptedException e) {
                            messageControlLock.writeLock().lock();
                            this.activeManager = false;
                            messageControlLock.writeLock().unlock();
                            messageControlLock.writeLock().lock();
                            this.activeManager = false;
                            messageControlLock.writeLock().unlock();
                            log.finer(() -> String.format("%s: Exiting sendMessages", new Object[]{this}));
                            return;
                        }
                    }
                }
                ++this.lastQueueIndex;
                this.lastQueueIndex %= this.queues.size();
                if (this.lastQueueIndex == 0) {
                    ++this.currentWeight;
                    if (this.currentWeight >= this.maxWeight) {
                        this.currentWeight = 0;
                    }
                }
                if ((queue = this.queues.get(this.lastQueueIndex)).isEmpty()) {
                    if (++emptyCount != this.queues.size()) continue;
                    messageControlLock.writeLock().lock();
                    if (this.queues.stream().anyMatch(q -> !q.isEmpty())) {
                        messageControlLock.writeLock().unlock();
                        emptyCount = 0;
                        continue;
                    }
                    this.activeMessages = false;
                    messageControlLock.writeLock().unlock();
                    return;
                }
                if (queue.getWeight() <= this.currentWeight || (msg = queue.pullMessage()) == null) continue;
                emptyCount = 0;
                MessageWrapper<? extends IMessage> messageWrapper = msg;
                try {
                    AccessController.doPrivileged(() -> {
                        log.finer(() -> String.format("%s: Sending message id %s", new Object[]{this, messageWrapper.getMessageId()}));
                        ++this.pendingMessages;
                        ++this.messageWindowCount;
                        try {
                            messageWrapper.getTransportFuture().whenCompleteAsync((resp, err) -> {
                                --this.pendingMessages;
                                messageControlLock.readLock().lock();
                                if (!this.activeManager && this.activeMessages && this.pendingMessages <= this.getPendingMessageLimit() / 2) {
                                    messageControlLock.readLock().unlock();
                                    this.manager.execute(this::sendMessages);
                                } else {
                                    messageControlLock.readLock().unlock();
                                }
                                if (err == null) {
                                    Object object = this.metricLock;
                                    synchronized (object) {
                                        ++this.messagesSentOkCount;
                                        this.bytesSentCount += (long)messageWrapper.getMessage().getLength();
                                        this.lastMessageSentOkTime = System.currentTimeMillis();
                                    }
                                    queue.dequeueMessage(messageWrapper.getMessageId());
                                    messageWrapper.getMessageFuture().complete((IMessageResponse)resp);
                                } else {
                                    this.checkRetry(messageWrapper, queue, (Throwable)err);
                                }
                            }, (Executor)this.threadPool);
                            this.send(messageWrapper);
                        }
                        catch (Exception ex) {
                            log.warning(() -> String.format("%s: Error passing message %s to transport, %s", new Object[]{this, messageWrapper.getMessageId(), ex}));
                            --this.pendingMessages;
                            this.checkRetry(messageWrapper, queue, ex);
                        }
                        return null;
                    });
                }
                catch (PrivilegedActionException err) {
                    queue.dequeueMessage(messageWrapper.getMessageId());
                    messageWrapper.getMessageFuture().completeExceptionally(err.getException());
                }
            }
        }
        finally {
            messageControlLock.writeLock().lock();
            this.activeManager = false;
            messageControlLock.writeLock().unlock();
            log.finer(() -> String.format("%s: Exiting sendMessages", new Object[]{this}));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkRetry(MessageWrapper<? extends IMessage> messageWrapper, BAbstractMessageQueue queue, Throwable err) {
        if (messageWrapper.canRetry() && this.retriableError(err)) {
            log.config(() -> String.format("%s: Retrying message %s", new Object[]{this, messageWrapper.getMessageId()}));
            queue.retryMessage(messageWrapper.getMessageId());
            messageControlLock.readLock().lock();
            if (!this.activeManager) {
                messageControlLock.readLock().unlock();
                this.manager.execute(this::sendMessages);
            } else {
                messageControlLock.readLock().unlock();
            }
        } else {
            log.fine(() -> String.format("%s: Retry count exhausted for %s; message failed.", new Object[]{this, messageWrapper.getMessageId()}));
            Object object = this.metricLock;
            synchronized (object) {
                ++this.messagesSendFailureCount;
                this.lastMessageSendFailureTime = System.currentTimeMillis();
            }
            queue.dequeueMessage(messageWrapper.getMessageId());
            messageWrapper.getMessageFuture().completeExceptionally(err);
        }
    }

    protected boolean retriableError(Throwable err) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void spy(SpyWriter out) throws Exception {
        super.spy(out);
        out.startProps("Messaging");
        out.trTitle((Object)"General", 2);
        Object object = this.metricLock;
        synchronized (object) {
            out.prop((Object)"Metric Start Time", (Object)this.toDateTimeString(this.lastResetTime));
            out.prop((Object)"Registered Queue Count", this.queues.size());
            out.prop((Object)"Current Pending Message Count", this.pendingMessages);
            out.prop((Object)"Pending Message Limit", this.getPendingMessageLimit());
            out.prop((Object)"Message Window Full Count", (double)this.messageWindowFullCount);
            out.prop((Object)"Last Message Window Full Time", (Object)this.toDateTimeString(this.messageWindowFullTime));
            out.prop((Object)"Messages Compression Failure Count", (double)this.messageCompressionFailureCount);
            out.prop((Object)"Last Message Compression Failure Time", (Object)this.toDateTimeString(this.lastMessageCompressionFailureTime));
            out.prop((Object)"Messages Decompression Failure Count", (double)this.messageDecompressionFailureCount);
            out.prop((Object)"Last Message Decompression Failure Time", (Object)this.toDateTimeString(this.lastMessageDecompressionFailureTime));
            out.trTitle((Object)"Messages Sent", 2);
            out.prop((Object)"Total Messages Sent OK Count", (double)this.messagesSentOkCount);
            out.prop((Object)"Last Message Sent OK Time", (Object)this.toDateTimeString(this.lastMessageSentOkTime));
            out.prop((Object)"Total Bytes Sent", (double)this.bytesSentCount);
            out.trTitle((Object)"Message Send Failures", 2);
            out.prop((Object)"Messages Send Failure Count", (double)this.messagesSendFailureCount);
            out.prop((Object)"Last Message Send Failure Time", (Object)this.toDateTimeString(this.lastMessageSendFailureTime));
        }
        out.endProps();
    }

    protected String toDateTimeString(long value) {
        return value > 0L ? BAbsTime.make((long)value).encodeToString() : "n/a";
    }
}

