/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.tag;

import com.tridium.cloudLink.tag.CloudLinkTagUtil;
import java.io.IOException;
import javax.baja.control.BControlPoint;
import javax.baja.data.BIDataValue;
import javax.baja.driver.history.BHistoryImport;
import javax.baja.history.BHistoryService;
import javax.baja.history.ext.BHistoryExt;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFacets;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.tag.Entity;
import javax.baja.tag.Id;
import javax.baja.tag.Tag;
import javax.baja.tagdictionary.BTagInfo;
import javax.baja.units.BUnit;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="facetKey", type="String", defaultValue=""), @NiagaraProperty(name="tagNamespace", type="String", defaultValue="BString.make(NIAGARA_TAG_DICTIONARY_NS)")})
public class BFacetTag
extends BTagInfo {
    private static final String NIAGARA_TAG_DICTIONARY_NS = "n";
    public static final Property facetKey = BFacetTag.newProperty((int)0, (String)"", null);
    public static final Property tagNamespace = BFacetTag.newProperty((int)0, (BValue)BString.make((String)"n"), null);
    public static final Type TYPE = Sys.loadType(BFacetTag.class);
    public static final String VALUE_FACETS = "valueFacets";

    public String getFacetKey() {
        return this.getString(facetKey);
    }

    public void setFacetKey(String v) {
        this.setString(facetKey, v, null);
    }

    public String getTagNamespace() {
        return this.getString(tagNamespace);
    }

    public void setTagNamespace(String v) {
        this.setString(tagNamespace, v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BIDataValue getDefaultValue() {
        return BString.DEFAULT;
    }

    /*
     * Unable to fully structure code
     */
    public Tag getTag(Entity entity) {
        facets = null;
        facetValue = null;
        try {
            if (entity instanceof BControlPoint) {
                point = (BControlPoint)entity;
                facets = point.getFacets();
            } else if (entity instanceof BHistoryImport) {
                if (Sys.getStation() != null) {
                    historyService = (BHistoryService)Sys.getService((Type)BHistoryService.TYPE);
                    histDb = null;
                    if (historyService != null) {
                        histDb = historyService.getDatabase();
                    }
                    if (histDb != null) {
                        histDbConn = histDb.getDbConnection(null);
                        var7_8 = null;
                        try {
                            histImport = (BHistoryImport)entity;
                            histId = histImport.getHistoryId().fromShorthand(histImport.getDevice().getName());
                            hist = histDbConn.getHistory(histId);
                            if (hist == null || !((valueFacets = hist.get("valueFacets")) instanceof BFacets)) ** GOTO lbl41
                            facets = (BFacets)valueFacets;
                        }
                        catch (Throwable var8_11) {
                            var7_8 = var8_11;
                            throw var8_11;
                        }
                        finally {
                            if (histDbConn != null) {
                                if (var7_8 != null) {
                                    try {
                                        histDbConn.close();
                                    }
                                    catch (Throwable var8_10) {
                                        var7_8.addSuppressed(var8_10);
                                    }
                                } else {
                                    histDbConn.close();
                                }
                            }
                        }
                    }
                }
            } else if (entity instanceof BHistoryExt && (point = ((BHistoryExt)entity).getParentPoint()) != null) {
                facets = point.getFacets();
            }
lbl41:
            // 7 sources

            if (facets != null && this.isMeaningfulFacet(facetValue = (BIDataValue)facets.get(this.getFacetKey()))) {
                if ("range".equals(this.getFacetKey())) {
                    range = (BEnumRange)facetValue;
                    return new Tag(Id.newId((String)this.getTagNamespace(), (String)this.getFacetKey()), (BIDataValue)BString.make((String)SlotPath.unescape((String)range.encodeToStringExpanded())));
                }
                return new Tag(Id.newId((String)this.getTagNamespace(), (String)this.getFacetKey()), facetValue);
            }
        }
        catch (IOException e) {
            CloudLinkTagUtil.log.info(String.format("Could not encode tag value %s for tag %s on %s: %s", new Object[]{facetValue, this.getFacetKey(), entity, e.getMessage()}));
        }
        return null;
    }

    protected boolean isMeaningfulFacet(BIDataValue value) {
        if (value == null) {
            return false;
        }
        if (value instanceof BUnit) {
            return !((BUnit)value).isNull();
        }
        if (value instanceof BString) {
            return !value.equals(BString.DEFAULT);
        }
        if (value instanceof BEnumRange) {
            return !((BEnumRange)value).isNull();
        }
        return true;
    }
}

