/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.schedule.reverter.strict;

import biweekly.property.Summary;
import biweekly.util.ByDay;
import biweekly.util.Duration;
import biweekly.util.Recurrence;
import com.tridium.cloudLink.CloudLinkConstants;
import com.tridium.cloudLink.schedule.converter.ConverterUtils;
import com.tridium.cloudLink.schedule.converter.PropertyEncoder;
import com.tridium.cloudLink.schedule.plugin.AlwaysEffective;
import com.tridium.cloudLink.schedule.plugin.CalName;
import com.tridium.cloudLink.schedule.plugin.CleanupExpiredEvents;
import com.tridium.cloudLink.schedule.plugin.DefaultOutput;
import com.tridium.cloudLink.schedule.plugin.EffectiveValue;
import com.tridium.cloudLink.schedule.plugin.Facets;
import com.tridium.cloudLink.schedule.plugin.NiagaraClass;
import com.tridium.cloudLink.schedule.plugin.Parent;
import com.tridium.cloudLink.schedule.plugin.ScanLimit;
import com.tridium.cloudLink.schedule.plugin.ScheduleVCalendar;
import com.tridium.cloudLink.schedule.plugin.ScheduleVEvent;
import com.tridium.cloudLink.schedule.plugin.Union;
import com.tridium.cloudLink.schedule.reverter.ICalendarReverter;
import com.tridium.cloudLink.schedule.reverter.strict.DateRangeScheduleReverter;
import com.tridium.cloudLink.schedule.reverter.strict.DateScheduleReverter;
import com.tridium.cloudLink.schedule.reverter.strict.TimeScheduleReverter;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.baja.schedule.BAbstractSchedule;
import javax.baja.schedule.BBooleanSchedule;
import javax.baja.schedule.BCompositeSchedule;
import javax.baja.schedule.BCustomSchedule;
import javax.baja.schedule.BDailySchedule;
import javax.baja.schedule.BDateRangeSchedule;
import javax.baja.schedule.BDateSchedule;
import javax.baja.schedule.BDaySchedule;
import javax.baja.schedule.BEnumSchedule;
import javax.baja.schedule.BNumericSchedule;
import javax.baja.schedule.BScheduleReference;
import javax.baja.schedule.BStringSchedule;
import javax.baja.schedule.BTimeSchedule;
import javax.baja.schedule.BWeekAndDaySchedule;
import javax.baja.schedule.BWeekSchedule;
import javax.baja.schedule.BWeeklySchedule;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BWeekday;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.util.BFormat;

public class WeeklyScheduleReverter
implements ICalendarReverter<ScheduleVCalendar> {
    private final TimeScheduleReverter timeScheduleReverter = new TimeScheduleReverter();
    private final DateScheduleReverter dateScheduleReverter = new DateScheduleReverter();
    private final DateRangeScheduleReverter dateRangeScheduleReverter = new DateRangeScheduleReverter();
    static final Logger log = Logger.getLogger("cloudLink.channel.schedule");

    @Override
    public BAbstractSchedule revert(ScheduleVCalendar ical) {
        if (ical == null) {
            return null;
        }
        BWeeklySchedule schedule = this.makeWeeklyScheduleByCalType(ical);
        List<ScheduleVEvent> weekdayEvents = this.getWeekdayEvents(ical);
        List<ScheduleVEvent> specialEvents = this.getSpecialEvents(ical);
        this.addProperties(schedule, ical);
        this.addRange(schedule, ical);
        this.addWeekdaySchedules(schedule, weekdayEvents);
        this.addSpecialEvents(schedule, specialEvents);
        return schedule;
    }

    @Override
    public boolean isStrict() {
        return true;
    }

    private void addProperties(BWeeklySchedule schedule, ScheduleVCalendar ical) {
        ScanLimit propScanLimit;
        CleanupExpiredEvents cleanup;
        DefaultOutput defaultOutput;
        Facets facets;
        CalName calName;
        Union union;
        AlwaysEffective alwaysEffective;
        EffectiveValue effectiveValue = ical.getEffectiveValue();
        if (effectiveValue != null) {
            schedule.setEffectiveValue((BStatusValue)BStatusValue.make((BObject)effectiveValue.getBvalue()));
        }
        if ((alwaysEffective = ical.getAlwaysEffective()) != null) {
            schedule.setAlwaysEffective(((Boolean)alwaysEffective.getValue()).booleanValue());
        }
        if ((union = ical.getUnion()) != null) {
            schedule.setUnion(((Boolean)union.getValue()).booleanValue());
        }
        if ((calName = ical.getCalName()) != null) {
            schedule.add("calendarName", (BValue)BString.make((String)((String)calName.getValue())));
        }
        if ((facets = ical.getFacets()) != null) {
            BFacets decodedFacets = facets.getBajaFacets();
            schedule.setFacets(decodedFacets);
        }
        if ((defaultOutput = ical.getDefaultOutput()) != null) {
            BStatusValue exStatus = schedule.getDefaultOutput();
            exStatus.setValueValue(defaultOutput.getBvalue());
        }
        if ((cleanup = ical.getCleanupExpiredEvents()) != null) {
            schedule.setCleanupExpiredEvents(((Boolean)cleanup.getValue()).booleanValue());
        }
        if ((propScanLimit = ical.getScanLimit()) != null) {
            BRelTime bRelTime = BRelTime.make((long)((Duration)propScanLimit.getValue()).toMillis());
            schedule.setScanLimit(bRelTime);
        }
    }

    private void addRange(BWeeklySchedule schedule, ScheduleVCalendar ical) {
        BDateSchedule rangeStart = new BDateSchedule();
        rangeStart.setYear(PropertyEncoder.getSingleton(ical.getRangeStartYear()));
        rangeStart.setMonth(PropertyEncoder.getSingleton(ical.getRangeStartMonth()));
        rangeStart.setDay(PropertyEncoder.getSingleton(ical.getRangeStartDayOfMonth()));
        rangeStart.setWeekday(PropertyEncoder.getSingleton(ical.getRangeStartDayOfWeek()));
        BDateSchedule rangeEnd = new BDateSchedule();
        rangeEnd.setYear(PropertyEncoder.getSingleton(ical.getRangeEndYear()));
        rangeEnd.setMonth(PropertyEncoder.getSingleton(ical.getRangeEndMonth()));
        rangeEnd.setDay(PropertyEncoder.getSingleton(ical.getRangeEndDayOfMonth()));
        rangeEnd.setWeekday(PropertyEncoder.getSingleton(ical.getRangeEndDayOfWeek()));
        BDateRangeSchedule range = new BDateRangeSchedule();
        range.setStart(rangeStart);
        range.setEnd(rangeEnd);
        schedule.setEffective(range);
    }

    private BWeeklySchedule makeWeeklyScheduleByCalType(ScheduleVCalendar ical) {
        String scheduleType = ConverterUtils.getControlScheduleType(ical);
        Object schedule = CloudLinkConstants.BOOLEAN_SCHEDULE_TS.equals(scheduleType) ? new BBooleanSchedule() : (CloudLinkConstants.NUMERIC_SCHEDULE_TS.equals(scheduleType) ? new BNumericSchedule() : (CloudLinkConstants.ENUM_SCHEDULE_TS.equals(scheduleType) ? new BEnumSchedule() : new BStringSchedule()));
        return schedule;
    }

    private void addWeekdaySchedules(BWeeklySchedule schedule, List<ScheduleVEvent> weeklyEvents) {
        for (ScheduleVEvent event : weeklyEvents) {
            List<ByDay> dows = ((Recurrence)event.getRecurrenceRule().getValue()).getByDay();
            if (dows.size() == 1) {
                ByDay dow = dows.get(0);
                BTimeSchedule ts = (BTimeSchedule)this.timeScheduleReverter.revert(event);
                BWeekSchedule ws = (BWeekSchedule)schedule.getSchedule().get("week");
                BDaySchedule day = ws.get(BWeekday.make((int)dow.getDay().ordinal()));
                BDailySchedule combo = (BDailySchedule)day.getParent();
                day.add(ts);
                WeeklyScheduleReverter.setDisplayName(ts, (BAbstractSchedule)combo, event);
                continue;
            }
            log.log(Level.INFO, String.format("Invalid number of recurrence days (%d) for weekday schedule event '%s': ", dows.size(), event.getSummary()));
        }
    }

    private void addSpecialEvents(BWeeklySchedule schedule, List<ScheduleVEvent> specialEvents) {
        BCompositeSchedule specials = schedule.getSpecialEvents();
        BAbstractSchedule[] children = specials.getSchedules();
        for (ScheduleVEvent event : specialEvents) {
            Parent parentName = event.getParent();
            NiagaraClass niagaraClass = event.getNiagaraClass();
            BDailySchedule special = this.getSpecialEvent((String)parentName.getValue(), children, (String)niagaraClass.getValue(), event);
            BTimeSchedule ts = (BTimeSchedule)this.timeScheduleReverter.revert(event);
            special.getDay().add(ts);
            specials.add((String)parentName.getValue(), (BValue)special);
            WeeklyScheduleReverter.setDisplayName(ts, (BAbstractSchedule)special, event);
        }
    }

    private List<ScheduleVEvent> getWeekdayEvents(ScheduleVCalendar ical) {
        return ical.getScheduleEvents().stream().filter(ConverterUtils::isWeekday).collect(Collectors.toList());
    }

    private List<ScheduleVEvent> getSpecialEvents(ScheduleVCalendar ical) {
        return ical.getScheduleEvents().stream().filter(e -> !ConverterUtils.isWeekday(e)).collect(Collectors.toList());
    }

    private BDailySchedule getSpecialEvent(String name, BAbstractSchedule[] children, String typeSpec, ScheduleVEvent event) {
        for (BAbstractSchedule s : children) {
            if (!s.getName().equals(name)) continue;
            return (BDailySchedule)s;
        }
        BDailySchedule newSchedule = new BDailySchedule();
        if (CloudLinkConstants.DATE_SCHEDULE_TS.equals(typeSpec)) {
            BAbstractSchedule dateSchedule = this.dateScheduleReverter.revert(event);
            newSchedule.setDays(dateSchedule);
        } else if (CloudLinkConstants.DATE_RANGE_SCHEDULE_TS.equals(typeSpec)) {
            BAbstractSchedule dateRangeSchedule = this.dateRangeScheduleReverter.revert(event);
            newSchedule.setDays(dateRangeSchedule);
        } else if (CloudLinkConstants.CUSTOM_SCHEDULE_TS.equals(typeSpec)) {
            newSchedule.setDays((BAbstractSchedule)new BCustomSchedule());
        } else if (CloudLinkConstants.WEEK_AND_DAY_SCHEDULE_TS.equals(typeSpec)) {
            newSchedule.setDays((BAbstractSchedule)new BWeekAndDaySchedule());
        } else if (CloudLinkConstants.SCHEDULE_REFERENCE_TS.equals(typeSpec)) {
            newSchedule.setDays((BAbstractSchedule)new BScheduleReference());
        } else {
            log.log(Level.INFO, String.format("Invalid type %s of days component defined for schedule %s: ", typeSpec, name));
        }
        return newSchedule;
    }

    private static void setDisplayName(BTimeSchedule ts, BAbstractSchedule combo, ScheduleVEvent event) {
        Summary summary = event.getSummary();
        if (summary == null) {
            return;
        }
        String compositeName = (String)summary.getValue();
        if (compositeName == null || compositeName.isEmpty()) {
            return;
        }
        BasicContext cx = new BasicContext();
        String comboDisplayName = combo.getDisplayName((Context)cx);
        if (compositeName.startsWith(comboDisplayName + " ")) {
            String childName = compositeName.substring(comboDisplayName.length() + 1);
            Property parentProp = ts.getPropertyInParent();
            if (parentProp != null) {
                BAbstractSchedule parent = (BAbstractSchedule)ts.getParent();
                parent.setDisplayName(parentProp, BFormat.make((String)childName), (Context)cx);
            }
        }
    }
}

