/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.schedule.reverter.heuristic;

import biweekly.util.ByDay;
import biweekly.util.Frequency;
import biweekly.util.ICalDate;
import biweekly.util.Recurrence;
import com.tridium.cloudLink.schedule.converter.ConverterUtils;
import com.tridium.cloudLink.schedule.plugin.ScheduleVEvent;
import com.tridium.cloudLink.schedule.reverter.IVEventReverter;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.logging.Logger;
import javax.baja.schedule.BAbstractSchedule;
import javax.baja.schedule.BDateRangeSchedule;
import javax.baja.schedule.BDateSchedule;
import javax.baja.schedule.BDayOfMonthSchedule;
import javax.baja.schedule.BMonthSchedule;
import javax.baja.schedule.BWeekdaySchedule;
import javax.baja.util.BEnumSet;

public class RecurringEventReverter
implements IVEventReverter<ScheduleVEvent> {
    static final Logger log = Logger.getLogger("cloudLink.channel.schedule");

    @Override
    public BAbstractSchedule revert(ScheduleVEvent event) {
        Calendar cal = Calendar.getInstance();
        cal.setTime((Date)event.getDateStart().getValue());
        BDateSchedule start = new BDateSchedule();
        start.setYear(cal.get(1));
        start.setMonth(cal.get(2));
        start.setDay(cal.get(5));
        BDateSchedule end = new BDateSchedule();
        ICalDate lastDate = event.getLastOccurrence();
        if (!lastDate.equals(ScheduleVEvent.NO_DATE)) {
            cal.setTime(lastDate);
            end.setYear(cal.get(1));
            end.setMonth(cal.get(2));
            end.setDay(cal.get(5));
        }
        Recurrence rec = (Recurrence)event.getRecurrenceRule().getValue();
        Optional<Frequency> optFreq = ConverterUtils.getFrequency(event);
        List<Integer> byMonth = rec.getByMonth();
        List<Integer> byMonthDay = rec.getByMonthDay();
        List<ByDay> byWeekDay = rec.getByDay();
        if (optFreq.isPresent()) {
            Frequency freq = optFreq.get();
            if (Frequency.YEARLY.equals((Object)freq)) {
                start.setYear(-1);
                this.setMonths(start, byMonth);
                this.setDays(start, byMonthDay);
                this.setWeekdays(start, byWeekDay);
            } else if (Frequency.MONTHLY.equals((Object)freq)) {
                start.setYear(-1);
                start.setMonth(-1);
                this.setDays(start, byMonthDay);
                this.setWeekdays(start, byWeekDay);
            } else if (Frequency.WEEKLY.equals((Object)freq)) {
                start.setYear(-1);
                start.setMonth(-1);
                start.setDay(-1);
                this.setWeekdays(start, byWeekDay);
            } else if (!Frequency.DAILY.equals((Object)freq)) {
                log.info(String.format("Frequency %s not supported.", new Object[]{freq}));
                return null;
            }
        }
        if (lastDate.equals(ScheduleVEvent.NO_DATE)) {
            return start;
        }
        BDateRangeSchedule rangeSchedule = new BDateRangeSchedule();
        rangeSchedule.setStart(start);
        rangeSchedule.setEnd(end);
        return rangeSchedule;
    }

    private void setMonths(BDateSchedule schedule, List<Integer> byMonth) {
        if (byMonth != null && !byMonth.isEmpty()) {
            int[] days = byMonth.stream().mapToInt(Integer::intValue).toArray();
            BMonthSchedule month = new BMonthSchedule();
            month.setSet(BEnumSet.make((int[])days));
            schedule.setMonthSchedule(month);
        }
    }

    private void setDays(BDateSchedule schedule, List<Integer> byMonthDay) {
        if (byMonthDay != null && !byMonthDay.isEmpty()) {
            int[] days = byMonthDay.stream().mapToInt(Integer::intValue).toArray();
            BDayOfMonthSchedule dom = new BDayOfMonthSchedule();
            dom.setSet(BEnumSet.make((int[])days));
            schedule.setDaySchedule(dom);
        }
    }

    private void setWeekdays(BDateSchedule schedule, List<ByDay> byWeekday) {
        if (byWeekday != null && !byWeekday.isEmpty()) {
            int[] days = byWeekday.stream().mapToInt(d -> d.getDay().ordinal()).toArray();
            BWeekdaySchedule dow = new BWeekdaySchedule();
            dow.setSet(BEnumSet.make((int[])days));
            schedule.setWeekdaySchedule(dow);
        }
    }
}

