/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.schedule.reverter.heuristic;

import biweekly.util.ByDay;
import biweekly.util.Duration;
import biweekly.util.ICalDate;
import biweekly.util.Recurrence;
import com.tridium.cloudLink.CloudLinkConstants;
import com.tridium.cloudLink.schedule.converter.ConverterUtils;
import com.tridium.cloudLink.schedule.plugin.AlwaysEffective;
import com.tridium.cloudLink.schedule.plugin.CalName;
import com.tridium.cloudLink.schedule.plugin.CleanupExpiredEvents;
import com.tridium.cloudLink.schedule.plugin.DefaultOutput;
import com.tridium.cloudLink.schedule.plugin.EffectiveValue;
import com.tridium.cloudLink.schedule.plugin.Facets;
import com.tridium.cloudLink.schedule.plugin.ScanLimit;
import com.tridium.cloudLink.schedule.plugin.ScheduleVCalendar;
import com.tridium.cloudLink.schedule.plugin.ScheduleVEvent;
import com.tridium.cloudLink.schedule.plugin.Union;
import com.tridium.cloudLink.schedule.reverter.ICalendarReverter;
import com.tridium.cloudLink.schedule.reverter.heuristic.NonRecurringEventReverter;
import com.tridium.cloudLink.schedule.reverter.heuristic.RecurringEventReverter;
import com.tridium.cloudLink.schedule.reverter.strict.TimeScheduleReverter;
import com.tridium.util.EscUtil;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.baja.schedule.BAbstractSchedule;
import javax.baja.schedule.BBooleanSchedule;
import javax.baja.schedule.BCompositeSchedule;
import javax.baja.schedule.BDailySchedule;
import javax.baja.schedule.BDateRangeSchedule;
import javax.baja.schedule.BDateSchedule;
import javax.baja.schedule.BDaySchedule;
import javax.baja.schedule.BEnumSchedule;
import javax.baja.schedule.BNumericSchedule;
import javax.baja.schedule.BStringSchedule;
import javax.baja.schedule.BTimeSchedule;
import javax.baja.schedule.BWeekSchedule;
import javax.baja.schedule.BWeeklySchedule;
import javax.baja.status.BStatusBoolean;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BFacets;
import javax.baja.sys.BMonth;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BWeekday;

public class HeuristicWeeklyScheduleReverter
implements ICalendarReverter<ScheduleVCalendar> {
    private final TimeScheduleReverter timeScheduleReverter = new TimeScheduleReverter();
    private final NonRecurringEventReverter nonRecurringEventReverter = new NonRecurringEventReverter();
    private final RecurringEventReverter recurringEventReverter = new RecurringEventReverter();
    static final Logger log = Logger.getLogger("cloudLink.channel.schedule");

    @Override
    public BAbstractSchedule revert(ScheduleVCalendar ical) {
        if (ical == null) {
            return null;
        }
        BWeeklySchedule schedule = this.makeWeeklyScheduleByCalType(ical);
        List<ScheduleVEvent> weekdayEvents = this.getWeekdayEvents(ical);
        List<ScheduleVEvent> specialEvents = this.getSpecialEvents(ical);
        BDateRangeSchedule range = this.getRange(weekdayEvents, specialEvents);
        schedule.setEffective(range);
        this.addWeekdayEvents(schedule, weekdayEvents);
        this.addSpecialEvents(schedule, specialEvents);
        this.addProperties(schedule, ical);
        return schedule;
    }

    @Override
    public boolean isStrict() {
        return false;
    }

    private BWeeklySchedule makeWeeklyScheduleByCalType(ScheduleVCalendar ical) {
        String scheduleType = ConverterUtils.getControlScheduleType(ical);
        Object schedule = CloudLinkConstants.NUMERIC_SCHEDULE_TS.equals(scheduleType) ? new BNumericSchedule() : (CloudLinkConstants.ENUM_SCHEDULE_TS.equals(scheduleType) ? new BEnumSchedule() : (CloudLinkConstants.STRING_SCHEDULE_TS.equals(scheduleType) ? new BStringSchedule() : new BBooleanSchedule()));
        return schedule;
    }

    private BDateRangeSchedule getRange(List<ScheduleVEvent> weekdayEvents, List<ScheduleVEvent> specialEvents) {
        BDateSchedule rangeStart = null;
        BDateSchedule rangeEnd = null;
        if (!weekdayEvents.isEmpty()) {
            ICalDate earliestStart = weekdayEvents.stream().map(e -> (ICalDate)e.getDateStart().getValue()).reduce((d1, d2) -> d1.before((Date)d2) ? d1 : d2).orElse(ScheduleVEvent.NO_DATE);
            List startNotFitting = weekdayEvents.stream().filter(e -> ((ICalDate)e.getDateStart().getValue()).getTime() - earliestStart.getTime() > 604800000L).collect(Collectors.toList());
            weekdayEvents.removeAll(startNotFitting);
            specialEvents.addAll(startNotFitting);
            if (earliestStart.getTime() > 0L) {
                Calendar cals = Calendar.getInstance();
                cals.setTime(earliestStart);
                rangeStart = new BDateSchedule(cals.get(5), BMonth.make((int)cals.get(2)), cals.get(1));
            }
            ICalDate mostFrequentEnd = weekdayEvents.stream().collect(Collectors.groupingBy(Function.identity(), Collectors.counting())).entrySet().stream().max(Map.Entry.comparingByValue()).map(e -> (ScheduleVEvent)e.getKey()).get().getUntilDate();
            List endNotFitting = weekdayEvents.stream().filter(e -> e.getUntilDate().getTime() != mostFrequentEnd.getTime()).collect(Collectors.toList());
            weekdayEvents.removeAll(endNotFitting);
            specialEvents.addAll(endNotFitting);
            if (mostFrequentEnd.getTime() > 0L) {
                Calendar cale = Calendar.getInstance();
                cale.setTime(mostFrequentEnd);
                rangeEnd = new BDateSchedule(cale.get(5), BMonth.make((int)cale.get(2)), cale.get(1));
            }
        }
        BDateRangeSchedule range = new BDateRangeSchedule();
        if (rangeStart != null) {
            range.setStart(rangeStart);
        }
        if (rangeEnd != null) {
            range.setEnd(rangeEnd);
        }
        return range;
    }

    private void addWeekdayEvents(BWeeklySchedule schedule, List<ScheduleVEvent> weeklyEvents) {
        for (ScheduleVEvent event : weeklyEvents) {
            List<ByDay> dows = ((Recurrence)event.getRecurrenceRule().getValue()).getByDay();
            if (!dows.isEmpty()) {
                for (ByDay dow : dows) {
                    BTimeSchedule ts = (BTimeSchedule)this.timeScheduleReverter.revert(event);
                    ts.setEffectiveValue((BStatusValue)new BStatusBoolean(true));
                    BWeekSchedule ws = (BWeekSchedule)schedule.getSchedule().get("week");
                    BDaySchedule day = ws.get(BWeekday.make((int)dow.getDay().ordinal()));
                    day.add(ts);
                }
                continue;
            }
            log.log(Level.INFO, String.format("Empty set of recurrence days for weekday schedule event '%s': ", event.getSummary()));
        }
    }

    private void addSpecialEvents(BWeeklySchedule schedule, List<ScheduleVEvent> specialEvents) {
        BCompositeSchedule specials = schedule.getSpecialEvents();
        for (ScheduleVEvent event : specialEvents) {
            BDailySchedule special = this.makeSpecialEvent(event);
            if (special == null) continue;
            BTimeSchedule ts = (BTimeSchedule)this.timeScheduleReverter.revert(event);
            ts.setEffectiveValue((BStatusValue)new BStatusBoolean(true));
            special.getDay().add(ts);
            if (event.getSummary() != null) {
                specials.add(EscUtil.slot.escape((String)event.getSummary().getValue()), (BValue)special);
                continue;
            }
            specials.add((BAbstractSchedule)special);
        }
    }

    private void addProperties(BWeeklySchedule schedule, ScheduleVCalendar ical) {
        ScanLimit propScanLimit;
        CleanupExpiredEvents cleanup;
        DefaultOutput defaultOutput;
        Union union;
        EffectiveValue effectiveValue;
        CalName calName;
        AlwaysEffective alwaysEffective = ical.getAlwaysEffective();
        if (alwaysEffective != null) {
            schedule.setAlwaysEffective(((Boolean)alwaysEffective.getValue()).booleanValue());
        }
        if ((calName = ical.getCalName()) != null) {
            schedule.add("calendarName", (BValue)BString.make((String)((String)calName.getValue())));
        }
        if ((effectiveValue = ical.getEffectiveValue()) != null) {
            schedule.setEffectiveValue((BStatusValue)BStatusValue.make((BObject)effectiveValue.getBvalue()));
        } else {
            schedule.setEffectiveValue((BStatusValue)new BStatusBoolean(true));
        }
        Facets facets = ical.getFacets();
        if (facets != null) {
            BFacets decodedFacets = facets.getBajaFacets();
            schedule.setFacets(decodedFacets);
        }
        if ((union = ical.getUnion()) != null) {
            schedule.setUnion(((Boolean)union.getValue()).booleanValue());
        }
        if ((defaultOutput = ical.getDefaultOutput()) != null) {
            BStatusValue exStatus = schedule.getDefaultOutput();
            exStatus.setValueValue(defaultOutput.getBvalue());
        }
        if ((cleanup = ical.getCleanupExpiredEvents()) != null) {
            schedule.setCleanupExpiredEvents(((Boolean)cleanup.getValue()).booleanValue());
        }
        if ((propScanLimit = ical.getScanLimit()) != null) {
            BRelTime bRelTime = BRelTime.make((long)((Duration)propScanLimit.getValue()).toMillis());
            schedule.setScanLimit(bRelTime);
        }
    }

    private List<ScheduleVEvent> getWeekdayEvents(ScheduleVCalendar ical) {
        return ical.getScheduleEvents().stream().filter(e -> ConverterUtils.hasWeeklyFrequency(e)).collect(Collectors.toList());
    }

    private List<ScheduleVEvent> getSpecialEvents(ScheduleVCalendar ical) {
        return ical.getScheduleEvents().stream().filter(e -> !ConverterUtils.hasWeeklyFrequency(e)).collect(Collectors.toList());
    }

    private BDailySchedule makeSpecialEvent(ScheduleVEvent event) {
        BDailySchedule newSchedule = new BDailySchedule();
        BAbstractSchedule recurrenceSchedule = null;
        if (ConverterUtils.isNotRecurring(event)) {
            recurrenceSchedule = this.nonRecurringEventReverter.revert(event);
        } else if (ConverterUtils.isRecurringRegularly(event)) {
            recurrenceSchedule = this.recurringEventReverter.revert(event);
        } else {
            log.info("Unsupported recurrence rule for event: " + event.getUid());
        }
        if (recurrenceSchedule == null) {
            return null;
        }
        newSchedule.setDays(recurrenceSchedule);
        return newSchedule;
    }
}

