/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.schedule.plugin;

import biweekly.ICalVersion;
import biweekly.ValidationWarning;
import biweekly.component.ICalComponent;
import biweekly.property.TextProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.baja.sys.BFacets;

public class Facets
extends TextProperty {
    protected BFacets bajaFacets = BFacets.NULL;

    public Facets(String value) {
        super(value);
    }

    public Facets(Facets original) {
        super(original);
        this.bajaFacets = BFacets.make((BFacets)original.bajaFacets);
    }

    public BFacets getBajaFacets() {
        if (this.value != null && !((String)this.value).isEmpty() && this.bajaFacets == BFacets.NULL) {
            this.validate(null, ICalVersion.V2_0, new ArrayList<ValidationWarning>());
        }
        return this.bajaFacets;
    }

    @Override
    public Facets copy() {
        return new Facets(this);
    }

    @Override
    protected void validate(List<ICalComponent> components, ICalVersion version, List<ValidationWarning> warnings) {
        try {
            this.bajaFacets = (BFacets)BFacets.DEFAULT.decodeFromString((String)this.value);
        }
        catch (IOException ex) {
            warnings.add(new ValidationWarning(String.format("Invalid facets '%s': %s", this.value, ex.getMessage())));
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        Facets other = (Facets)obj;
        if (this.bajaFacets == null) {
            return other.bajaFacets == null;
        }
        return this.bajaFacets.equals((Object)other.bajaFacets);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.bajaFacets == null ? 0 : this.bajaFacets.hashCode());
        return result;
    }
}

