/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.schedule.plugin;

import biweekly.ICalDataType;
import biweekly.ICalVersion;
import biweekly.io.CannotParseException;
import biweekly.io.ParseContext;
import biweekly.io.WriteContext;
import biweekly.io.scribe.property.ICalPropertyScribe;
import biweekly.parameter.ICalParameters;
import biweekly.property.RawProperty;
import biweekly.util.Duration;
import com.tridium.cloudLink.CloudLinkConstants;
import com.tridium.cloudLink.schedule.converter.PropertyEncoder;
import com.tridium.cloudLink.schedule.plugin.DynamicTypeProperty;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BDouble;
import javax.baja.sys.BEnum;
import javax.baja.sys.BFloat;
import javax.baja.sys.BInteger;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;

public abstract class DynamicTypePropertyScribe<T extends DynamicTypeProperty>
extends ICalPropertyScribe<T> {
    protected DynamicTypePropertyScribe(Class<T> clazz, String propertyName) {
        super(clazz, propertyName, ICalDataType.TEXT);
    }

    protected DynamicTypePropertyScribe(Class<T> clazz, String propertyName, ICalDataType dataType) {
        super(clazz, propertyName, dataType);
    }

    @Override
    protected String _writeText(T property, WriteContext context) {
        return ((RawProperty)property).getValue();
    }

    @Override
    protected T _parseText(String value, ICalDataType dataType, ICalParameters parameters, ParseContext context) {
        String typeSpecParam = (String)parameters.first("TYPESPEC");
        String typeSpec = PropertyEncoder.getUnquotedValue(typeSpecParam);
        try {
            if (dataType == ICalDataType.INTEGER) {
                if (typeSpecParam != null) {
                    String enumRangeParam = (String)parameters.first("ENUM-RANGE");
                    String range = PropertyEncoder.getUnquotedValue(enumRangeParam);
                    BEnum enumValue = PropertyEncoder.parseEnumProperty(typeSpec, range, value);
                    return this.newInstance((BValue)enumValue, context.getVersion());
                }
                return this.newInstance((BValue)BInteger.make((String)value), context.getVersion());
            }
            if (dataType == ICalDataType.BOOLEAN) {
                return this.newInstance((BValue)BBoolean.make((String)value), context.getVersion());
            }
            if (dataType == ICalDataType.FLOAT) {
                if (CloudLinkConstants.FLOAT_TS.equals(typeSpec)) {
                    return this.newInstance((BValue)BFloat.make((String)value), context.getVersion());
                }
                return this.newInstance((BValue)BDouble.make((String)value), context.getVersion());
            }
            if (dataType == ICalDataType.DURATION) {
                Duration duration = Duration.parse(value);
                return this.newInstance((BValue)BRelTime.make((long)duration.toMillis()), context.getVersion());
            }
            return this.newInstance((BValue)BString.make((String)value), context.getVersion());
        }
        catch (IllegalArgumentException ex) {
            throw new CannotParseException(String.format("Parse error for property %s of type %s, value %s, parameters %s: %s", this.propertyName, dataType.toString(), value, parameters, ex.getMessage()));
        }
    }

    protected abstract T newInstance(BValue var1, ICalVersion var2);
}

