/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.schedule.plugin;

import biweekly.ICalDataType;
import biweekly.property.RawProperty;
import biweekly.util.Duration;
import java.io.IOException;
import java.util.logging.Logger;
import javax.baja.sys.BDouble;
import javax.baja.sys.BEnum;
import javax.baja.sys.BFloat;
import javax.baja.sys.BIBoolean;
import javax.baja.sys.BInteger;
import javax.baja.sys.BNumber;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.util.BTypeSpec;

public class DynamicTypeProperty
extends RawProperty {
    protected BValue bvalue;
    static final Logger log = Logger.getLogger("cloudLink.channel.schedule");

    public BValue getBvalue() {
        return this.bvalue;
    }

    protected DynamicTypeProperty(String name, BValue value) {
        super(name, ICalDataType.TEXT, value != null ? value.toString() : null);
        this.bvalue = value;
        try {
            if (value instanceof BIBoolean) {
                this.setDataType(ICalDataType.BOOLEAN);
            } else if (value instanceof BInteger) {
                this.setDataType(ICalDataType.INTEGER);
                this.setValue(((BInteger)value).encodeToString());
            } else if (value instanceof BFloat || value instanceof BDouble) {
                this.setDataType(ICalDataType.FLOAT);
                this.setValue(((BNumber)value).encodeToString());
                this.addParameter("TYPESPEC", value.getType().getTypeSpec().encodeToString());
            } else if (value instanceof BEnum) {
                BTypeSpec spec = value.getType().getTypeSpec();
                BEnum enumValue = (BEnum)value;
                this.setDataType(ICalDataType.INTEGER);
                this.setValue(String.valueOf(enumValue.getOrdinal()));
                this.addParameter("TYPESPEC", spec.encodeToString());
                this.addParameter("ENUM-RANGE", enumValue.getRange().encodeToStringExpanded());
            } else if (value instanceof BRelTime) {
                Duration duration = Duration.fromMillis(((BRelTime)value).getMillis());
                this.setDataType(ICalDataType.DURATION);
                this.setValue(duration.toString());
            }
        }
        catch (IOException ex) {
            log.info(() -> String.format("Error creating iCalendar property %s: %s", name, ex.getMessage()));
        }
    }

    public DynamicTypeProperty(RawProperty original) {
        super(original);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        DynamicTypeProperty other = (DynamicTypeProperty)obj;
        if (this.bvalue == null) {
            return other.bvalue == null;
        }
        return this.bvalue.equals((Object)other.bvalue);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.bvalue == null ? 0 : this.bvalue.hashCode());
        return result;
    }
}

