/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.schedule.plugin;

import biweekly.ICalDataType;
import biweekly.ICalVersion;
import biweekly.io.CannotParseException;
import biweekly.io.ParseContext;
import biweekly.io.WriteContext;
import biweekly.io.scribe.property.ICalPropertyScribe;
import biweekly.parameter.ICalParameters;
import biweekly.property.ValuedProperty;
import com.tridium.cloudLink.schedule.plugin.BooleanProperty;

public abstract class BooleanPropertyScribe<T extends BooleanProperty>
extends ICalPropertyScribe<T> {
    protected BooleanPropertyScribe(Class<T> clazz, String propertyName) {
        super(clazz, propertyName, ICalDataType.BOOLEAN);
    }

    protected BooleanPropertyScribe(Class<T> clazz, String propertyName, ICalDataType dataType) {
        super(clazz, propertyName, dataType);
    }

    @Override
    protected String _writeText(T property, WriteContext context) {
        Boolean value = (Boolean)((ValuedProperty)property).getValue();
        if (value != null) {
            return value.toString();
        }
        return "";
    }

    @Override
    protected T _parseText(String value, ICalDataType dataType, ICalParameters parameters, ParseContext context) {
        if (dataType != ICalDataType.BOOLEAN) {
            throw new CannotParseException(ICalDataType.BOOLEAN + " type expected but found: " + dataType.toString());
        }
        if (value.isEmpty()) {
            throw new CannotParseException("Boolean value expected but found no value");
        }
        if (!"true".equalsIgnoreCase(value) && !"false".equalsIgnoreCase(value)) {
            throw new CannotParseException("Boolean value expected but found: " + value);
        }
        return this.newInstance(value, context.getVersion());
    }

    protected abstract T newInstance(String var1, ICalVersion var2);
}

