/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.schedule.converter;

import com.tridium.cloudLink.schedule.converter.ConverterUtils;
import com.tridium.cloudLink.schedule.converter.DefaultScheduleConverter;
import com.tridium.cloudLink.schedule.converter.ScheduleConverter;
import com.tridium.cloudLink.schedule.plugin.ScheduleVCalendar;
import com.tridium.cloudLink.schedule.plugin.ScheduleVEvent;
import com.tridium.cloudLink.schedule.plugin.Year;
import java.io.IOException;
import java.util.Collections;
import javax.baja.schedule.BAbstractSchedule;
import javax.baja.schedule.BYearSchedule;

public class YearScheduleConverter
extends DefaultScheduleConverter {
    public YearScheduleConverter(ScheduleConverter masterConverter) {
        super(masterConverter);
    }

    @Override
    public boolean canConvert(BAbstractSchedule schedule) {
        return schedule instanceof BYearSchedule;
    }

    @Override
    public ScheduleVCalendar convert(BAbstractSchedule schedule, ScheduleVCalendar ical) throws IOException {
        if (!this.canConvert(schedule)) {
            throw new IllegalArgumentException("YearScheduleConverter invoked on schedule of type " + schedule.getClass().getName());
        }
        super.convert(schedule, ical);
        BYearSchedule ys = (BYearSchedule)schedule;
        ScheduleVEvent event = new ScheduleVEvent();
        ConverterUtils.assignUid((BAbstractSchedule)ys, event);
        event.setYear(new Year(Collections.singletonList(schedule.getAlwaysEffective() ? -1 : ys.getYear())));
        event.setSummary(schedule.getDisplayName(null));
        event.setDescription(schedule.getClass().getSimpleName());
        ical.addEvent(event);
        return ical;
    }
}

