/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.schedule.converter;

import com.tridium.cloudLink.schedule.converter.ControlScheduleConverter;
import com.tridium.cloudLink.schedule.converter.ConverterUtils;
import com.tridium.cloudLink.schedule.converter.ScheduleConverter;
import com.tridium.cloudLink.schedule.plugin.EffectiveValue;
import com.tridium.cloudLink.schedule.plugin.RangeEndDayOfMonth;
import com.tridium.cloudLink.schedule.plugin.RangeEndDayOfWeek;
import com.tridium.cloudLink.schedule.plugin.RangeEndMonth;
import com.tridium.cloudLink.schedule.plugin.RangeEndYear;
import com.tridium.cloudLink.schedule.plugin.RangeStartDayOfMonth;
import com.tridium.cloudLink.schedule.plugin.RangeStartDayOfWeek;
import com.tridium.cloudLink.schedule.plugin.RangeStartMonth;
import com.tridium.cloudLink.schedule.plugin.RangeStartYear;
import com.tridium.cloudLink.schedule.plugin.ScheduleVCalendar;
import com.tridium.cloudLink.schedule.plugin.ScheduleVEvent;
import java.io.IOException;
import javax.baja.schedule.BAbstractSchedule;
import javax.baja.schedule.BDailySchedule;
import javax.baja.schedule.BDateRangeSchedule;
import javax.baja.schedule.BWeekSchedule;
import javax.baja.schedule.BWeeklySchedule;

public class WeeklyScheduleConverter
extends ControlScheduleConverter {
    public WeeklyScheduleConverter(ScheduleConverter masterConverter) {
        super(masterConverter);
    }

    @Override
    public boolean canConvert(BAbstractSchedule schedule) {
        return schedule instanceof BWeeklySchedule;
    }

    @Override
    public ScheduleVCalendar convert(BAbstractSchedule schedule, ScheduleVCalendar ical) throws IOException {
        if (!this.canConvert(schedule)) {
            throw new IllegalArgumentException("WeeklyScheduleConverter invoked on schedule of type " + schedule.getClass().getName());
        }
        super.convert(schedule, ical);
        if (schedule.getEffectiveValue() != null) {
            ical.setEffectiveValue(new EffectiveValue(schedule.getEffectiveValue().getValueValue()));
        }
        BWeeklySchedule weekly = (BWeeklySchedule)schedule;
        BWeekSchedule week = weekly.getWeek();
        ScheduleVCalendar weekCal = this.master.convert((BAbstractSchedule)week, new ScheduleVCalendar());
        for (ScheduleVEvent e : weekCal.getScheduleEvents()) {
            ical.addEvent(e);
        }
        BDailySchedule[] specialEvents = weekly.getSpecialEventsChildren();
        for (int i = 0; i < specialEvents.length; ++i) {
            ScheduleVCalendar special = this.master.convert((BAbstractSchedule)specialEvents[i], new ScheduleVCalendar());
            for (ScheduleVEvent e : special.getScheduleEvents()) {
                ical.addEvent(e);
            }
        }
        BDateRangeSchedule effectiveRange = weekly.getEffective();
        ScheduleVCalendar rangeCal = this.master.convert((BAbstractSchedule)effectiveRange, new ScheduleVCalendar());
        ScheduleVEvent start = rangeCal.getScheduleEvents().get(0);
        ical.setRangeStartYear(new RangeStartYear(start.getYear()));
        ical.setRangeStartMonth(new RangeStartMonth(start.getMonth()));
        ical.setRangeStartDayOfMonth(new RangeStartDayOfMonth(start.getDayOfMonth()));
        ical.setRangeStartDayOfWeek(new RangeStartDayOfWeek(start.getDayOfWeek()));
        ScheduleVEvent end = rangeCal.getScheduleEvents().get(1);
        ical.setRangeEndYear(new RangeEndYear(end.getYear()));
        ical.setRangeEndMonth(new RangeEndMonth(end.getMonth()));
        ical.setRangeEndDayOfMonth(new RangeEndDayOfMonth(end.getDayOfMonth()));
        ical.setRangeEndDayOfWeek(new RangeEndDayOfWeek(end.getDayOfWeek()));
        ConverterUtils.applyRange(rangeCal, ical);
        ical.getTimezoneInfo().setGlobalFloatingTime(true);
        return ical;
    }
}

