/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.schedule.converter;

import com.tridium.cloudLink.schedule.converter.ConverterUtils;
import com.tridium.cloudLink.schedule.converter.EnumSetScheduleConverter;
import com.tridium.cloudLink.schedule.converter.ScheduleConverter;
import com.tridium.cloudLink.schedule.plugin.DayOfWeek;
import com.tridium.cloudLink.schedule.plugin.ScheduleVCalendar;
import com.tridium.cloudLink.schedule.plugin.ScheduleVEvent;
import java.io.IOException;
import javax.baja.schedule.BAbstractSchedule;
import javax.baja.schedule.BWeekdaySchedule;

public class WeekdayScheduleConverter
extends EnumSetScheduleConverter {
    public WeekdayScheduleConverter(ScheduleConverter masterConverter) {
        super(masterConverter);
    }

    @Override
    public boolean canConvert(BAbstractSchedule schedule) {
        return schedule instanceof BWeekdaySchedule;
    }

    @Override
    public ScheduleVCalendar convert(BAbstractSchedule schedule, ScheduleVCalendar ical) throws IOException {
        if (!this.canConvert(schedule)) {
            throw new IllegalArgumentException("WeekdayScheduleConverter invoked on schedule of type " + schedule.getClass().getName());
        }
        super.convert(schedule, ical);
        BWeekdaySchedule wds = (BWeekdaySchedule)schedule;
        ScheduleVEvent event = new ScheduleVEvent();
        ConverterUtils.assignUid((BAbstractSchedule)wds, event);
        event.setDayOfWeek(new DayOfWeek(wds.getSet().getOrdinals()));
        event.setSummary(schedule.getDisplayName(null));
        event.setDescription(schedule.getClass().getSimpleName());
        ical.addEvent(event);
        return ical;
    }
}

