/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.schedule.converter;

import com.tridium.cloudLink.schedule.converter.ConverterUtils;
import com.tridium.cloudLink.schedule.converter.DefaultScheduleConverter;
import com.tridium.cloudLink.schedule.converter.ScheduleConverter;
import com.tridium.cloudLink.schedule.plugin.ScheduleVCalendar;
import com.tridium.cloudLink.schedule.plugin.ScheduleVEvent;
import com.tridium.cloudLink.schedule.plugin.WeekOfMonth;
import java.io.IOException;
import javax.baja.schedule.BAbstractSchedule;
import javax.baja.schedule.BWeekOfMonthSchedule;

public class WeekOfMonthScheduleConverter
extends DefaultScheduleConverter {
    public WeekOfMonthScheduleConverter(ScheduleConverter masterConverter) {
        super(masterConverter);
    }

    @Override
    public boolean canConvert(BAbstractSchedule schedule) {
        return schedule instanceof BWeekOfMonthSchedule;
    }

    @Override
    public ScheduleVCalendar convert(BAbstractSchedule schedule, ScheduleVCalendar ical) throws IOException {
        if (!this.canConvert(schedule)) {
            throw new IllegalArgumentException("WeekOfMonthScheduleConverter invoked on schedule of type " + schedule.getClass().getName());
        }
        super.convert(schedule, ical);
        ical.getTimezoneInfo().setGlobalFloatingTime(true);
        BWeekOfMonthSchedule woms = (BWeekOfMonthSchedule)schedule;
        ScheduleVEvent event = new ScheduleVEvent();
        ConverterUtils.assignUid((BAbstractSchedule)woms, event);
        event.setSummary(schedule.getDisplayName(null));
        event.setDescription(schedule.getClass().getSimpleName());
        event.setWeekOfMonth(new WeekOfMonth(woms.getSet().getOrdinals()));
        ical.addEvent(event);
        return ical;
    }
}

