/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.schedule.converter;

import biweekly.property.RawProperty;
import com.tridium.cloudLink.schedule.converter.ConverterUtils;
import com.tridium.cloudLink.schedule.converter.DefaultScheduleConverter;
import com.tridium.cloudLink.schedule.converter.ScheduleConverter;
import com.tridium.cloudLink.schedule.plugin.ScheduleVCalendar;
import com.tridium.cloudLink.schedule.plugin.ScheduleVEvent;
import java.io.IOException;
import javax.baja.schedule.BAbstractSchedule;
import javax.baja.schedule.BWeekAndDaySchedule;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;

public class WeekAndDayScheduleConverter
extends DefaultScheduleConverter {
    public WeekAndDayScheduleConverter(ScheduleConverter masterConverter) {
        super(masterConverter);
    }

    @Override
    public boolean canConvert(BAbstractSchedule schedule) {
        return schedule instanceof BWeekAndDaySchedule;
    }

    @Override
    public ScheduleVCalendar convert(BAbstractSchedule schedule, ScheduleVCalendar ical) throws IOException {
        if (!this.canConvert(schedule)) {
            throw new IllegalArgumentException("WeekAndDayScheduleConverter invoked on schedule of type " + schedule.getClass().getName());
        }
        super.convert(schedule, ical);
        ScheduleVEvent weekAndDayEvent = new ScheduleVEvent();
        ConverterUtils.assignUid(schedule, weekAndDayEvent);
        BAbstractSchedule[] kids = (BAbstractSchedule[])schedule.getChildren(BAbstractSchedule.class);
        for (int i = 0; i < kids.length; ++i) {
            ScheduleVCalendar ci = this.master.convert(kids[i], new ScheduleVCalendar());
            for (ScheduleVEvent e : ci.getScheduleEvents()) {
                for (RawProperty prop : e.getExperimentalProperties()) {
                    weekAndDayEvent.addExperimentalProperty(prop.getName(), prop.getValue());
                }
                if (e.getMonth() != null) {
                    weekAndDayEvent.setMonth(e.getMonth());
                }
                if (e.getDayOfWeek() != null) {
                    weekAndDayEvent.setDayOfWeek(e.getDayOfWeek());
                }
                if (e.getWeekOfMonth() == null) continue;
                weekAndDayEvent.setWeekOfMonth(e.getWeekOfMonth());
            }
        }
        weekAndDayEvent.setSummary(schedule.getDisplayName((Context)new BasicContext()));
        weekAndDayEvent.setDescription(schedule.getClass().getSimpleName());
        ical.addEvent(weekAndDayEvent);
        return ical;
    }
}

