/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.schedule.converter;

import biweekly.property.RecurrenceRule;
import biweekly.util.Frequency;
import biweekly.util.Recurrence;
import com.tridium.cloudLink.schedule.converter.ConverterUtils;
import com.tridium.cloudLink.schedule.converter.DefaultScheduleConverter;
import com.tridium.cloudLink.schedule.converter.ScheduleConverter;
import com.tridium.cloudLink.schedule.plugin.AlwaysEffective;
import com.tridium.cloudLink.schedule.plugin.EffectiveValue;
import com.tridium.cloudLink.schedule.plugin.ScheduleVCalendar;
import com.tridium.cloudLink.schedule.plugin.ScheduleVEvent;
import java.io.IOException;
import java.util.Date;
import javax.baja.schedule.BAbstractSchedule;
import javax.baja.schedule.BTimeSchedule;
import javax.baja.sys.BTime;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;

public class TimeScheduleConverter
extends DefaultScheduleConverter {
    public TimeScheduleConverter(ScheduleConverter masterConverter) {
        super(masterConverter);
    }

    @Override
    public boolean canConvert(BAbstractSchedule schedule) {
        return schedule instanceof BTimeSchedule;
    }

    @Override
    public ScheduleVCalendar convert(BAbstractSchedule schedule, ScheduleVCalendar ical) throws IOException {
        if (!this.canConvert(schedule)) {
            throw new IllegalArgumentException("TimeScheduleConverter invoked on schedule of type " + schedule.getClass().getName());
        }
        super.convert(schedule, ical);
        BTimeSchedule timeSchedule = (BTimeSchedule)schedule;
        ScheduleVEvent event = new ScheduleVEvent();
        ConverterUtils.assignUid((BAbstractSchedule)timeSchedule, event);
        String scheduleName = schedule.getDisplayName((Context)new BasicContext());
        ical.getTimezoneInfo().setGlobalFloatingTime(true);
        event.setDateStart(ConverterUtils.localDate(timeSchedule.getStart()), true);
        Date localEnd = ConverterUtils.localDate(timeSchedule.getFinish());
        if (timeSchedule.getFinish().equals((Object)BTime.DEFAULT)) {
            localEnd.setTime(localEnd.getTime() + 86400000L);
        }
        event.setDateEnd(localEnd, true);
        event.setAlwaysEffective(new AlwaysEffective(schedule.getAlwaysEffective()));
        if (timeSchedule.getEffectiveValue() != null) {
            event.setEffectiveValue(new EffectiveValue(timeSchedule.getEffectiveValue().getValueValue()));
        }
        event.setRecurrenceRule(new RecurrenceRule(new Recurrence.Builder(Frequency.DAILY).build()));
        event.setSummary(scheduleName);
        ical.addEvent(event);
        return ical;
    }
}

