/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.schedule.converter;

import biweekly.property.CalendarScale;
import biweekly.property.Method;
import com.tridium.cloudLink.schedule.converter.IScheduleConverter;
import com.tridium.cloudLink.schedule.converter.ScheduleConverter;
import com.tridium.cloudLink.schedule.plugin.AlwaysEffective;
import com.tridium.cloudLink.schedule.plugin.CalName;
import com.tridium.cloudLink.schedule.plugin.NiagaraClass;
import com.tridium.cloudLink.schedule.plugin.ScheduleVCalendar;
import java.io.IOException;
import javax.baja.schedule.BAbstractSchedule;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.sys.Type;
import javax.baja.util.BTypeSpec;

public class DefaultScheduleConverter
implements IScheduleConverter<ScheduleVCalendar> {
    protected ScheduleConverter master;

    public DefaultScheduleConverter(ScheduleConverter masterConverter) {
        this.master = masterConverter;
    }

    @Override
    public boolean canConvert(BAbstractSchedule schedule) {
        return schedule != null;
    }

    @Override
    public ScheduleVCalendar convert(BAbstractSchedule schedule, ScheduleVCalendar ical) throws IOException {
        if (!this.canConvert(schedule) || ical == null) {
            throw new IllegalArgumentException("Cannot apply default schedule converter");
        }
        ical.setProductId("-//Tridium//NONSGML Niagara Schedules v1.1//EN");
        ical.setCalName(new CalName(schedule.getDisplayName((Context)new BasicContext())));
        ical.setCalendarScale(CalendarScale.gregorian());
        ical.setMethod(Method.publish());
        ical.setAlwaysEffective(new AlwaysEffective(schedule.getAlwaysEffective()));
        String typeSpec = BTypeSpec.make((Type)schedule.getType()).encodeToString();
        ical.setNiagaraClass(new NiagaraClass(typeSpec));
        return ical;
    }
}

