/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.schedule.converter;

import biweekly.property.RawProperty;
import com.tridium.cloudLink.schedule.converter.ConverterUtils;
import com.tridium.cloudLink.schedule.converter.DefaultScheduleConverter;
import com.tridium.cloudLink.schedule.converter.ScheduleConverter;
import com.tridium.cloudLink.schedule.plugin.DayOfMonth;
import com.tridium.cloudLink.schedule.plugin.DayOfWeek;
import com.tridium.cloudLink.schedule.plugin.Month;
import com.tridium.cloudLink.schedule.plugin.ScheduleVCalendar;
import com.tridium.cloudLink.schedule.plugin.ScheduleVEvent;
import com.tridium.cloudLink.schedule.plugin.Year;
import java.io.IOException;
import java.util.Collections;
import javax.baja.schedule.BAbstractSchedule;
import javax.baja.schedule.BDateSchedule;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;

public class DateScheduleConverter
extends DefaultScheduleConverter {
    public DateScheduleConverter(ScheduleConverter masterConverter) {
        super(masterConverter);
    }

    @Override
    public boolean canConvert(BAbstractSchedule schedule) {
        return schedule instanceof BDateSchedule;
    }

    @Override
    public ScheduleVCalendar convert(BAbstractSchedule schedule, ScheduleVCalendar ical) throws IOException {
        if (!this.canConvert(schedule)) {
            throw new IllegalArgumentException("DateScheduleConverter invoked on schedule of type " + schedule.getClass().getName());
        }
        super.convert(schedule, ical);
        ScheduleVEvent dateEvent = new ScheduleVEvent();
        ConverterUtils.assignUid(schedule, dateEvent);
        BAbstractSchedule[] kids = (BAbstractSchedule[])schedule.getChildren(BAbstractSchedule.class);
        dateEvent.setDayOfMonth(new DayOfMonth(Collections.emptyList()));
        dateEvent.setDayOfWeek(new DayOfWeek(Collections.emptyList()));
        for (int i = 0; i < kids.length; ++i) {
            ScheduleVCalendar ci = this.master.convert(kids[i], new ScheduleVCalendar());
            for (ScheduleVEvent e : ci.getScheduleEvents()) {
                for (RawProperty prop : e.getExperimentalProperties()) {
                    dateEvent.addExperimentalProperty(prop.getName(), prop.getValue());
                }
                if (e.getYear() != null) {
                    dateEvent.setYear(new Year(e.getYear()));
                }
                if (e.getMonth() != null) {
                    dateEvent.setMonth(new Month(e.getMonth()));
                }
                if (e.getDayOfMonth() != null) {
                    dateEvent.setDayOfMonth(new DayOfMonth(e.getDayOfMonth()));
                }
                if (e.getDayOfWeek() == null) continue;
                dateEvent.setDayOfWeek(new DayOfWeek(e.getDayOfWeek()));
            }
        }
        dateEvent.setSummary(schedule.getDisplayName((Context)new BasicContext()));
        dateEvent.setDescription(schedule.getClass().getSimpleName());
        ical.addEvent(dateEvent);
        return ical;
    }
}

