/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.schedule.converter;

import biweekly.property.RecurrenceRule;
import biweekly.util.ICalDate;
import com.tridium.cloudLink.schedule.converter.ConverterUtils;
import com.tridium.cloudLink.schedule.converter.DefaultScheduleConverter;
import com.tridium.cloudLink.schedule.converter.ScheduleConverter;
import com.tridium.cloudLink.schedule.plugin.DayOfMonth;
import com.tridium.cloudLink.schedule.plugin.DayOfWeek;
import com.tridium.cloudLink.schedule.plugin.Month;
import com.tridium.cloudLink.schedule.plugin.NiagaraClass;
import com.tridium.cloudLink.schedule.plugin.Parent;
import com.tridium.cloudLink.schedule.plugin.RangeEndDayOfMonth;
import com.tridium.cloudLink.schedule.plugin.RangeEndDayOfWeek;
import com.tridium.cloudLink.schedule.plugin.RangeEndMonth;
import com.tridium.cloudLink.schedule.plugin.RangeEndYear;
import com.tridium.cloudLink.schedule.plugin.RangeStartDayOfMonth;
import com.tridium.cloudLink.schedule.plugin.RangeStartDayOfWeek;
import com.tridium.cloudLink.schedule.plugin.RangeStartMonth;
import com.tridium.cloudLink.schedule.plugin.RangeStartYear;
import com.tridium.cloudLink.schedule.plugin.ScheduleVCalendar;
import com.tridium.cloudLink.schedule.plugin.ScheduleVEvent;
import com.tridium.cloudLink.schedule.plugin.Year;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.schedule.BAbstractSchedule;
import javax.baja.schedule.BDailySchedule;
import javax.baja.schedule.BDateRangeSchedule;
import javax.baja.schedule.BDateSchedule;
import javax.baja.schedule.BDaySchedule;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.sys.Type;
import javax.baja.util.BTypeSpec;

public class DailyScheduleConverter
extends DefaultScheduleConverter {
    static final Logger log = Logger.getLogger("cloudLink.channel.schedule");

    public DailyScheduleConverter(ScheduleConverter masterConverter) {
        super(masterConverter);
    }

    @Override
    public boolean canConvert(BAbstractSchedule schedule) {
        return schedule instanceof BDailySchedule;
    }

    @Override
    public ScheduleVCalendar convert(BAbstractSchedule schedule, ScheduleVCalendar ical) throws IOException {
        if (!this.canConvert(schedule)) {
            throw new IllegalArgumentException("DailyScheduleConverter invoked on schedule of type " + schedule.getClass().getName());
        }
        super.convert(schedule, ical);
        String scheduleName = schedule.getDisplayName((Context)new BasicContext());
        BDailySchedule daily = (BDailySchedule)schedule;
        BDaySchedule day = daily.getDay();
        BAbstractSchedule days = daily.getDays();
        ScheduleVCalendar rangeCal = this.master.convert(days, new ScheduleVCalendar());
        ScheduleVCalendar dayCal = this.master.convert((BAbstractSchedule)day, new ScheduleVCalendar());
        List<ScheduleVEvent> dayEvents = dayCal.getScheduleEvents();
        String typeSpec = BTypeSpec.make((Type)days.getType()).encodeToString();
        for (ScheduleVEvent de : dayEvents) {
            ScheduleVEvent e = new ScheduleVEvent(de);
            Optional<Date> rangeStartDate = ConverterUtils.extractDate(rangeCal.getScheduleEvents().get(0), true);
            rangeStartDate.ifPresent(date -> e.setDateStart(ConverterUtils.combineDates(date, (ICalDate)de.getDateStart().getValue())));
            rangeStartDate.ifPresent(date -> e.setDateEnd(ConverterUtils.combineDates(date, (ICalDate)de.getDateEnd().getValue())));
            ConverterUtils.adjustEndOfDay(e);
            RecurrenceRule recurrenceRule = ConverterUtils.makeRecurrenceRule(rangeCal, schedule.getName());
            if (recurrenceRule == null) {
                throw new UnsupportedOperationException("Unsupported recurrence rule: different start and end year or endDate < startDate with Month as a wildcard : " + schedule.getClass().getName());
            }
            e.setRecurrenceRule(recurrenceRule);
            e.setSummary(scheduleName + " " + (String)de.getSummary().getValue());
            e.setNiagaraClass(new NiagaraClass(typeSpec));
            e.setParent(new Parent(schedule.getName()));
            this.addRangeProperties(e, rangeCal, days);
            ical.addEvent(e);
        }
        ConverterUtils.applyRange(rangeCal, ical);
        return ical;
    }

    private void addRangeProperties(ScheduleVEvent event, ScheduleVCalendar rangeCal, BAbstractSchedule days) {
        List<ScheduleVEvent> rangeEvents = rangeCal.getScheduleEvents();
        if (days instanceof BDateSchedule) {
            if (rangeEvents.size() == 1) {
                ScheduleVEvent de = rangeCal.getScheduleEvents().get(0);
                event.setYear(new Year(de.getYear()));
                event.setMonth(new Month(de.getMonth()));
                event.setDayOfMonth(new DayOfMonth(de.getDayOfMonth()));
                event.setDayOfWeek(new DayOfWeek(de.getDayOfWeek()));
            } else {
                log.log(Level.INFO, String.format("Invalid number of events %d for DateSchedule '%s': ", rangeEvents.size(), rangeCal));
            }
        } else if (days instanceof BDateRangeSchedule) {
            if (rangeEvents.size() == 2) {
                ScheduleVEvent start = rangeCal.getScheduleEvents().get(0);
                event.setRangeStartYear(new RangeStartYear(start.getYear()));
                event.setRangeStartMonth(new RangeStartMonth(start.getMonth()));
                event.setRangeStartDayOfMonth(new RangeStartDayOfMonth(start.getDayOfMonth()));
                event.setRangeStartDayOfWeek(new RangeStartDayOfWeek(start.getDayOfWeek()));
                ScheduleVEvent end = rangeCal.getScheduleEvents().get(1);
                event.setRangeEndYear(new RangeEndYear(end.getYear()));
                event.setRangeEndMonth(new RangeEndMonth(end.getMonth()));
                event.setRangeEndDayOfMonth(new RangeEndDayOfMonth(end.getDayOfMonth()));
                event.setRangeEndDayOfWeek(new RangeEndDayOfWeek(end.getDayOfWeek()));
            } else {
                log.log(Level.INFO, String.format("Invalid number of events %d for DateRangeSchedule '%s': ", rangeEvents.size(), rangeCal));
            }
        }
    }
}

