/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.schedule.converter;

import biweekly.component.VEvent;
import biweekly.property.DateEnd;
import biweekly.property.DateStart;
import biweekly.property.RecurrenceRule;
import biweekly.util.DayOfWeek;
import biweekly.util.Frequency;
import biweekly.util.ICalDate;
import biweekly.util.Recurrence;
import com.tridium.clUtils.util.TagUtil;
import com.tridium.cloudLink.CloudLinkConstants;
import com.tridium.cloudLink.schedule.plugin.IntervalProperty;
import com.tridium.cloudLink.schedule.plugin.NiagaraClass;
import com.tridium.cloudLink.schedule.plugin.ScheduleVCalendar;
import com.tridium.cloudLink.schedule.plugin.ScheduleVEvent;
import com.tridium.util.CompUtil;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.baja.data.BIDataValue;
import javax.baja.schedule.BAbstractSchedule;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;

public final class ConverterUtils {
    private static final Map<String, DayOfWeek> weekdayMap = new HashMap<String, DayOfWeek>();
    public static final List<Integer> ODD_MONTHS;
    public static final List<Integer> EVEN_MONTHS;
    public static final List<Integer> ODD_DAYS;
    public static final List<Integer> EVEN_DAYS;
    public static final List<Integer> LAST_SEVEN_DAYS;
    public static final String SCHEDULE_UIDS_PROP_NAME = "scheduleUids";
    public static final Date DEFAULT_START_DATE;
    static final Logger log;

    private ConverterUtils() {
    }

    public static Optional<Date> extractDate(ScheduleVEvent event, boolean isStartDate) {
        List<Integer> weekOfMonth;
        Optional<Date> date = Optional.empty();
        List years = event.getYear() != null && event.getYear().getValues() != null ? event.getYear().getValues() : Collections.emptyList();
        List<Integer> months = event.getMonth() != null && event.getMonth().getValues() != null ? event.getMonth().getValues() : Collections.emptyList();
        List<Integer> days = event.getDayOfMonth() != null && event.getDayOfMonth().getValues() != null ? event.getDayOfMonth().getValues() : Collections.emptyList();
        List<Integer> weekDays = event.getDayOfWeek() != null && event.getDayOfWeek().getValues() != null ? event.getDayOfWeek().getValues() : Collections.emptyList();
        List<Integer> list = weekOfMonth = event.getWeekOfMonth() != null && event.getWeekOfMonth().getValues() != null ? event.getWeekOfMonth().getValues() : Collections.emptyList();
        if ((years.isEmpty() || ((Integer)years.get(0)).equals(-1)) && months.isEmpty() && days.isEmpty() && weekDays.isEmpty()) {
            return date;
        }
        try {
            Calendar calendar;
            int day;
            int year = years.isEmpty() ? -1 : (Integer)years.get(0);
            int month = months.isEmpty() ? -1 : (Integer)months.get(0);
            int n = day = days.isEmpty() ? -1 : (Integer)days.get(0);
            if (isStartDate) {
                month = month == -1 ? 0 : month;
                day = day == -1 ? 1 : day;
                year = year == -1 ? ConverterUtils.getCurrentYear() : year;
            } else {
                if (month == -1) {
                    month = 11;
                }
                if (day == -1) {
                    calendar = Calendar.getInstance();
                    calendar.set(year, month, 1);
                    day = calendar.getActualMaximum(5);
                }
            }
            calendar = Calendar.getInstance();
            calendar.set(year, month, day, 0, 0, 0);
            if (!weekDays.isEmpty()) {
                ConverterUtils.handleWeekDays(months, weekDays, days, weekOfMonth, year, month, day, calendar);
            } else {
                calendar.set(5, day);
            }
            calendar.set(14, 0);
            date = Optional.of(calendar.getTime());
        }
        catch (NumberFormatException ex) {
            log.log(Level.INFO, log.isLoggable(Level.FINE) ? ex : null, () -> "Error converting date time components.");
        }
        return date;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void handleWeekDays(List<Integer> months, List<Integer> weekDays, List<Integer> days, List<Integer> weekOfMonth, int year, int month, int day, Calendar calendar) {
        int weekday = weekDays.get(0);
        if (days.isEmpty()) {
            if (!weekOfMonth.isEmpty()) {
                int weekNum = weekOfMonth.get(0);
                while (true) {
                    calendar.set(5, 1);
                    int firstDayOfMonth = calendar.get(7) - 1;
                    int daysToAdd = weekNum == 1 ? (weekday - firstDayOfMonth + 7) % 7 : (weekNum - 1) * 7 + (weekday - firstDayOfMonth + 7) % 7;
                    calendar.add(5, daysToAdd);
                    if (calendar.get(2) == month) return;
                    calendar.add(1, 1);
                    calendar.set(2, month);
                }
            }
            int firstWeekdayOfMonth = calendar.get(7);
            int firstDayOfMonthAdjusted = firstWeekdayOfMonth - 1;
            int daysToAdd = (weekday - firstDayOfMonthAdjusted + 7) % 7;
            calendar.add(5, daysToAdd);
            return;
        } else {
            if (!days.isEmpty() && !months.isEmpty()) {
                boolean dateSet = false;
                while (!dateSet) {
                    calendar.set(1, calendar.get(1));
                    calendar.set(2, month);
                    calendar.set(5, day);
                    int currentWeekday = calendar.get(7) - 1;
                    if (currentWeekday == weekday) {
                        return;
                    }
                    calendar.add(1, 1);
                }
                return;
            }
            if (days.isEmpty()) return;
            if (year == -1) return;
            boolean dateSet = false;
            while (!dateSet) {
                calendar.set(1, year);
                calendar.set(2, calendar.get(2));
                calendar.set(5, day);
                int currentWeekday = calendar.get(7) - 1;
                if (currentWeekday == weekday) {
                    return;
                }
                calendar.add(2, 1);
            }
            return;
        }
    }

    public static RecurrenceRule makeRecurrenceRule(ScheduleVCalendar rangeCal, String name) {
        Recurrence.Builder recBuilder = null;
        String dowName = name.toLowerCase();
        if (weekdayMap.containsKey(dowName)) {
            recBuilder = ConverterUtils.makeWeekdayRecBuilder(weekdayMap.get(dowName));
        } else if (rangeCal != null && rangeCal.getScheduleEvents().size() == 1) {
            ScheduleVEvent dateEvent = rangeCal.getScheduleEvents().get(0);
            int day = ConverterUtils.getSingleton(dateEvent.getDayOfMonth());
            int month = ConverterUtils.getSingleton(dateEvent.getMonth());
            int year = ConverterUtils.getSingleton(dateEvent.getYear());
            int weekday = ConverterUtils.getSingleton(dateEvent.getDayOfWeek());
            int weekOfMonth = ConverterUtils.getSingleton(dateEvent.getWeekOfMonth());
            recBuilder = new Recurrence.Builder(ConverterUtils.determineDateScheduleFrequency(weekday, day, month, weekOfMonth));
            Optional<Date> date = ConverterUtils.extractDate(rangeCal.getScheduleEvents().get(0), true);
            if (year != -1 && month != -1 && day != -1 && weekday != -1) {
                if (weekday >= 0 && weekday < DayOfWeek.values().length) {
                    return new RecurrenceRule(new Recurrence.Builder(Frequency.YEARLY).byDay(DayOfWeek.values()[weekday]).byMonthDay(day).byMonth(month + 1).until(date.get(), true).build());
                }
            } else if (day == 32 && month == -1) {
                recBuilder = new Recurrence.Builder(Frequency.MONTHLY).byMonthDay(-1);
            } else if (day == 33 && month == -1) {
                recBuilder = new Recurrence.Builder(Frequency.MONTHLY).byMonthDay(LAST_SEVEN_DAYS);
            } else if (day == 34 && month == -1) {
                recBuilder = new Recurrence.Builder(Frequency.MONTHLY).byMonthDay(ODD_DAYS);
            } else if (day == 35 && month == -1) {
                recBuilder = new Recurrence.Builder(Frequency.MONTHLY).byMonthDay(EVEN_DAYS);
            } else if (month == 12 && day == -1) {
                recBuilder = new Recurrence.Builder(Frequency.DAILY).byMonth(ODD_MONTHS);
            } else if (month == 13 && day == -1) {
                recBuilder = new Recurrence.Builder(Frequency.DAILY).byMonth(EVEN_MONTHS);
            } else {
                if (day != -1) {
                    recBuilder.byMonthDay(day);
                }
                if (month != -1) {
                    recBuilder.byMonth(month + 1);
                }
            }
            if (weekday >= 0 && weekday < DayOfWeek.values().length) {
                if (weekOfMonth != -1 && weekOfMonth > 0 && weekOfMonth < 6) {
                    recBuilder.byDay(weekOfMonth, DayOfWeek.values()[weekday]);
                } else {
                    recBuilder.byDay(DayOfWeek.values()[weekday]);
                }
            }
            if (year != -1) {
                Calendar calendar = Calendar.getInstance();
                calendar.set(year, 11, 31);
                recBuilder.until(Optional.of(calendar.getTime()).get(), true);
            }
        } else if (rangeCal != null && rangeCal.getScheduleEvents().size() == 2) {
            ScheduleVEvent rangeStart = rangeCal.getScheduleEvents().get(0);
            ScheduleVEvent rangeEnd = rangeCal.getScheduleEvents().get(1);
            int startDay = ConverterUtils.getSingleton(rangeStart.getDayOfMonth());
            int startMonth = ConverterUtils.getSingleton(rangeStart.getMonth());
            int startYear = ConverterUtils.getSingleton(rangeStart.getYear());
            int endDay = ConverterUtils.getSingleton(rangeEnd.getDayOfMonth());
            int endMonth = ConverterUtils.getSingleton(rangeEnd.getMonth());
            int endYear = ConverterUtils.getSingleton(rangeEnd.getYear());
            recBuilder = new Recurrence.Builder(ConverterUtils.determineDateRangeFrequency(startDay, startMonth, startYear, endDay, endMonth, endYear));
            if (startMonth == -1 && endMonth == -1 && (startDay == -1 && endDay != -1 || startDay != -1 && endDay == -1 || startDay != -1 && endDay != -1)) {
                startDay = startDay == -1 ? 1 : startDay;
                int n = endDay = endDay == -1 ? 31 : endDay;
                if (startYear != endYear || endDay < startDay) {
                    return null;
                }
                Calendar calendar = Calendar.getInstance();
                calendar.set(endYear, 11, 31, 0, 0, 0);
                Collection dateRange = IntStream.rangeClosed(startDay, endDay).boxed().collect(Collectors.toList());
                recBuilder.byMonthDay(dateRange).until(calendar.getTime(), true);
            }
        }
        assert (recBuilder != null);
        return new RecurrenceRule(recBuilder.build());
    }

    private static Frequency determineDateScheduleFrequency(int weekday, int day, int month, int weekOfMonth) {
        if (day == -1 && weekday == -1) {
            return Frequency.DAILY;
        }
        if (day == -1 && weekday != -1 && weekOfMonth == -1) {
            return Frequency.WEEKLY;
        }
        if (month == -1 && day != -1 || month == -1 && weekOfMonth != -1) {
            return Frequency.MONTHLY;
        }
        return Frequency.YEARLY;
    }

    private static Frequency determineDateRangeFrequency(int startDay, int startMonth, int startYear, int endDay, int endMonth, int endYear) {
        if (startMonth == -1 && endMonth == -1 && startYear == endYear && (startDay == -1 && endDay != -1 || startDay != -1 && endDay == -1 || startDay != -1 && endDay != -1)) {
            return Frequency.MONTHLY;
        }
        return Frequency.DAILY;
    }

    public static RecurrenceRule makeWeekdayRecurrenceRule(DayOfWeek dow, Date end) {
        Recurrence.Builder recBuilder = ConverterUtils.makeWeekdayRecBuilder(dow);
        if (end != null) {
            return new RecurrenceRule(recBuilder.until(end, true).build());
        }
        return new RecurrenceRule(recBuilder.build());
    }

    public static int getCurrentYear() {
        return Calendar.getInstance().get(1);
    }

    public static Recurrence.Builder makeWeekdayRecBuilder(DayOfWeek dow) {
        return new Recurrence.Builder(Frequency.WEEKLY).byDay(dow);
    }

    private static int getSingleton(IntervalProperty property) {
        if (property == null || property.getValues() == null) {
            return -1;
        }
        List values = property.getValues();
        if (values.size() > 1) {
            return -2;
        }
        if (values.isEmpty()) {
            return -1;
        }
        return (Integer)property.getValues().get(0);
    }

    public static Date localDate(BTime t) {
        long sm = t.getTimeOfDayMillis();
        LocalDate epochStart = LocalDate.of(ConverterUtils.getCurrentYear(), 1, 1);
        LocalDateTime st = LocalDateTime.of(epochStart, LocalTime.ofSecondOfDay(sm / 1000L));
        return Date.from(st.atZone(ZoneId.systemDefault()).toInstant());
    }

    public static Date combineDates(Date baseDate, ICalDate timeOnly) {
        Calendar baseCal = Calendar.getInstance();
        baseCal.setTime(baseDate);
        Calendar timeCal = Calendar.getInstance();
        timeCal.setTime(timeOnly);
        baseCal.set(11, timeCal.get(11));
        baseCal.set(12, timeCal.get(12));
        baseCal.set(13, timeCal.get(13));
        baseCal.set(14, timeCal.get(14));
        return baseCal.getTime();
    }

    public static void applyRange(ScheduleVCalendar rangeCal, ScheduleVCalendar cal) {
        List<ScheduleVEvent> rangeEvents = rangeCal.getScheduleEvents();
        if (rangeEvents.isEmpty()) {
            return;
        }
        Optional<Date> rangeStart = ConverterUtils.extractDate(rangeCal.getScheduleEvents().get(0), true);
        Optional<Date> rangeEnd = rangeEvents.size() > 1 ? ConverterUtils.extractDate(rangeCal.getScheduleEvents().get(1), false) : Optional.empty();
        for (ScheduleVEvent e : cal.getScheduleEvents()) {
            ConverterUtils.computeRange(e, rangeStart, rangeEnd);
        }
    }

    public static void computeRange(ScheduleVEvent e, Optional<Date> rangeStart, Optional<Date> rangeEnd) {
        DateStart eventStart = e.getDateStart();
        DateEnd eventEnd = e.getDateEnd();
        if (!rangeStart.isPresent()) {
            rangeStart = Optional.of(DEFAULT_START_DATE);
        }
        Date rangeStartDate = rangeStart.get();
        Date rangeStartNextDay = new Date();
        rangeStartNextDay.setTime(rangeStartDate.getTime() + 86400000L);
        long rangeStartTime = rangeStartDate.getTime();
        if (eventStart != null && eventStart.getValue() != null && rangeStartTime > ((ICalDate)eventStart.getValue()).getTime()) {
            e.setDateStart(ConverterUtils.combineDates(rangeStart.get(), (ICalDate)eventStart.getValue()));
        }
        if (eventEnd != null && eventEnd.getValue() != null && rangeStartTime > ((ICalDate)eventEnd.getValue()).getTime()) {
            e.setDateEnd(ConverterUtils.combineDates(ConverterUtils.isEndOfDay(eventEnd) ? rangeStartNextDay : rangeStartDate, (ICalDate)eventEnd.getValue()));
        }
        if (rangeEnd.isPresent()) {
            Date rend = rangeEnd.get();
            if (e.getRecurrenceRule() == null) {
                Recurrence newRec = new Recurrence.Builder(Frequency.DAILY).until(rend, true).build();
                e.setRecurrenceRule(new RecurrenceRule(newRec));
            } else {
                RecurrenceRule existingRule = e.getRecurrenceRule();
                ICalDate existingUntil = ((Recurrence)existingRule.getValue()).getUntil();
                if (existingUntil == null || existingUntil.getTime() > rend.getTime()) {
                    Recurrence newRec = new Recurrence.Builder((Recurrence)existingRule.getValue()).until(rend, true).build();
                    e.setRecurrenceRule(new RecurrenceRule(newRec));
                }
            }
        }
    }

    public static boolean isEndOfDay(DateEnd d) {
        Calendar c = Calendar.getInstance();
        c.setTime((Date)d.getValue());
        return c.get(11) == 0 && c.get(12) == 0 && c.get(13) == 0;
    }

    public static void adjustEndOfDay(VEvent event) {
        if (event == null) {
            return;
        }
        DateEnd dateEnd = event.getDateEnd();
        if (dateEnd != null && ((ICalDate)dateEnd.getValue()).hasTime() && ConverterUtils.isEndOfDay(dateEnd)) {
            long endMs = ((ICalDate)dateEnd.getValue()).getTime();
            event.setDateEnd(new Date(endMs + 86400000L));
        }
    }

    public static String getControlScheduleType(ScheduleVCalendar ical) {
        NiagaraClass propScheduleType = ical.getNiagaraClass();
        return propScheduleType != null ? (String)propScheduleType.getValue() : "";
    }

    public static boolean isWeekday(ScheduleVEvent event) {
        if (event == null) {
            return false;
        }
        NiagaraClass niagaraClass = event.getNiagaraClass();
        return CloudLinkConstants.WEEKDAY_SCHEDULE_TS.equals(niagaraClass.getValue());
    }

    public static Optional<Frequency> getFrequency(ScheduleVEvent event) {
        if (event == null) {
            return Optional.empty();
        }
        RecurrenceRule recurrenceRule = event.getRecurrenceRule();
        if (recurrenceRule == null) {
            return Optional.empty();
        }
        Recurrence recurrence = (Recurrence)recurrenceRule.getValue();
        if (recurrence == null) {
            return Optional.empty();
        }
        return Optional.of(((Recurrence)recurrenceRule.getValue()).getFrequency());
    }

    public static boolean hasWeeklyFrequency(ScheduleVEvent event) {
        Optional<Frequency> optFreq = ConverterUtils.getFrequency(event);
        return optFreq.isPresent() && Frequency.WEEKLY.equals((Object)optFreq.get());
    }

    public static boolean isNotRecurring(ScheduleVEvent event) {
        if (event == null) {
            return false;
        }
        return !ConverterUtils.getFrequency(event).isPresent();
    }

    public static boolean isRecurringRegularly(ScheduleVEvent event) {
        Optional<Frequency> optFreq = ConverterUtils.getFrequency(event);
        return optFreq.isPresent() && (Frequency.YEARLY.equals((Object)optFreq.get()) || Frequency.MONTHLY.equals((Object)optFreq.get()) || Frequency.WEEKLY.equals((Object)optFreq.get()) || Frequency.DAILY.equals((Object)optFreq.get()));
    }

    public static Optional<String> getScheduleUid(BAbstractSchedule schedule) {
        BFacets scheduleUids = ConverterUtils.getScheduleUids(schedule);
        BObject uid = scheduleUids.get(ConverterUtils.getUidKey(schedule));
        return uid == null ? Optional.empty() : Optional.of(uid.toString());
    }

    public static void assignUid(BAbstractSchedule schedule, VEvent vevent) {
        Optional optCloudId = TagUtil.getCloudId((BComponent)schedule);
        if (optCloudId.isPresent()) {
            vevent.setUid(((BIDataValue)optCloudId.get()).toString());
        } else {
            String uidKey;
            BFacets scheduleUids = ConverterUtils.getScheduleUids(schedule);
            BObject scheduleUid = scheduleUids.get(uidKey = ConverterUtils.getUidKey(schedule));
            if (scheduleUid != null) {
                vevent.setUid(scheduleUid.toString());
            } else {
                String uid = ConverterUtils.addUid(scheduleUids, uidKey, schedule);
                vevent.setUid(uid);
            }
        }
    }

    private static String getUidKey(BAbstractSchedule schedule) {
        Objects.requireNonNull(schedule, "schedule must not be null");
        return "h" + schedule.getHandle();
    }

    private static String addUid(BFacets scheduleUids, String uidKey, BAbstractSchedule schedule) {
        String uid = ConverterUtils.generateUidString();
        BFacets newUids = BFacets.make((BFacets)scheduleUids, (String)uidKey, (BIDataValue)BString.make((String)uid));
        CompUtil.setOrAdd((BComponent)schedule.getRootSchedule(), (String)SCHEDULE_UIDS_PROP_NAME, (BValue)newUids, (int)5, null, null);
        return uid;
    }

    private static String generateUidString() {
        return UUID.randomUUID().toString();
    }

    private static BFacets getScheduleUids(BAbstractSchedule schedule) {
        BAbstractSchedule root = schedule.getRootSchedule();
        Property pFacets = root.getProperty(SCHEDULE_UIDS_PROP_NAME);
        if (pFacets != null && pFacets.getType().is(BFacets.TYPE)) {
            return (BFacets)root.get(pFacets);
        }
        pFacets = CompUtil.setOrAdd((BComponent)root, (String)SCHEDULE_UIDS_PROP_NAME, (BValue)BFacets.DEFAULT, (int)5, null, null);
        return (BFacets)root.get(pFacets);
    }

    static {
        weekdayMap.put("sunday", DayOfWeek.SUNDAY);
        weekdayMap.put("monday", DayOfWeek.MONDAY);
        weekdayMap.put("tuesday", DayOfWeek.TUESDAY);
        weekdayMap.put("wednesday", DayOfWeek.WEDNESDAY);
        weekdayMap.put("thursday", DayOfWeek.THURSDAY);
        weekdayMap.put("friday", DayOfWeek.FRIDAY);
        weekdayMap.put("saturday", DayOfWeek.SATURDAY);
        ODD_MONTHS = IntStream.range(1, 12).filter(i -> i % 2 != 0).boxed().collect(Collectors.toList());
        EVEN_MONTHS = IntStream.range(2, 13).filter(i -> i % 2 == 0).boxed().collect(Collectors.toList());
        ODD_DAYS = IntStream.range(1, 32).filter(i -> i % 2 != 0).boxed().collect(Collectors.toList());
        EVEN_DAYS = IntStream.range(2, 31).filter(i -> i % 2 == 0).boxed().collect(Collectors.toList());
        LAST_SEVEN_DAYS = IntStream.range(-7, 0).boxed().collect(Collectors.toList());
        Calendar startCal = Calendar.getInstance();
        startCal.set(ConverterUtils.getCurrentYear(), 0, 1);
        DEFAULT_START_DATE = startCal.getTime();
        log = Logger.getLogger("cloudLink.channel.schedule");
    }
}

